<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\PateintController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\ProvidersController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\WebController;
use App\Http\Controllers\CmsController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\ClovermerchentController;
use Illuminate\Support\Facades\Redirect;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Auth::routes();

Route::get('/', [WebController::class, 'webHome'])->name('web.home');
Route::get('/about-us', [WebController::class, 'webAboutus'])->name('web.Aboutus');
Route::get('/privacy-policy', [WebController::class, 'privacyPolicy'])->name('web.privacyPolicy');
Route::get('/customer-care', [WebController::class, 'customerCare'])->name('web.customerCare');
Route::get('/acupunture', [WebController::class, 'webAcupunture'])->name('web.Acupunture');
Route::get('/allergy', [WebController::class, 'webAllergy'])->name('web.Allergy');
Route::get('/cancer', [WebController::class, 'webCancer'])->name('web.Cancer');
Route::get('/circulation', [WebController::class, 'webCirculation'])->name('web.Circulation');
Route::get('/common-conditions', [WebController::class, 'webCommonConditions'])->name('web.CommonConditions');
Route::get('/consulting', [WebController::class, 'webConsulting'])->name('web.Consulting');
Route::post('/appointment', [WebController::class, 'webAppointment'])->name('web.Appointment');
Route::get('/contact', [WebController::class, 'webContact'])->name('web.Contact');
Route::post('/contact/submit', [WebController::class, 'contactSubmit'])->name('web.contactSubmit');
Route::get('/cosmetic-acupunture', [WebController::class, 'webCosmeticAcupunture'])->name('web.CosmeticAcupunture');
Route::get('/digestive', [WebController::class, 'webDigestive'])->name('web.Digestive');
Route::get('/event', [WebController::class, 'webEvent'])->name('web.Event');
Route::get('/faq', [WebController::class, 'webFaq'])->name('web.Faq');
Route::get('/hormone', [WebController::class, 'webHormone'])->name('web.Hormone');
Route::get('/immune', [WebController::class, 'webImmune'])->name('web.Immune');
Route::get('/joint-injured', [WebController::class, 'webJointInjured'])->name('web.JointInjured');
Route::get('/mental-health', [WebController::class, 'webMentalHealth'])->name('web.MentalHealth');
Route::get('/metabolism', [WebController::class, 'webMetabolism'])->name('web.Metabolism');
Route::get('/muscular', [WebController::class, 'webMuscular'])->name('web.Muscular');
Route::get('/neuropathy', [WebController::class, 'webNeuropathy'])->name('web.Neuropathy');
Route::get('/our-providers', [WebController::class, 'webOurProviders'])->name('web.OurProviders');
Route::get('/prescription', [WebController::class, 'webPrescription'])->name('web.Prescription');
Route::get('/pricing', [WebController::class, 'webPricing'])->name('web.Pricing');
Route::get('/primary-care', [WebController::class, 'webPrimaryCare'])->name('web.PrimaryCare');
Route::get('/providers', [WebController::class, 'webProviders'])->name('web.Providers');
Route::get('/reproductive', [WebController::class, 'webReproductive'])->name('web.Reproductive');
Route::get('/respiratory', [WebController::class, 'webRespiratory'])->name('web.Respiratory');
Route::get('/services', [WebController::class, 'webServices'])->name('web.Services');
Route::get('/service-detail/{slug}', [WebController::class, 'webServicesDetail'])->name('web.ServicesDetail');
Route::get('/signin', [WebController::class, 'webLogin'])->name('web.Login');
Route::post('/signin/submit', [WebController::class, 'LoginSubmit'])->name('web.LoginSubmit');
Route::get('/user/registeration', [WebController::class, 'webUserRegister'])->name('web.UserRegister');
Route::post('/registeration', [WebController::class, 'RegisterSubmit'])->name('web.RegisterSubmit');
Route::get('/forgot/password', [WebController::class, 'webForgotPassword'])->name('web.ForgotPassword');
Route::post('/search/email', [WebController::class, 'webSearchEmail'])->name('web.SearchEmail');
Route::get('/enter/otp', [WebController::class, 'webEnterOtp'])->name('web.EnterOtp');
Route::post('/otp/submit', [WebController::class, 'webSubmitOtp'])->name('web.SubmitOtp');
Route::get('/DPC/agreement', [WebController::class, 'DPCAgreementForms'])->name('web.agreementForms');
Route::get('/acupuncture/intake/form', [WebController::class, 'acupunctureIntakeForm'])->name('web.acupunctureIntakeForm');
Route::get('/carolyn/intake/form', [WebController::class, 'carolynIntakeForm'])->name('web.carolynIntakeForm');

Route::group(['middleware' => 'auth'], function () {
    Route::group(['middleware' => 'CheckProfileCompletion'], function () {
        Route::get('/home', [HomeController::class, 'adminHome'])->name('admin.home')->middleware('checkSubscription');
        Route::get('/password/edit', [HomeController::class, 'PasswordEdit'])->name('admin.PasswordEdit');
        Route::post('/password/update', [HomeController::class, 'PasswordUppdate'])->name('admin.PasswordUppdate');
        Route::get('/user/chat', [ChatController::class, 'usersChat'])->name('admin.usersChat')->middleware('checkSubscription');
        Route::get('/notification/markasread', [HomeController::class, 'markAsRead'])->name('admin.markAsRead');
    });
    Route::get('/Profile/edit/{id?}', [HomeController::class, 'profileEdit'])->name('admin.profileEdit');
    Route::post('/Profile/update', [HomeController::class, 'profileUpdate'])->name('admin.profileUpdate');

    Route::post('/appointments/delete', [HomeController::class, 'memberAppointmentDelete'])->name('admin.memberAppointmentDelete');
    Route::post('/chat/send-messages', [ChatController::class, 'sendMessages'])->name('admin.sendMessages');
    Route::get('/chat/get-messages', [ChatController::class, 'getChatMessages'])->name('admin.getChatMessages');
    Route::post('/chat/mark-messages-as-read', [ChatController::class, 'markMessagesAsRead'])->name('admin.markMessagesAsRead');

    Route::post('/patient/reports/save', [HomeController::class, 'patientreportsSave'])->name('admin.patientreportsSave');
    Route::post('/patient/reports/delete', [HomeController::class, 'patientreportsDelete'])->name('admin.patientreportsDelete');

    Route::get('/patient/rooms', [HomeController::class, 'getRooms'])->name('admin.getRooms');
    Route::get('/appointment/check-in', [HomeController::class, 'appointmentCheckIn'])->name('admin.appointmentCheckIn');
    Route::get('/appointment/check-out', [HomeController::class, 'appointmentCheckOut'])->name('admin.appointmentCheckOut');
    Route::post('/appointment/re-schedile', [HomeController::class, 'reScheduleAppointment'])->name('admin.reScheduleAppointment');

    Route::get('/laboratory/view', [HomeController::class, 'laboratoryView'])->name('admin.laboratoryView');
    Route::get('/laboratory/create/{id}', [HomeController::class, 'laboratoryCreate'])->name('admin.laboratoryCreate');
    Route::post('/laboratory/save', [HomeController::class, 'laboratorySave'])->name('admin.laboratorySave');
    Route::post('/laboratory/delete', [HomeController::class, 'laboratoryDelete'])->name('admin.laboratoryDelete');

    Route::get('/pharmaceutical/view', [HomeController::class, 'pharmaceuticalView'])->name('admin.pharmaceuticalView');
    Route::get('/pharmaceutical/create/{id}', [HomeController::class, 'pharmaceuticalCreate'])->name('admin.pharmaceuticalCreate');
    Route::post('/pharmaceutical/save', [HomeController::class, 'pharmaceuticalSave'])->name('admin.pharmaceuticalSave');
    Route::post('/pharmaceutical/delete', [HomeController::class, 'pharmaceuticalDelete'])->name('admin.pharmaceuticalDelete');

    Route::get('/patient/order/view/{id}', [HomeController::class, 'patientOrderView'])->name('admin.patientOrderView');
    Route::get('/patient/order/create/{id}/patient={patient}', [HomeController::class, 'patientOrderCreate'])->name('admin.patientOrderCreate');
    Route::post('/patient/order/save', [HomeController::class, 'patientOrderSave'])->name('admin.patientOrderSave');
    Route::post('/patient/order/delete', [HomeController::class, 'patientOrderDelete'])->name('admin.patientOrderDelete');
});

Route::group(['middleware' => 'isAdmin'], function () {
    Route::get('web/cms/home', [CmsController::class, 'homepage'])->name('cms.homepage');
    Route::post('web/cms/update', [CmsController::class, 'CmsUpdate'])->name('cms.update');

    Route::get('cms/about-us', [CmsController::class, 'aboutUs'])->name('admin.aboutUs');
    Route::post('cms/about-us/update', [CmsController::class, 'updateaboutUs'])->name('admin.updateaboutUs');

    Route::get('cms/customer-care', [CmsController::class, 'customerCare'])->name('admin.customerCare');
    Route::post('cms/customer-care/update', [CmsController::class, 'updateCustomerCare'])->name('admin.updateCustomerCare');

    Route::get('cms/privacy-policy', [CmsController::class, 'privacyPolicy'])->name('admin.privacyPolicy');
    Route::post('cms/privacy-policy/update', [CmsController::class, 'updateprivacyPolicy'])->name('admin.updateprivacyPolicy');

    Route::get('/logo/edit', [AdminController::class, 'logoEdit'])->name('admin.logoEdit');
    Route::post('/logo/update', [AdminController::class, 'logoUpdate'])->name('admin.logoUpdate');
    Route::get('/config/edit', [AdminController::class, 'configEdit'])->name('admin.configEdit');
    Route::post('/config/update', [AdminController::class, 'configUpdate'])->name('admin.configUpdate');

    Route::get('/contact/inquiry', [AdminController::class, 'contactInquiry'])->name('admin.contactInquiry');
    Route::get('/contact/inquiry/delete/{id}', [AdminController::class, 'contactInquiryDelete'])->name('admin.inquiryDelete');

    Route::get('/service/view', [AdminController::class, 'servicesView'])->name('admin.servicesView');
    Route::get('/service/detail/{id}', [AdminController::class, 'servicesDetail'])->name('admin.servicesDetail');
    Route::get('/service/create/{id}', [AdminController::class, 'servicesCreate'])->name('admin.servicesCreate');
    Route::post('/service/update', [AdminController::class, 'servicesUpdate'])->name('admin.servicesUpdate');
    Route::post('/service/delete', [AdminController::class, 'servicesDelete'])->name('admin.servicesDelete');

    Route::get('/testimonials/view', [AdminController::class, 'testimonialsView'])->name('admin.testimonialsView');
    Route::get('/testimonials/detail/{id}', [AdminController::class, 'testimonialsDetail'])->name('admin.testimonialsDetail');
    Route::get('/testimonials/create/{id}', [AdminController::class, 'testimonialsCreate'])->name('admin.testimonialsCreate');
    Route::post('/testimonials/update', [AdminController::class, 'testimonialsUpdate'])->name('admin.testimonialsUpdate');
    Route::post('/testimonials/delete', [AdminController::class, 'testimonialsDelete'])->name('admin.testimonialsDelete');

    Route::get('/non-member/appointment-list', [AdminController::class, 'ApppointmentList'])->name('admin.ApppointmentList');
    Route::get('/non-member/appointment-list/destroy/{id}', [AdminController::class, 'appointmentDelete'])->name('admin.appointmentDelete');

    Route::get('/providers/list', [AdminController::class, 'providerList'])->name('admin.providerList');
    Route::get('/staff/list', [AdminController::class, 'staffList'])->name('admin.staffList');
    Route::get('/patient/list', [AdminController::class, 'pateintList'])->name('admin.pateintList');
    Route::get('/providers/create', [AdminController::class, 'providerCreate'])->name('admin.providerCreate');
    Route::get('/staff/create', [AdminController::class, 'staffCreate'])->name('admin.staffCreate');
    Route::post('/providers/update', [AdminController::class, 'providerAdd'])->name('admin.providerAdd');
    Route::post('/profile/delete', [AdminController::class, 'deleteProfile'])->name('admin.deleteProfile');
    Route::post('/password/change', [AdminController::class, 'USerPasswordManage'])->name('admin.USerPasswordManage');

    Route::get('/patient/documents/list/{id}', [AdminController::class, 'patientDocuments'])->name('admin.patientDocuments');
    Route::get('/patient/reports/{id}', [AdminController::class, 'patientreportsList'])->name('admin.patientreportsList');

    Route::get('/packages/view', [AdminController::class, 'packageView'])->name('admin.packageView');
    Route::get('/packages/create/{id}', [AdminController::class, 'packageCreate'])->name('admin.packageCreate');
    Route::post('/packages/save', [AdminController::class, 'packageSave'])->name('admin.packageSave');
    Route::post('/packages/delete', [AdminController::class, 'packageDelete'])->name('admin.packageDelete');

    Route::get('/all-appointments', [AdminController::class, 'allAppointmentFilter'])->name('admin.allAppointmentFilter');

    Route::get('/announcement/view', [AdminController::class, 'announcementView'])->name('admin.announcemenView');
    Route::get('/announcement/create/{id}', [AdminController::class, 'announcementCreate'])->name('admin.announcemenCreate');
    Route::post('/announcement/save', [AdminController::class, 'announcementSave'])->name('admin.announcemenSave');

    Route::get('/admin/patient/medical-profile/{id}', [AdminController::class, 'medicalProfilePatient'])->name('admin.medicalProfilePatient');
    Route::get('/patient/medication/report/{id}', [AdminController::class, 'medicationReport'])->name('admin.medicationReport');
});

Route::group(['middleware' => 'isProviders'], function () {
    Route::get('/rooms/view', [ProvidersController::class, 'roomsView'])->name('admin.roomsView')->middleware('CheckProfileCompletion');
    Route::get('/rooms/create/{id}', [ProvidersController::class, 'roomsCreate'])->name('admin.roomsCreate');
    Route::post('/rooms/update', [ProvidersController::class, 'roomsUpdate'])->name('admin.roomsUpdate');
    Route::post('/rooms/delete', [ProvidersController::class, 'roomsDelete'])->name('admin.roomsDelete');

    Route::get('/member-patient/appointment/list', [ProvidersController::class, 'providerAppointmnetList'])->name('admin.providerAppointmnetList')->middleware('CheckProfileCompletion');
    Route::post('/appointment/status', [ProvidersController::class, 'patientAppointmnetStatus'])->name('admin.patientAppointmnetStatus');

    Route::get('/providers/patients/list', [ProvidersController::class, 'providerPateints'])->name('admin.providerPateints')->middleware('CheckProfileCompletion');
    Route::get('/providers/patient/documents/{id}', [ProvidersController::class, 'patientDocumentsByProviders'])->name('admin.patientDocumentsByProviders');
    Route::get('/providers/patient/reports/{id}', [ProvidersController::class, 'patientreportsByProviders'])->name('admin.patientreportsByProviders');
    Route::get('/providers/appointment/reports/{id}', [ProvidersController::class, 'reportAgainstAppointment'])->name('admin.reportAgainstAppointment');
    Route::post('/providers/appointment/reports/save', [ProvidersController::class, 'reportAgainstAppointmentSave'])->name('admin.reportAgainstAppointmentSave');
    Route::post('/patient/appointment/reports/delete', [ProvidersController::class, 'reportAgainstAppointmentDelete'])->name('admin.reportAgainstAppointmentDelete');

    Route::get('/patient/medical-profile/{id}', [ProvidersController::class, 'patientMedicalProfile'])->name('admin.patientMedicalProfile');

    Route::get('/appointment/medication/{id}', [ProvidersController::class, 'medicationHistory'])->name('admin.medicationHistory');
    Route::post('/appointment/medication/save', [ProvidersController::class, 'medicationHistorySave'])->name('admin.medicationHistorySave');
});

Route::group(['middleware' => 'isStaff'], function () {
    Route::get('/member-patient/appointments/list', [StaffController::class, 'staffAppointmnetList'])->name('admin.staffAppointmnetList')->middleware('CheckProfileCompletion');
    Route::get('/member-patient/approve/appointments', [StaffController::class, 'approvedAppointmnets'])->name('admin.approvedAppointmnets')->middleware('CheckProfileCompletion');
    Route::get('/staff/patient/list', [StaffController::class, 'inStaffPatientList'])->name('admin.inStaffPatientList')->middleware('CheckProfileCompletion');
});

Route::group(['middleware' => 'isPatient'], function () {
    Route::group(['middleware' => 'checkSubscription'], function () {
        Route::get('/patient/appointment', [PateintController::class, 'patientAppointmnet'])->name('admin.patientAppointmnet')->middleware('CheckProfileCompletion');
        Route::post('/patient/appointment/submit', [PateintController::class, 'patientAppointmnetSubmit'])->name('admin.patientAppointmnetSubmit');
        Route::get('/appointment/list', [PateintController::class, 'patientAppointmnetList'])->name('admin.patientAppointmnetList')->middleware('CheckProfileCompletion');
        Route::get('/appointment-reports/list/{id}', [PateintController::class, 'patientAppointmnetReports'])->name('admin.patientAppointmnetReports');
        Route::post('/appointment/cancel', [PateintController::class, 'patientAppointmnetCancel'])->name('admin.patientAppointmnetCancel');
        Route::get('/patient/documents', [PateintController::class, 'patientDocumentsList'])->name('admin.patientDocumentsList')->middleware('CheckProfileCompletion');
        Route::get('/patient-reports', [PateintController::class, 'ReportsDocumentList'])->name('admin.ReportsDocumentList')->middleware('CheckProfileCompletion');
        Route::post('/patient/documents/save', [PateintController::class, 'patientDocumnetSave'])->name('admin.patientDocumnetSave');
        Route::post('/patient/documents/delete', [PateintController::class, 'patientDocumnetDelete'])->name('admin.patientDocumnetDelete');
        Route::get('/patient/redflag', [PateintController::class, 'patientRedFlag'])->name('admin.patientRedFlag');
        Route::post('/patient/redflag/save', [PateintController::class, 'patientRedFlagSave'])->name('admin.patientRedFlagSave');
        Route::post('/patient/redflag/delete', [PateintController::class, 'patientRedFlagDelete'])->name('admin.patientRedFlagDelete');
        Route::get('/patient/payment-history', [PateintController::class, 'paymentHistory'])->name('admin.paymentHistory')->middleware('CheckProfileCompletion');
        Route::get('/patient/membership', [PateintController::class, 'membershipManage'])->name('admin.membershipManage')->middleware('CheckProfileCompletion');
        Route::post('/patient/cancel/membershp', [PateintController::class, 'cancelMembership'])->name('admin.cancelMembership');
        Route::get('/medical-profile', [PateintController::class, 'medicalProfileAccess'])->name('admin.medicalProfileAccess')->middleware('CheckProfileCompletion');
        Route::post('/medical-profile/access', [PateintController::class, 'profileAccessSubmit'])->name('admin.profileAccessSubmit');
    });
    Route::get('/buypackages/view', [PateintController::class, 'webPackagesView'])->name('web.webPackagesView');
    Route::get('/purchase-package/{id}', [PateintController::class, 'webPackagesPurchase'])->name('web.PackagesPurchase');
    Route::post('/cloverApi', [ClovermerchentController::class, 'cloverApi'])->name('cloverApi');
});

Route::get('/logout', function () {
    Auth::logout();
    return Redirect::to('/');
});
