@extends('web.layouts.master')
@section('content')
    <section class="section1-services">
        <div class="container-fluid">
            <h1 class="display-2 text-center sec-services-heading sec-heading">SERVICES</h1>
            <p class="text-center services-parah"><a href="{{ route('web.home') }}" class="services-parah">HOME &nbsp</a>/<a
                    href="{{ route('web.Services') }}" class="services-parah">&nbsp SERVICES</a></p>
        </div>
    </section>

    <section class="services-text my-5">
        <h3>Our Service</h3>
        <p>Welcome to Holistic Integrated Medicine, where we provide a comprehensive approach to healthcare.
            <br />From primary care services for your basic medical needs to alternative therapies like acupuncture and
            cupping, we offer a diverse range of treatments to address your health concerns.
            <br />Our carefully selected herbal supplements complement these therapies, promoting holistic well-being and
            empowering you on your path to optimal health.
            <br />Experience the blend of modern medicine and traditional healing practices at Holistic IM, where your
            wellness is our priority. <a href="tel:425-818-0505">Call us now</a> to get more information.
        </p>
        </div>
    </section>

    <section class=" mb-5">
        <div class="container services">
            <div class="row my-5">
                @foreach ($service as $item)
                    <div class="col-12 col-sm-12 col-xl-4 col-lg-4 col-md-4">
                        <div class="card">
                            <img src="{{ asset($item->image ?? '') }}" class="card-img-top" alt="...">
                            <div class="card-body">
                                <h5 class="card-title">{{ $item->title ?? '' }}</h5>
                                <p class="card-text">{!! $item->short_desc ?? '' !!}</p>
                                <a href="{{ route('web.ServicesDetail', $item->slug) }}" class="btn services-btn">See Details</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
