@extends('web.layouts.master')
@section('content')
    <section class="section1-services">
        <div class="container-fluid">
            <h1 class="display-2 text-center sec-services-heading sec-heading">Joint Injured</h1>
            <p class="text-center services-parah"><a href="{{ route('web.home') }}" class="services-parah">HOME &nbsp</a>/<a
                    href="{{ route('web.JointInjured') }}" class="services-parah">&nbsp Joint Injured</a></p>
        </div>
    </section>
    <section class="section2-services mb-5">
        <div class="container">
            <div>
                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                    <h1 class="display-1 text-center  mt-5 sec-heading">Joint Injured</h1>
                    <img src="https://gearuptofit.com/wp-content/uploads/2020/11/Could-running-too-much-be-bad-for-your-health-3.jpg"
                        alt="" class="img-fluid image-service w-75 mx-auto d-block my-5">
                    <h4 class="serviceHeading">Holistic Care for Joint Injuries at Holistic Integrated Medicine</h4>
                    <p class="service-text">Joint injuries can significantly impact mobility, comfort, and overall quality
                        of life. At Holistic Integrated Medicine, we understand the challenges associated with joint
                        injuries and offer thorough care to support healing, relieve pain, and restore function using a
                        holistic approach.</p>
                    <h5 class="serviceHeadingTwo">Understanding Joint Injuries</h5>
                    <p class="service-text">Joint injuries can occur as a result of trauma, repetitive strain, overuse, or
                        degenerative changes in the joints. Common joint injuries include sprains, strains, dislocations,
                        and fractures, as well as conditions such as osteoarthritis and rheumatoid arthritis. Symptoms of
                        joint injuries may include:</p>
                    <ul class="service-text">
                        <li>• Pain, swelling, and tenderness around the affected joint</li>
                        <li>• Limited range of motion and stiffness</li>
                        <li>• Instability or feeling of "giving way" in the joint</li>
                        <li>• Weakness and muscle atrophy</li>
                        <li>• Difficulty performing daily activities or participating in sports and recreational activities
                        </li>
                    </ul>
                    <h5 class="serviceHeadingTwo">Our Approach to Joint Injury Care</h5>
                    <p class="service-text">At Holistic Integrated Medicine, we take a multidisciplinary approach to joint
                        injury care, addressing the underlying factors contributing to the injury and providing personalized
                        treatment plans to support healing and rehabilitation. Our approach may include:</p>
                    <p class="service-text"><strong>Thorough Evaluation: </strong> Comprehensive assessment of the joint
                        injury, including physical examination, imaging studies, and evaluation of biomechanics and
                        functional movement patterns, to determine the extent of the injury and develop an individualized
                        treatment plan.</p>
                    <p class="service-text"><strong>Pain Management: </strong> Utilization of various modalities, including
                        medications, injections, and natural remedies, to relieve pain and inflammation associated with
                        joint injuries.</p>
                    <p class="service-text"><strong>Physical Therapy: </strong> Tailored exercise programs, manual therapy
                        techniques, and functional rehabilitation to improve strength, flexibility, and range of motion in
                        the affected joint and surrounding musculature.</p>
                    <p class="service-text"><strong>Regenerative Therapies: </strong> Incorporation of regenerative
                        treatments such as platelet-rich plasma (PRP) therapy, prolotherapy, and stem cell therapy to
                        promote tissue repair and regeneration in damaged joints.</p>
                    <p class="service-text"><strong>Nutritional Support: </strong> Guidance on dietary modifications and
                        nutritional supplements to support joint health, reduce inflammation, and optimize healing.</p>
                    <p class="service-text"><strong>Lifestyle Modifications: </strong> Recommendations for activity
                        modification, ergonomic adjustments, and adaptive devices to prevent further injury and promote
                        joint health and longevity.</p>
                    <h5 class="serviceHeadingTwo">Empowering You to Heal and Thrive</h5>
                    <p class="service-text">At Holistic Integrated Medicine, we are committed to empowering individuals to
                        take an active role in their recovery from joint injuries and regain optimal function and quality of
                        life. Our experienced team of practitioners is dedicated to providing compassionate care,
                        personalized support, and evidence-based interventions to help you heal and thrive.</p><br>
                    <h5 class="serviceHeadingTwo">Ready to Restore Function and Comfort?</h5>
                    <p class="service-text">If you're dealing with a joint injury and seeking thorough care to support your
                        recovery, Holistic Integrated Medicine is here to help. Contact us today to schedule a consultation
                        and explore our range of joint injury care services.</p><br>
                    <p class="service-text">Your journey to healing, rehabilitation, and restored function begins at
                        Holistic Integrated Medicine.</p><br>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('css')
    <style>
        .serviceHeading {
            text-align: center;
            color: #2bb7e1;
        }

        .serviceHeadingTwo {
            text-align: center;
            margin-top: 18px;
            font-size: 24px;
        }
    </style>
@endsection
