@extends('web.layouts.master')
@section('content')
    <div class="banner-sec">
        <div class="" data-aos="fade-right" data-aos-duration="1000">
            <h1 class="sec-heading fw-bold">Enter OTP</h1>
        </div>
    </div>
    <section class="register-sec-wrap">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                    <div class="form-main">
                        <div class="heads">
                            <h2>Enter OTP</h2>
                            <p>Please enter the OTP sent to your email address and your new password.</p>
                        </div>
                        <form action="{{ route('web.SubmitOtp') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="email">Email<span>*</span></label>
                                        <div class="input-main">
                                            <input type="email" class="form-control" name="email"
                                                placeholder="Enter email address" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="otp">OTP<span>*</span></label>
                                        <div class="input-main">
                                            <input type="text" class="form-control" name="otp"
                                                placeholder="Enter OTP" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="password">New Password<span>*</span></label>
                                        <div class="input-main">
                                            <input type="password" class="form-control" name="password"
                                                placeholder="Enter new password" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="password_confirmation">Confirm New Password<span>*</span></label>
                                        <div class="input-main">
                                            <input type="password" class="form-control" name="cnfpassword"
                                                placeholder="Confirm new password" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="btn-box">
                                        <a href="{{ route('web.Login') }}" class="btn btn-primary btn-wh">Cancel</a>
                                        <button type="submit" class="btn btn-primary btn-wh">Change Password</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('css')
    <style>
        .register-sec-wrap .form-main .btn-box {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
            flex-direction: row;
            flex-wrap: nowrap;
        }
    </style>
@endsection
@section('scripts')
    <script>
        @if (Session::has('validationerror'))
            @foreach (Session::get('validationerror') as $error)
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                }
                toastr.error("{{ $error }}");
            @endforeach
        @endif
    </script>
@endsection
