@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="#"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Update Password</li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Update Password</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation validation-fill" action="{{ route('admin.PasswordUppdate') }}" method="POST" novalidate>
                            @csrf
                            <div class="row justify-content-start">
                                <div class="col-12 col-sm-12 col-md-10 col-lg-6 col-xl-6 col-xxl-6">
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                            <label for="validationCustom001">Old Password</label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" id="validationCustom001"
                                                    placeholder="**************" name="current_password" required>

                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                            <label for="validationCustom002">New Password</label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" id="validationCustom002"
                                                    placeholder="**************" name="newpassword" required>

                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                            <label for="validationCustom003">Confirm Password</label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" id="validationCustom003"
                                                    placeholder="**************" name="cnfpassword" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        @if (Session::has('validationerror'))
            @foreach (Session::get('validationerror') as $error)
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                }
                toastr.error("{{ $error }}");
            @endforeach
        @endif
    </script>
@endsection
