@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Phone Number</th>
                                        <th scope="col">SSN</th>
                                        <th scope="col">Appointment Date & Time</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Check In</th>
                                        <th scope="col">Check Out</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($approveAppointmnets as $key => $item)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $item->name ?? '' }}</td>
                                            <td>{{ $item->phone_number ?? '' }}</td>
                                            <td>{{ $item->social_security_number ?? '-' }}</td>
                                            <td>
                                                <ul class="formatTime">
                                                    <li>
                                                        <h4>Date</h4>
                                                        <p>{{ $item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : '' }}</p>
                                                    </li>
                                                    <li>
                                                        <h4>Time</h4>
                                                        <p>{{ $item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : '' }}</p>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td>
                                                @if ($item->status == 'pending')
                                                    <h2 class="main-status pending">Pending</h2>
                                                @elseif ($item->status == 'cancel')
                                                    <h2 class="main-status cancel">Cancel</h2>
                                                @elseif ($item->status == 'completed')
                                                    <h2 class="main-status completed">Completed</h2>
                                                @else
                                                    <h2 class="main-status approve">Approve</h2>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->check_in == '')
                                                    <div class="btn-box">
                                                        <a href="javascript:;" data-id="{{ $item->id }}"
                                                            data-userid="{{ $item->user->id }}"
                                                            data-providerid="{{ $item->provider->id }}"
                                                            class="btn btn-primary checkIn">Check In</a>
                                                    </div>
                                                @else
                                                    @php
                                                        $dateTime = new \DateTime($item->check_in);
                                                        $formattedDate = $dateTime->format('F j, Y');
                                                        $formattedTime = $dateTime->format('h:i:s A');
                                                    @endphp
                                                    <ul class="formatTime">
                                                        <li>
                                                            <h4>Date</h4>
                                                            <p>{{ $formattedDate }}</p>
                                                        </li>
                                                        <li>
                                                            <h4>Time</h4>
                                                            <p>{{ $formattedTime }}</p>
                                                        </li>
                                                    </ul>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    @if ($item->is_checked == 0)
                                                        <a href="javascript:;" class="btn btn-primary notYet-error error">Check Out</a>
                                                    @else
                                                        @if ($item->check_out == '')
                                                            <div class="btn-box">
                                                                <a href="javascript:;" data-id="{{ $item->id }}"
                                                                    data-userid="{{ $item->user->id }}"
                                                                    data-providerid="{{ $item->provider->id }}"
                                                                    class="btn btn-primary notYet">Check Out</a>
                                                            </div>
                                                        @else
                                                            @php
                                                                $dateTime = new \DateTime($item->check_out);
                                                                $formattedDate = $dateTime->format('F j, Y');
                                                                $formattedTime = $dateTime->format('h:i:s A');
                                                            @endphp
                                                            <ul class="formatTime">
                                                                <li>
                                                                    <h4>Date</h4>
                                                                    <p>{{ $formattedDate }}</p>
                                                                </li>
                                                                <li>
                                                                    <h4>Time</h4>
                                                                    <p>{{ $formattedTime }}</p>
                                                                </li>
                                                            </ul>
                                                        @endif
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $('.error').click(function() {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "debug": false,
                "positionClass": "toast-bottom-right",
            }
            toastr.error("{{ session('error', 'CheckIn first') }}");
        });

        $(document).on('click', '.checkIn', function() {
            console.log('here');
            var appId = $(this).attr("data-id");
            var userId = $(this).attr("data-userid");
            var providerId = $(this).attr("data-providerid");
            console.log('appointment id', appId);
            console.log('user id', userId);
            console.log('provider id', providerId);
            $.ajax({
                type: 'GEt',
                url: '{{ route('admin.appointmentCheckIn') }}',
                datatype: 'json',
                data: {
                    id: appId,
                    user_id: userId,
                    provider_id: providerId,
                },
                success: function(data) {
                    console.log(data);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                    toastr.success(data.message);
                }
            });
        });

        $(document).on('click', '.notYet', function() {
            console.log('here');
            var appId = $(this).attr("data-id");
            var userId = $(this).attr("data-userid");
            var providerId = $(this).attr("data-providerid");
            console.log('appointment id', appId);
            console.log('user id', userId);
            console.log('provider id', providerId);
            $.ajax({
                type: 'GEt',
                url: '{{ route('admin.appointmentCheckOut') }}',
                datatype: 'json',
                data: {
                    id: appId,
                    user_id: userId,
                    provider_id: providerId,
                },
                success: function(data) {
                    console.log(data);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                    toastr.success(data.message);
                }
            });
        });
    </script>
@endsection
