@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Red Flag</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                        <a href="javascript:;" class="btn btn-primary redFlagCreate">Add Red Flag</a>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($redFlag as $key => $item)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $item->flag ?? '' }}</td>
                                            <td>
                                                <div class="btn-box">
                                                    {{-- <a href="#" class="icon-bt"><i class="fas fa-pencil-alt ms-text-primary"></i></a> --}}
                                                    <a data-id="{{ $item->id }}" class="remove-item icon-bt">
                                                        <i class="far fa-trash-alt ms-text-danger"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="redFlagModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Add Red Flag</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Red Flag</h6>
                            </div>
                            <div class="ms-panel-body">
                                <form class="needs-validation" action="{{ route('admin.patientRedFlagSave') }}" method="POST" novalidate>
                                    @csrf
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label for="validationCustom16">Enter Red Flag</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="flag"
                                                    id="validationCustom16" placeholder="Enter Red Flag" required>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-warning mt-4 d-inline w-20" type="submit">Save</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.redFlagCreate', function() {
            $('#redFlagModal').modal('show');
        });

        $(document).on('click', '.remove-item', function() {
            var ele_id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0073b1',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: "{{ route('admin.patientRedFlagDelete') }}",
                        data: {
                            id: ele_id,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            if (response.status == 0) {
                                toastr.error(response.message);
                            } else {
                                toastr.success(response.message);
                                location.reload();
                            }
                        }
                    });
                    console.log("here");
                }
            })
        });
    </script>
@endsection
