@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Package</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add Package</h6>
                        <a href="{{ route('admin.packageView') }}" class="ms-text-primary">Package List</a>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.packageSave') }}" method="POST" novalidate>
                            @csrf
                            <input type="hidden" name="package_id" value="{{ $package->id ?? '' }}">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom001">Title</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="title"
                                            value="{{ $package->title ?? '' }}" id="validationCustom001" placeholder="Title"
                                            required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom002">Price</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="price"
                                            value="{{ $package->price ?? '' }}" id="validationCustom002" placeholder="Price"
                                            required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Description</label>
                                    <div class="form-group">
                                        <textarea class="form-control tinyEditor" id="exampleTextarea1" name="desc" rows="3">{{ $package->desc ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
