@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Report</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="documents-box">
                            <div class="row">
                                @foreach ($reports as $item)
                                    <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-3 col-xxl-3">
                                        <div class="document-card">
                                            <div class="main-img">
                                                @if (in_array(strtolower(pathinfo($item->file, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'gif', 'webp']))
                                                    <img src="{{ asset($item->file) }}" alt="img" class="img-fluid">
                                                @else
                                                    <img src="{{ asset('assets/web/images/doc-img.jpg') }}" alt="img" class="img-fluid">
                                                @endif
                                            </div>
                                            <div class="desc">
                                                <h4>{{ $item->file_name }}</h4>
                                                <p>{{ round($item->file_size / 1024, 2) }} KB</p>
                                            </div>
                                            <div class="icon-list">
                                                <ul>
                                                    <li>
                                                        <a href="{{ asset($item->file) }}" download><i class="fa-solid fa-download"></i></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
