@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <!-- Chat Sidebar -->
            <div class="col-xl-4 col-md-12">
                <div class="ms-panel ms-panel-fh">
                    <div class="ms-panel-body py-3 px-0">
                        <div class="ms-chat-container">
                            <div class="ms-chat-header px-3">
                                <div class="ms-chat-user-container media clearfix">
                                    <div class="ms-chat-status ms-status-online ms-chat-img mr-3 align-self-center">
                                        <img src="{{ asset(Auth::user()->image) }}"
                                            class="ms-img-round" alt="people">
                                    </div>
                                    <div class="media-body ms-chat-user-info mt-1">
                                        <h6>{{ Auth::user()->name }}</h6>
                                    </div>
                                </div>
                                <form class="ms-form my-3" method="post">
                                    <div class="ms-form-group my-0 mb-0 has-icon fs-14">
                                        <input type="search" id="search-users" class="ms-form-input w-100" name="search"
                                            placeholder="Search for People and Groups" value="">
                                        <i class="flaticon-search text-disabled"></i>
                                    </div>
                                </form>
                            </div>
                            <div class="ms-chat-body">
                                <ul class="ms-scrollable">
                                    @if (Auth::user()->role_type == 'patient' || Auth::user()->role_type == 'staff')
                                        @foreach ($providers as $item)
                                            <a href="javascript:;" class="reciver-box user-found" data-id="{{ $item->id ?? '' }}"
                                                data-name="{{ $item->name ?? '' }}"
                                                data-image="{{ asset($item->image ?? '') }}">
                                                <li
                                                    class="ms-chat-user-container ms-open-chat ms-deletable common-parent p-3 media clearfix">
                                                    <div class="ms-chat-status ms-status-offline ms-chat-img mr-3 align-self-center">
                                                        <img src="{{ asset($item->image ?? 'assets/admin/img/user.jpg') }}" class="ms-img-round" alt="people">
                                                    </div>
                                                    <div class="media-body ms-chat-user-info mt-1">
                                                        <h6>{{ $item->name ?? '' }}</h6>
                                                        @if (isset($item->last_msg['message']))
                                                            <p>{{ $item->last_msg['message'] ?? '' }}</p>
                                                        @endif
                                                    </div>
                                                    <div class="notify">
                                                        @if (isset($item->last_msg['message']))
                                                            <span class="ms-chat-time">{{$item->last_msg['created_at']->diffForHumans()}}</span>
                                                        @endif
                                                        @php
                                                            $unreadCount = $item->message()->where('is_read', 0)->where('user_id', '!=', Auth::user()->id)->count();
                                                        @endphp
                                                        @if($unreadCount > 0)
                                                            <div class="badge badge-primary badge-pill">{{ $unreadCount }}</div>
                                                        @endif
                                                    </div>
                                                </li>
                                            </a>
                                        @endforeach
                                    @else
                                        @foreach ($conversations as $item)
                                            <a href="javascript:;" class="reciver-box user-found" data-id="{{ $item->user_detail->id ?? '' }}"
                                                data-name="{{ $item->user_detail->name ?? '' }}"
                                                data-image="{{ asset($item->user_detail->image ?? '') }}">
                                                <li class="ms-chat-user-container ms-open-chat ms-deletable common-parent p-3 media clearfix">
                                                    <div class="ms-chat-status ms-status-offline ms-chat-img mr-3 align-self-center">
                                                        <img src="{{ asset($item->user_detail->image ?? 'assets/admin/img/user.jpg') }}" class="ms-img-round" alt="people">
                                                    </div>
                                                    <div class="media-body ms-chat-user-info mt-1">
                                                        <h6>{{ $item->user_detail->name ?? '' }}</h6>
                                                        <p>{{$item->user_msgs->message}}</p>
                                                    </div>
                                                    <div class="notify">
                                                        <span class="ms-chat-time">{{$item->user_msgs->created_at->diffForHumans()}}</span>
                                                        @php
                                                            $unreadCount = $item->msg()->where('is_read', 0)->where('user_id', '!=', Auth::user()->id)->count();
                                                        @endphp
                                                        @if($unreadCount > 0)
                                                            <div class="badge badge-primary badge-pill">{{ $unreadCount }}</div>
                                                        @endif
                                                    </div>
                                                </li>
                                            </a>
                                        @endforeach
                                    @endif
                                    <li><p id="no-user-message" style="display: none;">No user found</p></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Chat Body -->
            <div class="col-xl-8 col-md-12">
                <div class="ms-panel ms-chat-conversations ms-widget">
                    <div class="main-img-chat chatmainImag">
                        <img src="{{ asset($logo_dark->value) }}" alt="">
                        <h2>Chat Now</h2>
                    </div>
                    <div class="main-msg-box" style="display: none;">
                        <div class="ms-panel-header">
                            <div class="ms-chat-header justify-content-between">
                                <div class="ms-chat-user-container media clearfix">
                                    <div class="ms-chat-status ms-status-online ms-chat-img mr-3 align-self-center">
                                        <img src="" class="ms-img-round" alt="people" id="reciverImage">
                                    </div>
                                    <div class="media-body ms-chat-user-info mt-1">
                                        <h6 id="reciverName"></h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="ms-panel-body main-msgs-box"></div>
                        <div class="ms-panel-footer pt-0">
                            <div class="ms-chat-textbox">
                                <form action="javascript:;" id="messageForm">
                                    <input type="hidden" id="sender_id" name="sender_id" value="{{ Auth::user()->id }}">
                                    <input type="hidden" id="recievr_id" name="reciver_id" value="">
                                    <ul class="ms-list-flex mb-0">
                                        <li class="ms-chat-vn">
                                            <input type="file" name="file" id="file-input"
                                                class="file-input__input" />
                                            <label class="file-input__label" for="file-input">
                                                <i class="fa-solid fa-message-arrow-up"></i>
                                            </label>
                                        </li>
                                        <li class="ms-chat-input">
                                            <input type="text" id="userMsg" name="message" value=""
                                                placeholder="Enter Message">
                                        </li>
                                        <li>
                                            <ul class="ms-chat-text-controls ms-list-flex">
                                                <li>
                                                    <a href="javascript:;" class="sendMessage">
                                                        <i class="fa-solid fa-paper-plane-top"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        </li>
                                    </ul>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css')
    <style>
        .user-found.show{
            display: flex !important;
        }
        .user-found.hide{
            display: none !important;
        }
    </style>
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.reciver-box', function() {
            var userId = $(this).attr("data-id");
            $('#recievr_id').val(userId);
            var senderId = $('#sender_id').val();
            chatDetail(userId);
            $(this).find('.notify .badge').remove();
        });

        function chatDetail(userId){
            $('.chatmainImag').css("display", "none");
            $('.main-msg-box').css("display", "block");
            $('.main-msgs-box').html('');
            $('.reciver-box').find('.common-parent').removeClass("selected");
            $('.reciver-box[data-id="'+userId+'"]').find('.common-parent').addClass("selected");
            $.ajax({
                type: 'GET',
                url: '{{ route('admin.getChatMessages') }}',
                datatype: 'json',
                data: {
                    user_id: userId,
                },
                success: function(data) {
                    console.log(data);
                    if (data.status != 200) {
                        return;
                    }
                    $('#reciverName').html(data.user.name);
                    userImage = "{{ asset(':image') }}";
                    userImage = userImage.replace(':image', data.user.image);
                    $('#reciverImage').attr('src', userImage);
                    if (data.unread_count > 0) {
                        $('.badge-primary').text(data.unread_count);
                    } else {
                        $('.badge-primary').text('');
                    }

                    for (let index = 0; index < data.messages.length; index++) {
                        const message = data.messages[index];
                        var html = '';
                        if (message.user_id == "{{ Auth::user()->id }}") {
                            html = msgsoutgoing(message);
                        } else {
                            html = msgsincoming(message)
                        }
                        $('.main-msgs-box').append(html);
                    }
                    markMessagesAsRead(userId);
                }
            });
        }

        function markMessagesAsRead(userId) {
            $.ajax({
                type: 'POST',
                url: '{{ route('admin.markMessagesAsRead') }}',
                data: {
                    user_id: userId,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.status == 200) {
                        console.log('Messages marked as read');
                    } else {
                        console.log('Failed to mark messages as read');
                    }
                }
            });
        }

        function msgsoutgoing(data) {
            var userimg = data.user.image;
            var msg = data.message;
            var file = data.file;
            var filePath = "{{ asset(':path') }}";
            filePath = filePath.replace(':path', file);
            var created_at = moment(data.created_at);
            var msgdate = created_at.isValid() ? created_at.fromNow() : '';
            var path = "{{ asset(':path') }}";
            path = path.replace(':path', userimg);
            var html = `<div class="ms-chat-bubble ms-chat-message ms-chat-outgoing media clearfix">
                            <div class="ms-chat-status ms-status-online ms-chat-img">
                                <img src="${path}" class="ms-img-round" alt="people">
                            </div>
                            <div class="media-body">
                                <div class="ms-chat-text">
                                    ${msg ? `<p>${msg}</p>` : ''}
                                    ${file ? `<p class="has-img">
                                        <img src="${filePath}" class="img-fluid" alt="img">
                                        <a href="${filePath}" download class="hasImg-download">
                                            <i class="fa-solid fa-download"></i>
                                        </a>
                                    </p>` : ''}
                                </div>
                                <p class="ms-chat-time">${msgdate}</p>
                            </div>
                        </div>`;
            return html;
        }

        function msgsincoming(data) {
            var userimg = data.user.image;
            var msg = data.message;
            var file = data.file;
            var filePath = "{{ asset(':path') }}";
            filePath = filePath.replace(':path', file);
            var created_at = moment(data.created_at);
            var msgdate = created_at.isValid() ? created_at.fromNow() : '';
            var path = "{{ asset(':path') }}";
            path = path.replace(':path', userimg);
            var html = `<div class="ms-chat-bubble ms-chat-message media ms-chat-incoming clearfix">
                            <div class="ms-chat-status ms-status-online ms-chat-img">
                                <img src="${path}" class="ms-img-round" alt="people">
                            </div>
                            <div class="media-body">
                                <div class="ms-chat-text">
                                    ${msg ? `<p>${msg}</p>` : ''}
                                    ${file ? `<p class="has-img">
                                        <img src="${filePath}" class="img-fluid" alt="img">
                                        <a href="${filePath}" download class="hasImg-download">
                                            <i class="fa-solid fa-download"></i>
                                        </a>
                                    </p>` : ''}
                                </div>
                                <p class="ms-chat-time">${msgdate}</p>
                            </div>
                        </div>`;
            return html;
        }

        function sendMessage() {
            var senderId = $('#sender_id').val();
            var reciverId = $('#recievr_id').val();
            var userMsg = $('#userMsg').val().trim();
            var userFile = $('#file-input')[0].files[0];

            var formData = new FormData();
            formData.append('sender_id', senderId);
            formData.append('reciver_id', reciverId);
            formData.append('message', userMsg);
            formData.append('file', userFile);
            formData.append('_token', '{{ csrf_token() }}');
            console.log($('#file-input').val());
            if (userMsg == '' && $('#file-input').val() == '') {
                return;
            }

            if (userFile && userFile.size > 2097152) {
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("Please upload a file less than 2MB.");
                return;
            }

            $.ajax({
                type: 'POST',
                url: '{{ route('admin.sendMessages') }}',
                dataType: 'json',
                processData: false,
                contentType: false,
                data: formData,
                enctype: 'multipart/form-data',
                success: function(data) {
                    console.log(data);
                    var html = '';
                    html = msgsoutgoing(data.messages);
                    $('.main-msgs-box').prepend(html);
                    $('#userMsg').val('');
                    $('#file-input').val('');

                }
            });
        }

        $(document).on('click', '.sendMessage', function(e) {
            e.preventDefault();
            sendMessage();
        });

        $('#userMsg').keypress(function(event) {
            if (event.which === 13) {
                event.preventDefault();
                sendMessage();
            }
        });

        $(document).on('keyup', '#search-users', function () {
            var ele = $(this).val().toLowerCase().trim();
            var isUserFound = false;
            $('.user-found').each(function() {
                var userName = $(this).attr("data-name").toLowerCase().trim();
                if (userName.includes(ele)) {
                    $(this).removeClass('hide').addClass('show');
                    isUserFound = true;
                } else {
                    $(this).removeClass('show').addClass('hide');
                }
            });

            if (isUserFound) {
                $('#no-user-message').hide();
            } else {
                $('#no-user-message').show();
            }
        });
    </script>
@endsection
