@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Announcement</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add Announcement</h6>
                        <a href="{{ route('admin.announcemenView') }}" class="ms-text-primary">Announcement List</a>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.announcemenSave') }}" method="POST" novalidate>
                            @csrf
                            <input type="hidden" name="announcement_id" value="{{ $announcement->id ?? '' }}">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom001">Subject</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="title"
                                            value="{{ $announcement->title ?? '' }}" id="validationCustom001" placeholder="Subject"
                                            required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Announcement</label>
                                    <div class="form-group">
                                        {{-- tinyEditor --}}
                                        <textarea class="form-control" id="exampleTextarea1" name="message" rows="3">{{ $announcement->message ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
