<nav class="navbar ms-navbar">
    <div class="ms-aside-toggler ms-toggler pl-0" data-target="#ms-side-nav" data-toggle="slideLeft">
        <span class="ms-toggler-bar bg-white"></span>
        <span class="ms-toggler-bar bg-white"></span>
        <span class="ms-toggler-bar bg-white"></span>
    </div>
    <div class="logo-sn logo-sm ms-d-block-sm">
        <a class="pl-0 ml-0 text-center navbar-brand mr-0" href="/"><img
                src="{{ asset('assets/admin/img/medjestic-logo-84x41.png') }}" alt="logo"> </a>
    </div>
    <ul class="ms-nav-list ms-inline admin-header-nav mb-0" id="ms-nav-options">

        @patient
            <li class="ms-nav-item  ms-d-none">
                <a href="{{ route('admin.patientAppointmnet') }}" class="text-white">
                    <i class="flaticon-spreadsheet mr-2"></i> Make an appointment
                </a>
            </li>

            <li class="ms-nav-item dropdown">
                <a href="#" class="text-disabled ms-has-notification" id="notificationDropdown" data-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="flaticon-bell"></i>
                </a>
                <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="notificationDropdown">
                    <li class="dropdown-menu-header">
                        <h6 class="dropdown-header ms-inline m-0"><span class="text-disabled">Notifications</span></h6>
                        <span class="badge badge-pill badge-info">{{ auth()->user()->notifications->count() }} New</span>
                    </li>
                    <li class="dropdown-divider"></li>
                    @if (auth()->user()->notifications->isEmpty())
                        <li class="dropdown-menu-footer text-center">
                            <a href="javascript:;">No Notification to show</a>
                        </li>
                    @else
                        @foreach (auth()->user()->notifications as $item)
                            <li class="ms-scrollable ms-dropdown-list notify-list">
                                <a class="media" href="#">
                                    <div class="media-body">
                                        <span>{{ $item->data['title'] }}</span>
                                        <p class="annoucemnet">{{ $item->data['announcement'] }}</p>
                                        <p class="fs-10 my-1 text-disabled"><i class="material-icons">access_time</i> {{ $item->created_at->diffForHumans() }}</p>
                                    </div>
                                </a>
                            </li>
                        @endforeach
                    @endif
                    <li class="dropdown-divider"></li>
                    <li class="dropdown-menu-footer text-center">
                        <a href="{{ route('admin.markAsRead') }}">Mark all as read</a>
                    </li>
                </ul>
                @if (auth()->user()->unreadNotifications->count() > 0)
                    <div class="notify-icon"></div>
                @endif
            </li>
        @endpatient

        <li class="ms-nav-item ms-nav-user dropdown">
            <a href="#" id="userDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                @if (Auth::user()->image == null)
                    <img class="ms-user-img ms-img-round float-right" src="{{ asset('assets/admin/img/user.jpg') }}" alt="people">
                @else
                    <img class="ms-user-img ms-img-round float-right" src="{{ asset(Auth::user()->image) }}" alt="people">
                @endif
            </a>
            <div class="drop-icon">
                <i class="fa-solid fa-angle-down" style="color: #fff; font-size: 10px;"></i>
            </div>
            <ul class="dropdown-menu dropdown-menu-right user-dropdown" aria-labelledby="userDropdown">
                <li class="ms-dropdown-list">
                    <a class="media fs-14 p-2" href="{{ route('admin.profileEdit') }}">
                        <span><i class="flaticon-user mr-2"></i> Profile</span>
                    </a>
                </li>
                <li class="dropdown-menu-footer">
                    <a class="media fs-14 p-2" href="{{ route('admin.PasswordEdit') }}">
                        <span><i class="flaticon-security mr-2"></i>Update Password</span>
                    </a>
                </li>
                <li class="dropdown-menu-footer">
                    <a class="media fs-14 p-2" href="{{ route('logout') }}"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <span><i class="flaticon-shut-down mr-2"></i>{{ __('Logout') }}</span>
                    </a>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </li>
            </ul>
        </li>

        {{-- @staff
            <li class="ms-nav-item  ms-d-none">
                <a href="#mymodal" class="text-white" data-toggle="modal"><i class="flaticon-spreadsheet mr-2"></i> Make an
                    appointment</a>
            </li>

            <li class="ms-nav-item ms-d-none">
                <a href="#prescription" class="text-white" data-toggle="modal"><i class="flaticon-pencil mr-2"></i> Write a
                    prescription</a>
            </li>

            <li class="ms-nav-item ms-d-none">
                <a href="#report1" class="text-white" data-toggle="modal"><i class="flaticon-list mr-2"></i> Generate
                    Report</a>
            </li>
        @endstaff --}}
    </ul>
    <div class="ms-toggler ms-d-block-sm pr-0 ms-nav-toggler" data-toggle="slideDown" data-target="#ms-nav-options">
        <span class="ms-toggler-bar bg-white"></span>
        <span class="ms-toggler-bar bg-white"></span>
        <span class="ms-toggler-bar bg-white"></span>
    </div>
</nav>
