<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected $appends = ['last_msg'];
    public function rooms()
    {
        return $this->hasMany(Rooms::class, 'provider_id', 'id');
    }
    public function message()
    {
        return $this->hasMany(Messages::class, 'user_id', 'id');
    }
    public function document()
    {
        return $this->hasMany(Document::class, 'user_id', 'id');
    }
    public function getLastMsgAttribute()
    {
        $conversations = Conversation::where(function($q) {
            $q->where('sender_id', $this->id)->orWhere('reciver_id', $this->id);
        })->where(function($q){
            $q->where('sender_id', Auth::user()->id)->orWhere('reciver_id', Auth::user()->id);
        })->first();

        if(isset($conversations->id)){
            $message = Messages::where('conversation_id', $conversations->id)->orderby('id', 'desc')->first();
            return [
                'conversation_id' => $conversations->id,
                'message' => $message->message,
                'created_at' => $message->created_at,
            ];
        }
        return [];
    }
    public function redFlag()
    {
        return $this->hasMany(RedFlag::class, 'user_id', 'id');
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class, 'user_id', 'id');
    }

    public function providedAppointments()
    {
        return $this->hasMany(Appointment::class, 'provider_id', 'id');
    }

    public function purchasepackage()
    {
        return $this->hasMany(PurchasePackages::class, 'user_id', 'id');
    }

    public function order()
    {
        return $this->hasMany(PatientOrders::class, 'patient_id', 'id');
    }
}
