<?php

namespace App\Http\Middleware;

use App\Models\PurchasePackages;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class checkSubscription
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if(Auth::check() && Auth::user()->role_id == 2){
            $user = Auth::user();
            $latestSubscription = PurchasePackages::where('user_id', $user->id)
            ->where('is_active', 1)
            ->where('is_deleted', 0)
            ->orderBy('id', 'DESC')
            ->first();
            if (!$latestSubscription) {
                return redirect()->route('web.webPackagesView')->with('error', 'Please update your package to continue.');
            }
            if ($latestSubscription) {
                $expiryDate = $latestSubscription->expiry_date;
                if (now()->greaterThan($expiryDate)) {
                    return redirect()->route('web.webPackagesView')->with('error', 'Your package has expired. Please update your package to continue.');
                }
            }
        }
        return $next($request);
    }
}
