<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\WebCms;
use App\Models\customeCare;
use App\Models\aboutCms;

class CmsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('isAdmin');
    }
    
    public function homepage(){
        $data['ourlist_banner_img'] = WebCms::where('slug', 'ourlist_banner_img')->where('tag', 'others')->first();
        $data['ourlist_banner_title1'] = WebCms::where('slug', 'ourlist_banner_title1')->where('tag', 'others')->first();
        $data['ourlist_banner_title2'] = WebCms::where('slug', 'ourlist_banner_title2')->where('tag', 'others')->first();
        $data['ourlist_sec1_desc'] = WebCms::where('slug', 'ourlist_sec1_desc')->where('tag', 'others')->first();

        return view('admin.pages.webcms.othersPagesCms', $data )->with('title','Other Pages Cms');
    }

    public function CmsUpdate(Request $request) {
        $token_ignore = ['_token' => '', 'home_banner_video' => ''];
        $post_feilds = array_diff_key($request->all(), $token_ignore);
        $files = $request->allFiles();
        foreach ($files as $key => $value) {
            $file = $value;
            $ext = $value->getClientOriginalExtension();
            $file_name = $value->getClientOriginalName();
            $file_name = substr($file_name, 0, strpos($file_name, "."));
            $name = "uploads/webcms/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();

            $destinationPath = public_path() . '/uploads/webcms/';
            $share = $value->move($destinationPath, $name);
            $update = WebCms::where('slug', $key)->update(['value' => $name]);
        }
        foreach ($post_feilds as $key => $value) {
            $update = WebCms::where('slug', $key)->update(['value' => $value]);
        }
        return back()->with('message', 'Record has been updated');
    }

    public function aboutUs(){

        $_getaboutCms = aboutCms::where('id',1)->first();
        return view('admin.pages.webcms.about-us',compact('_getaboutCms'))->with('title','About CMS');
    }

    public function updateaboutUs(Request $request){
       // dd($request->image);
        $id =  $request->cms_id;
        

        $saveAboutUs = aboutCms::find($id);
        $saveAboutUs->title = $request->title;
        $saveAboutUs->description = $request->description;
        $saveAboutUs->description2 = $request->description2;
        $saveAboutUs->description3 = $request->description3;
        $extension = array("jpeg", "jpg", "png", "jfif");
        if (isset($request->image)) {
            $file = $request->image;
            $ext = $request->image->getClientOriginalExtension();
            if (in_array($ext, $extension)) {
                $file_name = $request->image->getClientOriginalName();
                $file_name = substr($file_name, 0, strpos($file_name, "."));
                $name = "uploads/cms/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path() . '/uploads/cms/';
                $share = $request->image->move($destinationPath, $name);
                $image = $name;
                $saveAboutUs->img = $image;
            } else {
                $warning = "This File type is not Supported!";
                return redirect()->back()->with('error', "Error Code: " . $warning);
            }
        }
        $saveAboutUs->save();

        return back()->with('message', 'Record has been updated');
    }

    public function customerCare(){

        $_getcustomeCare = customeCare::where('id',1)->first();
        return view('admin.pages.webcms.custome-care', compact('_getcustomeCare'))->with('title','Customer Care');
    }

    public function updateCustomerCare(Request $request){
        
        $id =  $request->cms_id;
        
        $saveCustomeCare = customeCare::find($id);
        $saveCustomeCare->title = $request->title;
        $saveCustomeCare->description = $request->description;
        $saveCustomeCare->save();

        return back()->with('message', 'Record has been updated');
    }

    public function privacyPolicy(){

        $_getprivacyPolicy = customeCare::where('id',2)->first();
        return view('admin.pages.webcms.privacy-policy', compact('_getprivacyPolicy'))->with('title','Privacy Policy');
    }

    public function updateprivacyPolicy(Request $request){
      
        $id =  $request->cms_id;
        
        $saveprivacyPolicy = customeCare::find($id);
        $saveprivacyPolicy->title = $request->title;
        $saveprivacyPolicy->description = $request->description;
        $saveprivacyPolicy->save();

        return back()->with('message', 'Record has been updated');
    }

}
