<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Rooms extends Model
{
    use HasFactory;
    protected $table = 'rooms';
    protected $appends = ['available_time'];

    public function provider()
    {
        return $this->belongsTo(User::class, 'provider_id', 'id');
    }

    public function getAvailableTimeAttribute()
    {
        $availableTimes = [];

        $startTime = \Carbon\Carbon::parse($this->start_time);
        $endTime = \Carbon\Carbon::parse($this->end_time);
        $duration = $this->duration;

        while ($startTime->lt($endTime)) {
            $availableTimes[] = $startTime->format('H:i');
            $startTime->addMinutes($duration);
        }

        if ($startTime->eq($endTime)) {
            $availableTimes[] = $endTime->format('H:i');
        }
        return $availableTimes;
    }
}
