<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class PurchasePackages extends Model
{
    use HasFactory;
    protected $table = 'purchase_packages';
    protected $appends = ['expiry_date'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function package()
    {
        return $this->belongsTo(Packages::class, 'package_id', 'id');
    }

    public function getExpiryDateAttribute()
    {
        $createdAt = $this->created_at;
        $packageType = $this->package->type;

        if ($packageType == 'monthly') {
            return $createdAt->addMonth()->format('Y-m-d H:i:s');
        } elseif ($packageType == 'yearly') {
            return $createdAt->addYear()->format('Y-m-d H:i:s');
        }
        return $createdAt->format('Y-m-d H:i:s');
    }
}
