<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    use HasFactory;
    protected $table = 'appointment';
    protected $dates = ['check_in','check_out'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function provider()
    {
        return $this->belongsTo(User::class, 'provider_id', 'id');
    }

    public function appointmentReports()
    {
        return $this->hasMany(AppointmentReport::class, 'appointment_id', 'id');
    }

    public function appointmentMedication()
    {
        return $this->hasMany(appointmentMedication::class, 'appointment_id', 'id');
    }
}
