<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckProfileCompletion
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();

        if (!$user) {
            return redirect()->route('web.Login');
        }

        if ($user->role_id == 1) {
            return $next($request);
        }

        if (empty($user->name) || empty($user->social_security_number) || empty($user->image) || empty($user->address) || empty($user->phone) || empty($user->date_of_birth)) {
            return redirect()->route('admin.profileEdit')->with('error', 'Please complete your profile first.');
        }

        return $next($request);
    }
}
