<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Appointment;
use App\Models\Laboratory;
use App\Models\RedFlag;
use App\Models\User;
use App\Models\PatientOrders;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;

class StaffController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('isStaff');
    }

    public function staffAppointmnetList() {
        $appList = Appointment::where('type', 'member')
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get();
        $labs = Laboratory::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.staff.memAppointmentListStaff', compact('appList','labs'))->with('title','Members appointment List');
    }

    public function approvedAppointmnets() {
        $approveAppointmnets = Appointment::where('type', 'member')
        ->where('status', 'approve')
        ->orWhere('status', 'completed')
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get();
        return view('admin.pages.staff.approveAppointmentsStaff', compact('approveAppointmnets'))->with('title','Members appointment List');
    }

    public function inStaffPatientList() {
        $patients = User::where('role_id', 2)->get();
        return view('admin.pages.staff.allPatientStaff', compact('patients'))->with('title','Patients List');
    }
}
