<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use App\Models\Document;
use App\Models\RedFlag;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Rooms;
use App\Models\Packages;
use App\Models\AppointmentReport;
use App\Models\PaymentHistory;
use App\Models\PurchasePackages;
use Facade\Ignition\Support\Packagist\Package;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;

class PateintController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('isPatient');
    }

    public function patientAppointmnet() {
        $doctors = User::where('role_id', 4)->get();
        return view('admin.pages.patient.appointment', compact('doctors'))->with('title','Make Appointment');
    }

    public function patientAppointmnetSubmit(Request $request) {
        try {
            $appointment = new Appointment();
            $appointment->user_id = $request->user_id ?? '';
            $appointment->provider_id = $request->provider_id ?? '';
            $appointment->name = $request->name ?? '';
            $appointment->phone_number = $request->phone_number ?? '';
            $appointment->social_security_number = $request->social_security_number ?? '';
            $appointment->appointment_date = $request->appointment_date ?? '';
            $appointment->appointment_time = $request->appointment_time ?? '';
            $appointment->problem = $request->problem ?? '';
            $appointment->type = 'member' ?? '';
            $appointment->save();

            $provider = User::find($request->provider_id);
            $user = User::find($request->user_id);

            $data = [
                'provider' => $provider->name ?? '',
                'name' => $request->name ?? '',
                'email' => $user->email ?? '',
                'number' => $request->phone_number ?? '',
                'appointmentdate' => $request->appointment_date ?? '',
                'appointmenttime' => $request->appointment_time ?? '',
                'roletype' => $provider->role_id ?? '',
            ];

            $providerMail = [$provider->email];
            $pateintMail = [$user->email];

            Mail::send('web.pages.mailing.memberAppointmentMail', $data, function ($message) use ($providerMail) {
                $message->to($providerMail);
                $message->subject('Appointment Schedule');
            });

            $data['roletype'] = $user->role_id ?? '';
            Mail::send('web.pages.mailing.memberAppointmentMail', $data, function ($message) use ($pateintMail) {
                $message->to($pateintMail);
                $message->subject('Appointment Schedule');
            });

            return response()->json(['message' => 'Appointment schedule successfully']);
        } catch (\Exception $e) {
            // Log the error or handle it as needed
            Log::error('Error scheduling appointment: '.$e->getMessage());

            return response()->json(['message' => 'Failed to schedule appointment'], 500);
        }
    }

    public function patientAppointmnetList() {
        $appList = Appointment::where('user_id', Auth::user()->id)->where('type', 'member')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.patient.pateintAppointmentList', compact('appList'))->with('title','Appointment List');
    }
    public function patientAppointmnetReports($id) {
        $appointmentReport = AppointmentReport::where('appointment_id', $id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.documents.reportsViewAgianstAppointment', compact('appointmentReport'))->with('title','Reports List');
    }

    public function patientAppointmnetCancel(Request $request) {
        $appointment = Appointment::find($request->id);
        if (!$appointment) {
            return response()->json(['message' => 'Appointment not found.'], 404);
        }
        $appointment->status = 'cancel';
        $appointment->save();
        return response()->json([
            'message' => 'Status updated successfully!',
            'status' => $request->status
        ]);
    }

    public function patientDocumentsList() {
        $document = Document::where('user_id', Auth::user()->id)->where('upload_by', 'patient')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.documents.documentList', compact('document'))->with('title','Documents List');
    }
    public function ReportsDocumentList() {
        $reports = Document::where('user_id', Auth::user()->id)->where('upload_by', 'admin')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.documents.pateintReports', compact('reports'))->with('title','Reports');
    }

    public function patientDocumnetSave(Request $request)
    {
        $document = new Document();

        $validated = Validator::make($request->all(), [
            'file' => 'required|max:20480',
        ]);
        if ($validated->fails()) {
            return redirect()->back()->with('validationerror', $validated->errors()->all());
        }

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $file_name = $file->getClientOriginalName();
            $file_size = $file->getSize();
            if ($file_size > 20971520) {
                return redirect()->back()->with('error', 'Please upload a file less than 20MB.');
            }
            $file_name = pathinfo($file_name, PATHINFO_FILENAME);
            $file_extension = $file->getClientOriginalExtension();
            $file_name = $file_name . '_' . time() . '.' . $file_extension;
            $destinationPath = public_path('uploads/documents');
            $file->move($destinationPath, $file_name);
            $document->file = 'uploads/documents/' . $file_name;
            $document->file_name = $file->getClientOriginalName();
            $document->file_size = $file_size;
        }

        $user_id = Auth::user()->id;
        $document->user_id = $user_id ?? '';
        $document->upload_by = $request->upload_by ?? '';
        $document->save();
        return redirect()->back()->with('message', 'Document Uploaded Successfully');
    }
    public function patientDocumnetDelete(Request $request)
    {
        if ($request->id) {
            $document = Document::where('id', $request->id)->first();
            if ($document) {
                $document->is_active = 0;
                $document->is_deleted = 1;
                $document->save();

                return response()->json(['status' => 1, 'message' => 'document Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'document Not Found!']);
    }

    public function patientRedFlag() {
        $redFlag = RedFlag::where('user_id', Auth::user()->id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.patient.redFlag', compact('redFlag'))->with('title','Red Flag');
    }
    public function patientRedFlagSave(Request $request)
    {
        $redFlag = new RedFlag();
        $user_id = Auth::user()->id;
        $redFlag->user_id = $user_id ?? '';
        $redFlag->flag = $request->flag ?? '';
        $redFlag->save();
        return redirect()->back()->with('message', 'Record Updated Successfully');
    }
    public function patientRedFlagDelete(Request $request)
    {
        if ($request->id) {
            $redFlag = RedFlag::where('id', $request->id)->first();
            if ($redFlag) {
                $redFlag->is_active = 0;
                $redFlag->is_deleted = 1;
                $redFlag->save();

                return response()->json(['status' => 1, 'message' => 'Redflag Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'Redflag Not Found!']);
    }

    public function webPackagesView()
    {
        $packages = Packages::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('web.pages.packages', compact('packages'))->with('title','Packages');
    }

    public function webPackagesPurchase($id)
    {
        $package = Packages::find($id);
        return view('web.pages.purchasePackage', compact('package'))->with('title','Purchase Package');
    }

    public function paymentHistory(){
        $payment = PaymentHistory::where('user_id', Auth::user()->id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.patient.paymentHistory', compact('payment'))->with('title','Payment History');
    }

    public function membershipManage(){
        $packages = Packages::where('is_active', 1)->where('is_deleted', 0)->get();
        $membership = PurchasePackages::with('package')
        ->where('user_id', Auth::user()->id)
        ->orderBy('id', 'DESC')
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->first();
        return view('admin.pages.patient.membershipMange', compact('membership','packages'))->with('title','Membership Manage');
    }

    public function cancelMembership(Request $request)
    {
        if ($request->id) {
            $userId = Auth::user()->id;
            $document = PurchasePackages::where('id', $request->id)->first();
            if ($document) {
                $document->is_active = 0;
                $document->is_deleted = 1;
                $document->save();
                $user = User::find($userId);
                $user->membership_cancel_date = now()->toDateString();
                $user->is_active = 0;
                $user->is_deleted = 1;
                $user->save();
                Auth::logout();
                Session::flash('message', 'Membership canceled. You have been logged out.');
                return response()->json(['status' => 1, 'message' => 'Membership canceled. You have been logged out.']);
            }
            return response()->json(['status' => 0, 'message' => 'Membership Not Found!']);
        }
        return response()->json(['status' => 0, 'message' => 'Invalid Request!']);
    }

    public function medicalProfileAccess() {
        $patientId = Auth::user()->id;
        if (Auth::user()->access_medical_profile == 0) {
            return redirect()->route('admin.home')->with('message', "You don't have access to your medical profile.");
        }

        $appointments = Appointment::where('user_id', $patientId)
        ->where('status', 'completed')
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get();
        // dd($appointments);

        $appointmentId = $appointments->pluck('id');
        // dd($appointmentId);

        $medicalReports = AppointmentReport::whereIn('appointment_id', $appointmentId)
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get()
        ->groupBy('appointment_id');
        // dd($medicalReports);
        return view('admin.pages.patient.medicalProfile', compact('medicalReports','appointments'))->with('title','Medical Profile');
    }

    public function profileAccessSubmit(Request $request) {
        $userId = Auth::user()->id;
        $accessProfile = User::find($userId);
        $accessProfile->access_medical_profile = 1;
        $accessProfile->save();
        return redirect()->route('admin.medicalProfileAccess')->with('message', 'Access granted successfully.');
    }
}
