<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\WebCms;
use App\Models\customeCare;
use App\Models\aboutCms;

class CmsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('isAdmin');
    }

    public function cmsHome()
    {
        $data['home_banner_img'] = WebCms::where('slug', 'home_banner_img')->where('tag', 'home')->first();
        $data['home_banner_title'] = WebCms::where('slug', 'home_banner_title')->where('tag', 'home')->first();
        $data['home_banner_desc'] = WebCms::where('slug', 'home_banner_desc')->where('tag', 'home')->first();

        $data['home_sec1_image'] = WebCms::where('slug', 'home_sec1_image')->where('tag', 'home')->first();
        $data['home_sec1_content'] = WebCms::where('slug', 'home_sec1_content')->where('tag', 'home')->first();

        $data['home_sec2_image'] = WebCms::where('slug', 'home_sec2_image')->where('tag', 'home')->first();
        $data['home_sec2_content'] = WebCms::where('slug', 'home_sec2_content')->where('tag', 'home')->first();
        $data['home_sec2_progress1'] = WebCms::where('slug', 'home_sec2_progress1')->where('tag', 'home')->first();
        $data['home_sec2_progress2'] = WebCms::where('slug', 'home_sec2_progress2')->where('tag', 'home')->first();
        $data['home_sec2_progress3'] = WebCms::where('slug', 'home_sec2_progress3')->where('tag', 'home')->first();

        $data['home_sec3_image'] = WebCms::where('slug', 'home_sec3_image')->where('tag', 'home')->first();
        $data['home_sec3_content'] = WebCms::where('slug', 'home_sec3_content')->where('tag', 'home')->first();

        $data['home_sec4_image'] = WebCms::where('slug', 'home_sec4_image')->where('tag', 'home')->first();
        $data['home_sec4_content'] = WebCms::where('slug', 'home_sec4_content')->where('tag', 'home')->first();
        $data['home_sec4_box1_image'] = WebCms::where('slug', 'home_sec4_box1_image')->where('tag', 'home')->first();
        $data['home_sec4_box1_title'] = WebCms::where('slug', 'home_sec4_box1_title')->where('tag', 'home')->first();
        $data['home_sec4_box1_description'] = WebCms::where('slug', 'home_sec4_box1_description')->where('tag', 'home')->first();
        $data['home_sec4_box2_image'] = WebCms::where('slug', 'home_sec4_box2_image')->where('tag', 'home')->first();
        $data['home_sec4_box2_title'] = WebCms::where('slug', 'home_sec4_box2_title')->where('tag', 'home')->first();
        $data['home_sec4_box2_description'] = WebCms::where('slug', 'home_sec4_box2_description')->where('tag', 'home')->first();
        $data['home_sec4_box3_image'] = WebCms::where('slug', 'home_sec4_box3_image')->where('tag', 'home')->first();
        $data['home_sec4_box3_title'] = WebCms::where('slug', 'home_sec4_box3_title')->where('tag', 'home')->first();
        $data['home_sec4_box3_description'] = WebCms::where('slug', 'home_sec4_box3_description')->where('tag', 'home')->first();
        $data['home_sec4_box4_image'] = WebCms::where('slug', 'home_sec4_box4_image')->where('tag', 'home')->first();
        $data['home_sec4_box4_title'] = WebCms::where('slug', 'home_sec4_box4_title')->where('tag', 'home')->first();
        $data['home_sec4_box4_description'] = WebCms::where('slug', 'home_sec4_box4_description')->where('tag', 'home')->first();

        return view('admin.pages.webCms.homeCms', $data)->with('title', 'home cms');
    }

    public function cmsCustomerCare()
    {
        $data['customer_care_banner_image'] = WebCms::where('slug', 'customer_care_banner_image')->where('tag', 'customer_care')->first();
        $data['customer_care_banner_title'] = WebCms::where('slug', 'customer_care_banner_title')->where('tag', 'customer_care')->first();
        $data['customer_care_content'] = WebCms::where('slug', 'customer_care_content')->where('tag', 'customer_care')->first();

        return view('admin.pages.webCms.customerCare', $data)->with('title', 'customer care cms');
    }

    public function cmsPrivacyPolicy()
    {
        $data['privacy_policy_banner_image'] = WebCms::where('slug', 'privacy_policy_banner_image')->where('tag', 'privacy_policy')->first();
        $data['privacy_policy_banner_title'] = WebCms::where('slug', 'privacy_policy_banner_title')->where('tag', 'privacy_policy')->first();
        $data['privacy_policy_content'] = WebCms::where('slug', 'privacy_policy_content')->where('tag', 'privacy_policy')->first();

        return view('admin.pages.webCms.privacyPolicy', $data)->with('title', 'privacy policy cms');
    }

    public function cmsSupport()
    {
        $data['support_banner_image'] = WebCms::where('slug', 'support_banner_image')->where('tag', 'support')->first();
        $data['support_banner_title'] = WebCms::where('slug', 'support_banner_title')->where('tag', 'support')->first();
        $data['support_content'] = WebCms::where('slug', 'support_content')->where('tag', 'support')->first();

        return view('admin.pages.webCms.support', $data)->with('title', 'support cms');
    }

    public function cmsAboutUs()
    {
        $data['about_us_banner_image'] = WebCms::where('slug', 'about_us_banner_image')->where('tag', 'about_us')->first();
        $data['about_us_banner_title'] = WebCms::where('slug', 'about_us_banner_title')->where('tag', 'about_us')->first();

        $data['about_us_sec1_image'] = WebCms::where('slug', 'about_us_sec1_image')->where('tag', 'about_us')->first();
        $data['about_us_sec1_content'] = WebCms::where('slug', 'about_us_sec1_content')->where('tag', 'about_us')->first();

        $data['about_us_sec2_content1'] = WebCms::where('slug', 'about_us_sec2_content1')->where('tag', 'about_us')->first();
        $data['about_us_sec2_content2'] = WebCms::where('slug', 'about_us_sec2_content2')->where('tag', 'about_us')->first();

        $data['about_us_sec3_content'] = WebCms::where('slug', 'about_us_sec3_content')->where('tag', 'about_us')->first();

        return view('admin.pages.webCms.aboutUsCms', $data)->with('title', 'about us cms');
    }

    public function cmsPricing()
    {
        $data['pricing_banner_image'] = WebCms::where('slug', 'pricing_banner_image')->where('tag', 'pricing')->first();
        $data['pricing_banner_title'] = WebCms::where('slug', 'pricing_banner_title')->where('tag', 'pricing')->first();
        $data['pricing_content'] = WebCms::where('slug', 'pricing_content')->where('tag', 'pricing')->first();

        return view('admin.pages.webCms.pricingCms', $data)->with('title', 'pricing cms');
    }

    public function cmsServices()
    {
        $data['services_banner_image'] = WebCms::where('slug', 'services_banner_image')->where('tag', 'services')->first();
        $data['services_banner_title'] = WebCms::where('slug', 'services_banner_title')->where('tag', 'services')->first();
        $data['services_content'] = WebCms::where('slug', 'services_content')->where('tag', 'services')->first();

        return view('admin.pages.webCms.serviceCms', $data)->with('title', 'services cms');
    }

    public function cmsProviders()
    {
        $data['providers_banner_image'] = WebCms::where('slug', 'providers_banner_image')->where('tag', 'providers')->first();
        $data['providers_banner_title'] = WebCms::where('slug', 'providers_banner_title')->where('tag', 'providers')->first();

        $data['providers_sec1_image'] = WebCms::where('slug', 'providers_sec1_image')->where('tag', 'providers')->first();
        $data['providers_sec1_content'] = WebCms::where('slug', 'providers_sec1_content')->where('tag', 'providers')->first();

        $data['providers_sec2_image'] = WebCms::where('slug', 'providers_sec2_image')->where('tag', 'providers')->first();
        $data['providers_sec2_content'] = WebCms::where('slug', 'providers_sec2_content')->where('tag', 'providers')->first();

        return view('admin.pages.webCms.providerCms', $data)->with('title', 'providers cms');
    }

    public function CmsUpdate(Request $request)
    {
        $token_ignore = [
            '_token' => '',
            'home_banner_img' => '',
            'home_sec1_image' => '',
            'home_sec2_image' => '',
            'home_sec3_image' => '',
            'home_sec4_image' => '',
            'home_sec4_box1_image' => '',
            'home_sec4_box2_image' => '',
            'home_sec4_box3_image' => '',
            'home_sec4_box4_image' => '',
            'customer_care_banner_image' => '',
            'privacy_policy_banner_image' => '',
            'support_banner_image' => '',
            'about_us_banner_image' => '',
            'about_us_sec1_image' => '',
            'pricing_banner_image' => '',
            'services_banner_image' => '',
            'providers_banner_image' => '',
            'providers_sec1_image' => '',
            'providers_sec2_image' => ''
        ];
        $post_fields = array_diff_key($request->all(), $token_ignore);
        $files = $request->allFiles();
        foreach ($files as $key => $value) {
            $file = $value;
            $ext = $value->getClientOriginalExtension();
            $file_name = $value->getClientOriginalName();
            $file_name = substr($file_name, 0, strpos($file_name, "."));
            $name = "uploads/webCms/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();

            $destinationPath = public_path() . '/uploads/webCms/';
            $share = $value->move($destinationPath, $name);
            $update = WebCms::where('slug', $key)->update(['value' => $name]);
        }
        foreach ($post_fields as $key => $value) {
            $update = WebCms::where('slug', $key)->update(['value' => $value]);
        }
        return back()->with('message', 'Record has been updated');
    }
}
