<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Packages;
use App\Models\PaymentHistory;
use App\Models\PurchasePackages;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class ClovermerchentController extends Controller
{
    public function cloverApi(Request $request)
    {
        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://apisandbox.dev.clover.com/pakms/apikey');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Authorization: Bearer c2c97800-64ae-06d9-fe12-8b6b712e275a';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);
        $res = json_decode($result, true);
        // dump($res['apiAccessKey']);

        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://token-sandbox.dev.clover.com/v1/tokens');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
         $post_feilds = [
            'card'=> [
                'number' => $request->number,
                'exp_month' => $request->expmonth,
                'exp_year' => $request->expyear,
                'cvv' => $request->cvv,
            ],
        ];
        curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($post_feilds));

        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Apikey:'.$res['apiAccessKey'];
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result2 = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        $res2 = json_decode($result2, true);

        // dump($res2);

        // $client = new \GuzzleHttp\Client();
        // $resBody = [
        //   'body' => '{"amount":100,"currency":"USD","source":"'.$res2['id'].'"}',
        //   'headers' => [
        //     'accept' => 'application/json',
        //     'authorization' => 'Bearer 5eb213bb-ba87-5c67-628f-1ddb98946696',
        //     'content-type' => 'application/json',
        //   ],
        // ];
        // // dd($resBody);
        // $response = $client->request('POST', 'https://scl-sandbox.dev.clover.com/v1/charges', $resBody);

        // dd($response->getBody()->getContents());

        //  done //

        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://scl-sandbox.dev.clover.com/v1/charges');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        $post_feilds = [
            'amount'=> $request->amount,
            'currency'=> 'USD',
            'source'=> $res2['id']
        ];
        $res2_id = $res2['id'];

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_feilds));

        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = 'Authorization: Bearer c2c97800-64ae-06d9-fe12-8b6b712e275a';
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        $response = json_decode($result, true);
        // dd($response['id']);
        $transaction_id = $response['id'] ?? '';
        // dump(json_decode($result));

        $user = Auth::user();

        PurchasePackages::where('user_id', $user->id)->update([
            'is_active'=> 0,'is_deleted'=> 1,
        ]);
        $purchasePackage = new PurchasePackages();
        $purchasePackage->user_id = $user->id;
        $purchasePackage->package_id = $request->package_id ?? '';
        $purchasePackage->amount = $request->amount ?? '';
        $purchasePackage->transaction_id = $transaction_id;
        $purchasePackage->save();

        $package = Packages::find($request->package_id);

        $paymentHistory = new PaymentHistory();
        $paymentHistory->user_id = $user->id ??'';
        if ($package->type == 'monthly') {
            $paymentHistory->reason = "buy monthly package" ??'';
        }else{
            $paymentHistory->reason = "buy yearly package" ??'';
        }
        $paymentHistory->amount = $request->amount ??'';
        $currentDate = Carbon::now()->toDateString();
        $paymentHistory->date = $currentDate ??'';
        // dd($paymentHistory);
        $paymentHistory->save();

        return redirect()->route('admin.home')->with('message', 'Package Buy Successfully');

    }
}
