<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\Conversation;
use App\Models\Messages;
use App\Models\Logo;
use GrahamCampbell\ResultType\Success;

class ChatController extends Controller
{
    public function usersChat() {
        $logo_dark = Logo::where('slug', 'logo_dark')->where('tag', 'logo_fav')->first();
        $conversations = Conversation::where('sender_id', Auth::user()->id)->orWhere('reciver_id', Auth::user()->id)->get();
        $providers = User::with('message')->where('role_type', 'provider')->get();
        return view('admin.pages.chat.chat', compact('conversations','providers','logo_dark'))->with('title','Chat');
    }

    public function getChatMessages(Request $request) {
        $user = User::find($request->user_id);
        $conversations = Conversation::where(function($q) use($request) {
            $q->where('sender_id', $request->user_id)->orWhere('reciver_id', $request->user_id);
        })->where(function($q) use($request){
            $q->where('sender_id', Auth::user()->id)->orWhere('reciver_id', Auth::user()->id);
        })->first();
        $message = [];
        $unreadCount = 0;

        if ($conversations) {
            $message = Messages::with('user')->where('conversation_id', $conversations->id)->orderby('id', 'desc')->get();
            $unreadCount = Messages::where('conversation_id', $conversations->id)
            ->where('user_id', '!=', Auth::user()->id)
            ->where('is_read', 0)
            ->count();
        }
        return response()->json([
            'status' => 200,
            'success'=>true,
            'messages'=> $message,
            'unread_count' => $unreadCount,
            'user'=> $user
        ]);
    }

    public function markMessagesAsRead(Request $request)
    {
        $conversation = Conversation::where(function($q) use($request) {
            $q->where('sender_id', $request->user_id)
            ->orWhere('reciver_id', $request->user_id);
        })->where(function($q) use($request){
            $q->where('sender_id', Auth::user()->id)
            ->orWhere('reciver_id', Auth::user()->id);
        })->first();

        if ($conversation) {
            Messages::where('conversation_id', $conversation->id)
                ->where('user_id', '!=', Auth::user()->id)
                ->where('is_read', 0)
                ->update(['is_read' => 1]);

            return response()->json(['status' => 200, 'success' => true]);
        }

        return response()->json(['status' => 404, 'success' => false]);
    }

    public function sendMessages(Request $request) {
        $conversations = Conversation::where(function($q) use($request) {
            $q->where('sender_id', $request->sender_id)->orWhere('reciver_id', $request->sender_id);
        })->where(function($q) use($request){
            $q->where('sender_id', $request->reciver_id)->orWhere('reciver_id', $request->reciver_id);
        })->first();

        if (!isset($conversations->id)) {
            $conversations = new Conversation();
            $conversations->sender_id = $request->sender_id ?? 0;
            $conversations->reciver_id = $request->reciver_id ?? 0;
            $conversations->save();
        }

        $message = new Messages();

        $validated = Validator::make($request->all(), [
            'file' => 'required|max:20480',
        ]);
        if ($validated->fails()) {
            return response()->json([
                'status' => 400,
                'success' => false,
                'errors' => $validated->errors(),
            ], 400);
        }

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $ext = $file->getClientOriginalExtension();
            $file_name = $file->getClientOriginalName();
            $file_name = substr($file_name, 0, strpos($file_name, "."));
            $name = "uploads/chatfiles/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();
            $destinationPath = public_path() . '/uploads/chatfiles/';
            $share = $file->move($destinationPath, $name);
            $file = $name;
            $message->file = $file;
        }

        $message->conversation_id = $conversations->id ?? 0;
        $message->user_id = $request->sender_id ?? 0;
        $message->message = $request->message ?? '';
        $message->save();

        $message = Messages::with('user')->find($message->id);
        return response()->json(['status' => 200,'success'=>true, 'messages'=> $message]);
    }
}
