<?php

namespace App\Http\Controllers;

use App\Models\Logo;
use App\Models\User;
use App\Models\Config;
use App\Models\Services;
use App\Models\Testimonials;
use App\Models\Appointment;
use App\Models\Inquiries;
use App\Models\Rooms;
use App\Models\Document;
use App\Models\Packages;
use App\Models\Announcement;
use App\Models\AppointmentReport;
use App\Models\AppointmentMedication;
use App\Models\NewsLetter;
use App\Models\PatientOrders;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Notifications\AnnouncementNotification;
use Carbon\Carbon;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('isAdmin');
    }

    public function logoEdit() {
        $logo_dark = Logo::where('slug', 'logo_dark')->where('tag', 'logo_fav')->first();
        $logo_light = Logo::where('slug', 'logo_light')->where('tag', 'logo_fav')->first();
        $favicon = Logo::where('slug', 'favicon')->where('tag', 'logo_fav')->first();
        return view('admin.pages.logo&fav.edit', compact('logo_dark','logo_light','favicon'))->with('title','Manage Logo & Fav');
    }

    public function logoUpdate(Request $request) {
        $token_ignore = ['_token' => '', 'logo_dark' => '', 'logo_light' => '', 'favicon' => ''];
        $post_feilds = array_diff_key($request->all(), $token_ignore);
        $files = $request->allFiles();
        foreach ($files as $key => $value) {
            $file = $value;
            $ext = $value->getClientOriginalExtension();
            $file_name = $value->getClientOriginalName();
            $file_name = substr($file_name, 0, strpos($file_name, "."));
            $name = "uploads/logo/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();

            $destinationPath = public_path() . '/uploads/logo/';
            $share = $value->move($destinationPath, $name);
            $update = Logo::where('slug', $key)->update(['value' => $name]);
        }
        foreach ($post_feilds as $key => $value) {
            $update = Logo::where('slug', $key)->update(['value' => $value]);
        }
        return back()->with('message', 'Record has been updated');
    }

    public function configEdit()
    {
        $config = Config::first();
        return view('admin.pages.config.config', compact('config'))->with('title', 'Manage config');
    }
    public function configUpdate(Request $request)
    {
        $config = Config::first();
        $config->email = $request->email;
        $config->address = $request->address;
        $config->phone_no = $request->phone_no;
        $config->facebook = $request->facebook;
        $config->instagram = $request->instagram;
        $config->twitter = $request->twitter;
        $config->youtube = $request->youtube;
        $config->copyright = $request->copyright;
        $config->foot_desc = $request->foot_desc;
        $config->announcement = $request->announcement;
        $config->timing = $request->timing;
        $config->save();
        return redirect()->route('admin.configEdit')->with('message', 'Config Updated Successfully');
    }
    public function servicesView()
    {
        $service = Services::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.services.serviceView', compact('service'))->with('title', 'service');
    }
    public function servicesDetail($id)
    {
        $service = Services::find($id);
        return view('admin.pages.services.serviceDetail', compact('service'))->with('title', 'service detail');
    }
    public function servicesCreate($id)
    {
        if ($id > 0) {
            $service = Services::find($id);
            return view('admin.pages.services.serviceCreate', compact('service'))->with('title', 'service edit');
        }
        return view('admin.pages.services.serviceCreate')->with('title', 'service Create');
    }

    public function servicesUpdate(Request $request)
    {
        $serviceId = $request->input('service_id');

        if ($serviceId) {
            $service = Services::find($serviceId);
            if (!$service) {
                return redirect()->back()->with('error', 'Service not found.');
            }
        } else {
            $service = new Services();
        }

        $extension = array("jpeg", "jpg", "png", "jfif", "webp");
        if (isset($request->image)) {
            $file = $request->image;
            $ext = $request->image->getClientOriginalExtension();
            if (in_array($ext, $extension)) {
                $file_name = $request->image->getClientOriginalName();
                $file_name = substr($file_name, 0, strpos($file_name, "."));
                $name = "uploads/services/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path() . '/uploads/services/';
                $share = $request->image->move($destinationPath, $name);
                $image = $name;
                $service->image = $image  ?? '';
            } else {
                $warning = "This File type is not Supported!";
                return redirect()->back()->with('error', "Error Code: " . $warning);
            }
        }

        $service->title = $request->title ?? '';
        $service->slug = Str::slug($request->title , "-");
        $service->short_desc = $request->short_desc ?? '';
        $service->description = $request->description ?? '';
        $service->save();
        return redirect()->back()->with('message', 'Record updated Sucessfully');
    }
    public function servicesDelete(Request $request)
    {
        if ($request->id) {
            $service = Services::where('id', $request->id)->first();
            if ($service) {
                $service->is_active = 0;
                $service->is_deleted = 1;
                $service->save();

                return response()->json(['status' => 1, 'message' => 'service Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'service Not Found!']);
    }
    public function ApppointmentList(){
        $appointment = Appointment::where('type', 'nonmember')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.appointment.nonmemberAppointmentlist', compact('appointment'))->with('title','Non Member Appointment List');
    }
    public function appointmentDelete($id){
        $appointmentDelete = Appointment::find($id);
        $appointmentDelete->is_deleted = 1;
        $appointmentDelete->save();
        return redirect()->back()->with('message', 'Record Deleted Sucessfully');
    }

    public function testimonialsView()
    {
        $getTestimonials = Testimonials::where('is_active', 1)->where('is_deleted', 0)->get();

        return view('admin.pages.testimonials.testimonialsView', compact('getTestimonials'))->with('title', 'Testimonials Listing');
    }
    public function testimonialsDetail($id)
    {
        $service = Services::find($id);
        return view('admin.pages.testimonials.testimonialsDetail', compact('service'))->with('title', 'Testimonials detail');
    }
    public function testimonialsCreate($id)
    {
        if ($id > 0) {
            $getTestimonial = Testimonials::find($id);
            return view('admin.pages.testimonials.testimonialsCreate', compact('getTestimonial'))->with('title', 'Testimonial Edit');
        }
        return view('admin.pages.testimonials.testimonialsCreate')->with('title', 'Testimonials Create');
    }

    public function testimonialsUpdate(Request $request)
    {

        $testimonialId = $request->input('testimonial_id');

        if ($testimonialId) {
            $testimonial = Testimonials::find($testimonialId);
            if (!$testimonial) {
                return redirect()->back()->with('error', 'Testimonials not found.');
            }
        } else {
            $testimonial = new Testimonials();
        }

        $testimonial->user_name = $request->user_name ?? '';
        $testimonial->testimonial = $request->testimonial ?? '';
        $testimonial->save();
        return redirect()->back()->with('message', 'Record updated Sucessfully');
    }
    public function testimonialsDelete(Request $request)
    {
        if ($request->id) {
            $service = Testimonials::where('id', $request->id)->first();
            if ($service) {
                $service->is_active = 0;
                $service->is_deleted = 1;
                $service->save();

                return response()->json(['status' => 1, 'message' => 'Testimonials Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'Testimonials Not Found!']);
    }

    public function contactInquiry()
    {
        $getContactInquiry = Inquiries::where('is_active', 1)->where('is_deleted', 0)->get();

        return view('admin.pages.inquiries.contact', compact('getContactInquiry'))->with('title', 'Contact Inquiry Listing');
    }
    public function contactInquiryDelete($id)
    {
        $getContactInquiry = Inquiries::where('id', $id)->first();
        $getContactInquiry->is_active = 0;
        $getContactInquiry->is_deleted = 1;
        $getContactInquiry->save();
        return redirect()->back()->with('message', 'Inquiry Deleted Sucessfully');
    }
    public function providerList() {
        $providers = User::where('role_id', 4)->get();
        return view('admin.pages.providers.providerView', compact('providers'))->with('title','providers');
    }
    public function providerRooms($id) {
        $providersRooms = Rooms::where('provider_id', $id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.providers.providerRooms', compact('providersRooms'))->with('title','providers Rooms');
    }
    public function roomUpdateAdmin(Request $request)
    {
        $roomEdit = Rooms::find($request->room_id);
        $roomEdit->start_time = $request->start_time ?? '';
        $roomEdit->end_time = $request->end_time ?? '';
        $roomEdit->save();
        return redirect()->back()->with('message', 'Record updated Successfully');
    }
    public function staffList() {
        $staff = User::where('role_id', 3)->get();
        return view('admin.pages.staff.staffView', compact('staff'))->with('title','staff');
    }
    public function pateintList() {
        $pateint = User::where('role_id', 2)->get();
        return view('admin.pages.patient.pateintList', compact('pateint'))->with('title','pateint');
    }
    public function patientChargeHistoryView($id){
        $order = PatientOrders::where('patient_id', $id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.patient.patientOrder.adminChrgeHistoryView', compact('order','id'))->with('title','patient charge history');
    }

    public function patientDocuments($id) {
        $documents = Document::where('user_id', $id)->where('upload_by', 'patient')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.patient.documents', compact('documents'))->with('title','Pateint Documents List');
    }

    public function patientreportsList($id) {
        $report = Document::where('user_id', $id)->where('upload_by', 'admin')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.documents.reportlist', compact('report','id'))->with('title','Reports List');
    }

    public function providerCreate()
    {
        $Role_id = 4;
        $role_type = 'provider';
        return view('admin.pages.providers.providersCreate', compact('Role_id','role_type'))->with('title', 'providers Create');
    }
    public function staffCreate()
    {
        $Role_id = 3;
        $role_type = 'staff';
        return view('admin.pages.providers.providersCreate', compact('Role_id','role_type'))->with('title', 'staff Create');
    }

    public function providerAdd(Request $request)
    {
        $validated = Validator::make($request->all(), [
            'email' => 'required|unique:users|max:255',
            'password' => 'required|min:6',
            'cnfpassword' => 'required_with:password|same:password|min:6'
        ]);
        if ($validated->fails()) {
            // dd($validated->errors()->all());
            return redirect()->back()->with('validationerror', $validated->errors()->all());
        }
        $password = Hash::make($request->password);

        $providers = new User();
        $extension = array("jpeg", "jpg", "png", "jfif");
        if (isset($request->image)) {
            $file = $request->image;
            $ext = $request->image->getClientOriginalExtension();
            if (in_array($ext, $extension)) {
                $file_name = $request->image->getClientOriginalName();
                $file_name = substr($file_name, 0, strpos($file_name, "."));
                $name = "uploads/profile/" . $file_name . "_" . time() . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path() . '/uploads/profile/';
                $share = $request->image->move($destinationPath, $name);
                $image = $name;
                $providers->image = $image;
            } else {
                $warning = "This File type is not Supported!";
                return redirect()->back()->with('error', "Error Code: " . $warning);
            }
        }

        $providers->role_id = $request->role_id ??'';
        $providers->role_type = $request->role_type ??'';
        $providers->name = $request->name ??'';
        $providers->email = $request->email;
        $providers->password = $password;
        $providers->phone = $request->phone ??'';
        $providers->address = $request->address ??'';
        $providers->save();
        return redirect()->back()->with('message', 'Providers Registered Sucessfully');
    }
    public function deleteProfile(Request $request)
    {
        if ($request->id) {
            $user = User::where('id', $request->id)->first();
            if ($user) {
                $user->delete();
                return response()->json(['status' => 1, 'message' => 'User Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'User Not Found!']);
    }
    public function USerPasswordManage(Request $request)
    {
        $validated = Validator::make($request->all(), [
            'newpassword' => 'required|min:6',
            'cnfpassword' => 'required_with:newpassword|same:newpassword|min:6'
        ]);
        $auth = Auth::user();
        if ($validated->fails()) {
            // dd($validated->errors()->all());
            return redirect()->back()->with('validationerror', $validated->errors()->all());
        }
        $password = Hash::make($request->newpassword);
        $passChnage =  User::find($request->id);
        $passChnage->password = $password;
        $passChnage->save();
        return redirect()->back()->with('message', 'Password Change Successfully');
    }

    public function packageView(){
        $package = Packages::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.packages.packageView', compact('package'))->with('title','packages view');
    }

    public function packageCreate($id){
        if ($id > 0) {
            $package = Packages::find($id);
            if ($package) {
                return view('admin.pages.packages.packageCreate', compact('package'))->with('title', 'package edit');
            }
        }
        return view('admin.pages.packages.packageCreate')->with('title','package create');
    }

    public function packageSave(Request $request){
        $packageId = $request->input('package_id');

        if ($packageId) {
            $package = Packages::find($packageId);
            if (!$package) {
                return redirect()->back()->with('error', 'package not found.');
            }
        } else {
            $package = new Packages();
        }

        $package->title = $request->title ??'';
        $package->price = $request->price ??'';
        $package->desc = $request->desc ??'';
        // dd($package);
        $package->save();
        return redirect()->back()->with('message','Record save successfully');
    }

    public function packageDelete(Request $request)
    {
        if ($request->id) {
            $package = Packages::where('id', $request->id)->first();
            if ($package) {
                $package->is_active = 0;
                $package->is_deleted = 1;
                $package->save();

                return response()->json(['status' => 1, 'message' => 'Package Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'Package Not Found!']);
    }

    public function allAppointmentFilter(Request $request) {
        $filterby = "all";
        $allAppointments = Appointment::where('type', 'member')->where('is_active', 1)->where('is_deleted', 0);
        if (isset($request->filter_by)) {
            $filterby = $request->filter_by;
            if ($filterby == 'weekly') {
                $allAppointments->whereBetween('appointment_date', [now()->startOfWeek(), now()->endOfWeek()]);
            } elseif ($filterby == 'monthly') {
                $allAppointments->whereMonth('appointment_date', now()->month);
            }
        }
        $allAppointments = $allAppointments->get();
        return view('admin.pages.appointment.allMemeberapointments', compact('allAppointments','filterby'))->with('title','All Appointment Members');
    }

    public function announcementView(){
        $announcement = Announcement::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.announcement.announcementView', compact('announcement'))->with('title','announcement view');
    }

    public function announcementCreate($id){
        if ($id > 0) {
            $announcement = Announcement::find($id);
            if ($announcement) {
                return view('admin.pages.announcement.announcementCreate', compact('announcement'))->with('title', 'announcement edit');
            }
        }
        return view('admin.pages.announcement.announcementCreate')->with('title','announcement create');
    }

    public function announcementSave(Request $request){
        $announcementId = $request->input('announcement_id');
        if ($announcementId) {
            $announcement = Announcement::find($announcementId);
            if (!$announcement) {
                return redirect()->back()->with('error', 'announcement not found.');
            }
        }else {
            $announcement = new Announcement();
        }
        $announcement->title = $request->title ?? '';
        $announcement->message = $request->message ?? '';
        $announcement->save();

        $data["subject"] = $request->title ?? '';
        $data["announcement"] = $request->message ?? '';

        $patients = User::where('role_id', 2)->get();
        $mails = $patients->pluck('email')->toArray();
        Mail::send('web.pages.mailing.announcement', $data, function ($message) use ($mails, $data) {
            $message->to($mails);
            $message->subject($data['subject']);
        });

        $details = [
            'title' => $request->title,
            'announcement' => $request->message,
        ];

        foreach ($patients as $patient) {
            $patient->notify(new AnnouncementNotification($details));
        }

        return redirect()->back()->with('message','Record save successfully');
    }

    public function medicalProfilePatient($id) {
        $appointments = Appointment::where('user_id', $id)
        ->where('status', 'completed')
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get();

        $appointmentId = $appointments->pluck('id');

        $medicalReports = AppointmentReport::whereIn('appointment_id', $appointmentId)
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get()
        ->groupBy('appointment_id');

        return view('admin.pages.patient.medicalProfile', compact('medicalReports','appointments'))->with('title','Medical Profile');
    }

    public function medicationReport($id) {
        $latestAppointment = Appointment::where('user_id', $id)
        ->where('status', 'completed')
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->latest('appointment_date')
        ->first();

        $medication = null;

        if ($latestAppointment) {
            $medication = AppointmentMedication::where('appointment_id', $latestAppointment->id)
                ->where('is_active', 1)
                ->where('is_deleted', 0)
                ->first();
        }

        $futureAppointments = Appointment::where('user_id', $id)
        ->where('type', 'member')
        ->where('appointment_date', '>', Carbon::now())
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get();

        $order = PatientOrders::where('patient_id', $id)
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get();

        return view('admin.pages.patient.medicationProfile', compact('medication','futureAppointments','order'))->with('title','Patient Medication Report');
    }

    public function usersNewsletters() {
        $newsletter = NewsLetter::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.newsletter', compact('newsletter'))->with('title','Subscribe newsletter list');
    }
    public function newslettersDelete(Request $request)
    {
        if ($request->id) {
            $newsletter = NewsLetter::where('id', $request->id)->first();
            if ($newsletter) {
                $newsletter->is_active = 0;
                $newsletter->is_deleted = 1;
                $newsletter->save();

                return response()->json(['status' => 1, 'message' => 'Record Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'Record Not Found!']);
    }
}
