<?php
// PHP code at the TOP of the file
$ip = $_SERVER['REMOTE_ADDR'];
 
// Initialize with default values
$city = 'Unknown';
$country = 'Unknown';
$ip_address = $ip;
$device = 'Desktop';
 
// Try multiple geolocation methods
try {
    // Method 1: ipwho.is API
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => "http://ipwho.is/{$ip}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($response !== false && $http_code === 200) {
        $ipwhois = json_decode($response, true);
        if (isset($ipwhois['success']) && $ipwhois['success'] === true) {
            $city = !empty($ipwhois['city']) ? $ipwhois['city'] : 'Unknown';
            $country = !empty($ipwhois['country']) ? $ipwhois['country'] : 'Unknown';
            $ip_address = !empty($ipwhois['ip']) ? $ipwhois['ip'] : $ip;
        } else {
            // If ipwho.is fails, try alternative API
            $city_country = getGeolocationFromAlternativeAPI($ip);
            $city = $city_country['city'];
            $country = $city_country['country'];
        }
    } else {
        // If curl fails, try alternative API
        $city_country = getGeolocationFromAlternativeAPI($ip);
        $city = $city_country['city'];
        $country = $city_country['country'];
    }
    curl_close($ch);
} catch (Exception $e) {
    // Fallback to alternative method on error
    $city_country = getGeolocationFromAlternativeAPI($ip);
    $city = $city_country['city'];
    $country = $city_country['country'];
}
 
// Device detection
if (isset($_SERVER['HTTP_USER_AGENT'])) {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    if (preg_match('/(android|iphone|ipad|mobile)/i', $user_agent)) {
        $device = 'Mobile';
    } elseif (preg_match('/(tablet|ipad|playbook|silk)/i', $user_agent)) {
        $device = 'Tablet';
    }
}
 
$actual_link = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$now = new DateTime();
$current_time = $now->format('l, F j, Y');
 
// Alternative geolocation function
function getGeolocationFromAlternativeAPI($ip) {
    $city = 'Unknown';
    $country = 'Unknown';
    // Try ip-api.com
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => "http://ip-api.com/json/{$ip}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 3
    ]);
    $response = curl_exec($ch);
    if ($response !== false) {
        $data = json_decode($response, true);
        if (isset($data['status']) && $data['status'] === 'success') {
            $city = !empty($data['city']) ? $data['city'] : 'Unknown';
            $country = !empty($data['country']) ? $data['country'] : 'Unknown';
        }
    }
    curl_close($ch);
    return ['city' => $city, 'country' => $country];
}
?>
<!doctype html>
<html lang="en">
<head>
<?php include 'includes/utils/links.php'; ?>
</head>
<body>
<?php include 'includes/utils/addons.php'; ?>
<?php include 'includes/shared/navbar.php'; ?>
