<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page Not Found | 404 Error</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: #fff;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            color: #333;
        }
        
        .container {
            max-width: 800px;
            width: 100%;
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .header {
            background: #4a6cf7;
            color: white;
            padding: 30px;
            text-align: center;
            background: linear-gradient(18deg, rgb(212, 77, 241), rgb(152, 65, 238), rgb(255, 134, 66));
        }
        
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .content {
            padding: 40px;
            text-align: center;
        }
        
        .error-code {
            font-size: 8rem;
            font-weight: bold;
            color: #292a2c;
            line-height: 1;
            margin-bottom: 20px;
            text-shadow: 3px 3px 0px #eee;
        }
        
        .error-message {
            font-size: 1.8rem;
            margin-bottom: 20px;
            color: #555;
        }
        
        .error-description {
            font-size: 1.1rem;
            line-height: 1.6;
            color: #666;
            margin-bottom: 30px;
        }
        
        .actions {
            display: flex;
            justify-content: center;
            gap: 15px;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 12px 25px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-block;
        }
        
        .btn-primary {
            background: #4a6cf7;
            color: white;
            background: linear-gradient(18deg, rgb(212, 77, 241), rgb(152, 65, 238), rgb(255, 134, 66));
        }
        
        .btn-primary:hover {
            background: #3a5ae0;
            transform: translateY(-2px);
        }
        
        .btn-secondary {
            background: transparent;
            color: #252629;
            border: 2px solid #222326;
        }
        
        .btn-secondary:hover {
            background: #f0f3ff;
            transform: translateY(-2px);
        }
        
        .search-box {
            margin-top: 30px;
            display: flex;
            justify-content: center;
        }
        
        .search-input {
            padding: 12px 20px;
            border: 2px solid #ddd;
            border-radius: 50px 0 0 50px;
            width: 60%;
            font-size: 1rem;
            outline: none;
            transition: border 0.3s;
        }
        
        .search-input:focus {
            border-color: #4a6cf7;
        }
        
        .search-btn {
            background: #4a6cf7;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 0 50px 50px 0;
            cursor: pointer;
            font-weight: 600;
            transition: background 0.3s;
        }
        
        .search-btn:hover {
            background: #3a5ae0;
        }
        
        .footer {
            margin-top: 40px;
            font-size: 0.9rem;
            color: #888;
        }
        
        @media (max-width: 600px) {
            .error-code {
                font-size: 5rem;
            }
            
            .error-message {
                font-size: 1.5rem;
            }
            
            .actions {
                flex-direction: column;
                align-items: center;
            }
            
            .btn {
                width: 100%;
                text-align: center;
            }
            
            .search-box {
                flex-direction: column;
                align-items: center;
            }
            
            .search-input {
                width: 100%;
                border-radius: 50px;
                margin-bottom: 10px;
            }
            
            .search-btn {
                width: 100%;
                border-radius: 50px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Oops! Page Not Found</h1>
            <p>It seems you've encountered a missing page</p>
        </div>
        
        <div class="content">
            <div class="error-code">404</div>
            <div class="error-message">We can't find the page you're looking for</div>
            
            <div class="actions">
                <a href="/" class="btn btn-primary">Go to Homepage</a>
                <a href="javascript:history.back()" class="btn btn-secondary">Go Back</a>
            </div>
  
            <div class="footer">
                <p>If you believe this is an error, please contact our support team</p>
            </div>
        </div>
    </div>

    <script>
        // Simple search functionality
        document.querySelector('.search-btn').addEventListener('click', function() {
            const searchQuery = document.querySelector('.search-input').value;
            if (searchQuery.trim() !== '') {
                window.location.href = '/search?q=' + encodeURIComponent(searchQuery);
            }
        });
        
        document.querySelector('.search-input').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                document.querySelector('.search-btn').click();
            }
        });
    </script>
</body>
</html>