{{ ucfunc("put_docready_start") }}
		
    	
	const grid = document.querySelector('#{{uc_id}}')
    
    function getColumnsCount() {
      return getComputedStyle(grid).getPropertyValue('--col-count')
    }
  	
  	function updateStyleTag() {
      
      grid.parentElement.querySelector('#styles_{{uc_id}}')?.remove()
     
      const columnsCount = getColumnsCount()
      
      const styleTag = document.createElement('style')
      styleTag.id = 'styles_{{uc_id}}'
      	styleTag.textContent = `#{{uc_id}} .ue-rhombus-gallery__item:nth-child(${columnsCount*2}n+1) { grid-column: 2/span 2; }`
	  grid.insertAdjacentElement('beforebegin', styleTag)
	}
	
	function setGridBottomPadding() {
		const itemHalfHeight = grid.querySelector('.ue-rhombus-gallery__item').getBoundingClientRect().height / 2
		grid.style.paddingBottom = `${itemHalfHeight}px`
	}

    function onResize() {
		grid.classList.remove('uc-show')
        updateStyleTag()
        setGridBottomPadding()
		grid.classList.add('uc-show')
    }

	function setActiveItem(){

		var clickedItem = jQuery(this);
		var rhombusItems = clickedItem.siblings();
		var classActive = 'ue-active-item';

		rhombusItems.removeClass(classActive);
		clickedItem.addClass(classActive);

	}

	window.addEventListener('resize', onResize)

	onResize()
	

	var objGrid = jQuery('#{{uc_id}}');
	var objGridItem = objGrid.find('.ue-rhombus-gallery__item');

	objGridItem.on('click', setActiveItem);

	objGrid.on('uc_ajax_refreshed', () => {
		onResize()
	})

  {% if uc_inside_editor == 'yes' %}

	function setResizeObserver() {

		const previewFrame = window.parent.document.querySelector('#elementor-preview-iframe')

		if (!previewFrame) {
			setTimeout( ()=> { setObserver() }, 300 )
		} else {

          const observer = new ResizeObserver(function(entries) {
              onResize()
          });

          observer.observe(previewFrame);
		}
	}

	setResizeObserver()

  {% endif %}
    
	  var objRemoteOptions = {
      class_items:"ue-rhombus-gallery__item",
      class_active:"ue-active-item",
      selector_item_trigger:null,
	  add_set_active_code:true
    };

    {{ucfunc("put_remote_parent_js","objGrid","objRemoteOptions")}}  

{{ ucfunc("put_docready_end") }}