#{{uc_id}}.ue-rhombus-gallery {
  --col-count: {{columns_count}};
  	--columns-count: calc(var(--col-count) * 2 + 1);
  display: grid;
  grid-template-columns: repeat(var(--columns-count), 1fr);
  opacity: 0;
  transition: opacity 0.2s ease-in-out;
}

#{{uc_id}}.ue-rhombus-gallery.uc-show {
  opacity: 1;
}

#{{uc_id}} .ue-rhombus-gallery__item {
  z-index: 1;
  grid-column: span 2;
  margin-bottom: -50%; 
  -webkit-clip-path: polygon(50% 0%, 100% 50%, 50% 100%, 0% 50%);
  clip-path: polygon(50% 0%, 100% 50%, 50% 100%, 0% 50%);
  transition: all 0.25s;
  aspect-ratio: 1 / 1;
  width:100%;
  overflow: hidden;
}

#{{uc_id}} .ue-rhombus-gallery__item-wrapper {
  position: relative;
  height: 100%;
  width: 100%;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  text-align:center;
}

#{{uc_id}} .ue-rhombus-gallery__item-content-wrapper {
  display: flex;
    flex-direction: column;
    justify-content: center;
  z-index: 1;
}

#{{uc_id}} .ue-rhombus-gallery__item-border {
  position: absolute;
  inset: 0;
  height: 100%;
  width: 100%;
  background-color: transparent;
  transform: rotate(45deg) scale(0.7071);
  pointer-events: none;
}

#{{uc_id}} .ue-rhombus-gallery__item-image {
  position: absolute;
  inset: 0;
  height: 100%;
  width: 100%;
  z-index: 0;
  object-fit: cover;
}

#{{uc_id}} .ue-rhombus-gallery__item:hover {
  z-index: 3;
}

{% if background_image_hover_grow == 'true' %}
  #{{uc_id}} .ue-rhombus-gallery__item .ue-rhombus-gallery__item-image {
    transition: transform {{background_image_hover_grow_speed}}ms linear;
  }
  #{{uc_id}} .ue-rhombus-gallery__item:hover .ue-rhombus-gallery__item-image {
    transform: scale(1.1);
  }
{% endif %}

#{{uc_id}} .ue-rhombus-gallery__item.ue-active-item .ue-rhombus-gallery__item-image {
  transition: transform {{background_image_hover_grow_speed}}ms linear;
}
#{{uc_id}} .ue-rhombus-gallery__item.ue-active-item .ue-rhombus-gallery__item-image {
  transform: scale(1.1);
}

#{{uc_id}} .ue-overlay-link {
  position: absolute;
  inset: 0;
}

#{{uc_id}} .ue-graphic-element
{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  line-height:1em;
  overflow:hidden;
  z-index: 1;
}

#{{uc_id}} .ue-graphic-element svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue-graphic-element img
{
  display:block;
}

.ue-item-title
{
  font-size:21px;
}

@media screen and (max-width: 1024px) {
	#{{uc_id}}.ue-rhombus-gallery {
      --col-count: {% if columns_count_tablet == '' %} {{columns_count}} {% else %} {{columns_count_tablet}}  {% endif %};
      --columns-count: calc(var(--col-count) * 2 + 1);
    }
}

@media screen and (max-width: 767px) {
	#{{uc_id}}.ue-rhombus-gallery {
      --col-count: {% if columns_count_mobile == '' %} {{columns_count}}  {% else %} {{columns_count_mobile}}  {% endif %};
  	  --columns-count: calc(var(--col-count) * 2 + 1);
    }
}

body[data-elementor-device-mode="desktop"] #{{uc_id}} .ue-rhombus-gallery__item.ue-desktop-hide {
	display: none;
}

body[data-elementor-device-mode="tablet"] #{{uc_id}} .ue-rhombus-gallery__item.ue-tablet-hide {
	display: none;
}

body[data-elementor-device-mode="mobile"] #{{uc_id}} .ue-rhombus-gallery__item.ue-mobile-hide {
	display: none;
}