<?php
    $content = [
        "book-writing" => [
            "title"=>"Why should you Hire e-Book Ghostwriting Services to Ghostwrite your book?",
            [
                "heading" => "Customized Cooperation:",
                "description" => "Our strategy is centered on collaboration. A creative process revolves around your ideas, voice, and style. We collaborate with you when we write, not just for you. Your active involvement guarantees that your distinct authorial identity is reflected in the narrative from the first consultation to the final draft.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Open and Accountable Procedure:",
                "description" => "The foundation of our book writing service is transparency. We guarantee that you are informed and involved at every turn by offering transparent insights into our ghostwriting procedure. We not only appreciate but also strongly encourage your input. Our goal is to establish a transparent, cooperative atmosphere that supports your book’s development.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Worldwide Perspective:",
                "description" => "Your book is an international journey, not just a local project. Our book writers approach our ghostwriting with a global viewpoint to make sure your story speaks to a wide range of readers. Regardless of your goals—a domestic best-seller or worldwide recognition—our global vision complements your desire for broad success.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Professionalism and Confidentiality:",
                "description" => "We recognize the value of maintaining anonymity and the sensitivity of your ideas. We guarantee that your project will be handled with the highest discretion and respect thanks to our dedication to professionalism. Our book writing service includes valuing your trust above everything else, and we protect the privacy of your story at every stage.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Guiding Counsel",
                "description" => "We provide individualized advice on navigating the publishing landscape in addition to ghostwriting. Our specialists offer tips and assistance whether you’re thinking about self-publishing, traditional publishing channels, or literary representation. Our goal is to help you succeed not only throughout the writing phase but also throughout the publication process.",
                "img" => "assets/images/icons/5.webp",
            ],
        ],
        
        "book-editing" => [
            "title"=>"All-inclusive Book Editing Services Crafted to Excel",
            [
                "heading" => "Copy Editing",
                "description" => "We guarantee that your document is error-free in syntax and grammar thanks to our thorough copy editing services. Our book editors for hire examine the nuances of language in great detail, perfecting word selections and phrase constructions for maximum clarity. Bid farewell to grammatical mistakes and welcome a story that flows with natural accuracy.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Proofreading",
                "description" => "With this book editing company’s committed proofreading services, you may polish your text to absolute perfection. Every page is carefully examined by our team of highly skilled proofreaders, who fix typos, inconsistent grammar, and formatting mistakes. You may rely on us to provide a manuscript that is polished and meticulous.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Manuscript Review",
                "description" => "Use our in-depth manuscript assessment to go out on a literary refinement path. Our seasoned book editors for hire examine your story’s general structure, thematic consistency, and plot development. Get priceless advice on how to improve the narrative’s flow and draw in the audience.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Line Editing",
                "description" => "As we take your writing to new levels, feel the transforming power of line editing. Our line editing services prioritize linguistic improvement, sentence-level enhancement, and maintaining stylistic coherence. Your text is painstakingly transformed into a story that speaks with clarity and creative elegance by our editing services for writers.",
                "img" => "assets/images/icons/4.png",
            ]
        ],

        "ghostwriting-company" => [
            "title"=>"You name it, we’ll write it!",
            [
                "heading" => "Book Ghostwriting",
                "description" => "Weaving a dream of becoming an author for a long? Whether you’re an aspiring author with a story to tell, a professional seeking to share your expertise, or a public figure with a captivating life narrative, our professional ghostwriters specialize in crafting literary masterpieces across genres. From fiction to non-fiction, memoirs to business books, we transform your ideas into captivating narratives, ensuring your voice resonates with readers. Collaborate with our ghostwriters for hire to turn your vision into a professionally written and polished book that stands out in the competitive world of publishing. ",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Business Ghostwriting",
                "description" => "Want to elevate your professional image? In the corporate world, effective communication is paramount. Our ghostwriting company specializes in translating complex business ideas into clear, engaging content. From thought leadership articles and business blogs to whitepapers and executive speeches, we help you convey your insights with authority and impact. Partner with us to enhance your brand, establish thought leadership, and reinforce your professional image through meticulously crafted business-focused content.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Speech and Public Address Ghostwriting",
                "description" => "Captivate your audience with words through our speech and public address ghostwriting company. Whether you’re a public speaker, executive, or individual preparing for a special occasion, our skilled ghostwriters specialize in crafting speeches that resonate. From keynote addresses and TED talks to ceremonial speeches and event scripts, we understand the power of language to move, inspire, and leave a lasting impression. Collaborate with us to ensure that your words are not just spoken but are a symphony that lingers in the hearts and minds of your audience.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Academic Ghostwriting",
                "description" => "Having trouble navigating the academic realm with ease? Whether you’re a student aiming for academic success, a researcher seeking assistance in articulating findings, or an educator looking to enhance curriculum materials, our expert ghostwriting company are here to support your educational pursuits. From essays and research papers to thesis statements and curriculum development, we provide comprehensive academic writing solutions that adhere to scholarly standards. Trust our professional ghostwriters to transform your ideas into well-researched, structured, and academically sound content.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Personal and Creative Ghostwriting",
                "description" => "Express your unique voice through our personal and creative ghostwriting company. For creative projects, personal stories, or unique expressions, our ghostwriters for hire are adept at capturing the essence of your vision. Whether it’s poetry, creative fiction, or personal narratives, we provide a platform for your thoughts and emotions. Let our writers infuse life into your ideas, creating a tapestry of words that reflects your personality and resonates with authenticity. Partner with us to turn your creative aspirations into beautifully crafted pieces that leave a lasting impact.",
                "img" => "assets/images/icons/5.webp",
            ],
            [
                "heading" => "Content Marketing Ghostwriting",
                "description" => "Want to fuel your online presence? In the digital age, content is king, and the ghostwriters at our ghostwriting company are adept at creating engaging, SEO-friendly content that drives results. From website copy and blog posts to social media content and email campaigns, we tailor our writing to align with your brand voice and marketing goals. Partner with us to amplify your online presence, connect with your target audience, and establish a compelling narrative that captivates and converts.",
                "img" => "assets/images/icons/6.png",
            ],
        ],
        "fiction-writing" => [
            "title"=>"Getting Around the Fictional Frontier Revealing Our Unique Six-Step",
            [
                "heading" => "Narrative Creating Process Conversation at First",
                "description" => "Take off on your literary adventure with the Inception Dialogue, a fully immersive conversation in which we reveal the central plot of your work. We uncover your concepts, themes, and the core of your narrative through in-depth conversations, setting the stage for a creative journey.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Investigating Genres",
                "description" => "In the Genre Exploration, examine the very structure of your narrative. Our fiction ghostwriter explore and select the genre that best fits your story together, guaranteeing a genuine resonance. Whether it’s the romance, mystery, or fantasy that enchants you, we create the path that will make your book uniquely you.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Word Craftsman Pairing",
                "description" => "Watch the magic of Word Artisan Matching as we carefully match you with a knowledgeable transcriptionist. Your assigned fiction ghostwriter becomes an artistic collaborator who brings expertise and passion to your story. This customized partnership guarantees a smooth integration of your idea and the writer’s skill.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Character Illustration",
                "description" => "Enter the world of Character Portraiture, where you will encounter enemies, heroes, and supporting characters. Our fiction ghostwriters go into their arcs, motivations, and personas, ensuring a cast that is authentic and adds to the grandeur of your story. Characters become more than simply words; they become emotional and relatable conduits.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Sculpting the Plot",
                "description" => "Step inside Plot Sculpting, where we will shape the plot, the heart and soul of your book. Our fiction ghostwriters hone your ideas through collaborative meetings, adding layers of intricacy, intrigue, and feeling. The outcome is a captivating story that draws readers in from the first page.",
                "img" => "assets/images/icons/5.webp",
            ],
        ],
        "memoir-writing" => [
            "title"=>"Six Steps to Writing a Masterpiece Memoir!",
            [
                "heading" => "Tea Party Story: Let’s Talk",
                "description" => "Now let’s have a nice conversation! We partake in figurative tea—or coffee, whichever you prefer—while you narrate brief accounts of your experiences. This charming conversation enables us to comprehend your distinct storytelling approach, eccentricities, and the core of your tale.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Plotting Your Path: Memoir Blueprinting",
                "description" => "Consider this stage as creating our treasure map! Our memoir writers for hire carefully map out the turns and turns of the narrative in your memoir. We work together to outline the major incidents, figures, and scenes that make your story as engrossing as a pirate’s tale.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "The Writing Dance: Tippy-Tap Typing Time",
                "description" => "It’s time to perform a pirouette motion with our fingers on the keyboard! Our talented memoir ghostwriters steal the show as they turn your stories into elegant prose. Your tales come to life with each keystroke, moving through the pages in a word dance.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Dress Rehearsal: Memoir Makeover",
                "description" => "It’s time to change into a new costume after the first draft has finished pirouetting through! We refine and polish, giving your memoir the figurative equivalent of a makeover for a ballroom. Your tale takes on an even more alluring quality, gleaming like a newly polished mirror ball.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Lights, Camera, Review!",
                "description" => "Action, camera, lights! We put on our director’s hats and go over your memoir’s final cut. Making sure your story shines as brightly as the stars is the main goal of this phase. The memoir ghostwriters examine every aspect to make sure it’s spectacular and prepared for its world premiere!",
                "img" => "assets/images/icons/5.webp",
            ],
            [
                "heading" => "Premiere Night: Reveal Your Masterpiece",
                "description" => "Please start the drum roll! It’s time for the big reveal of your memoir. We extend a warm invitation to readers to delve into your engrossing story. Your story steals the show, captivating the audience and making them want more. It’s your life’s work of art, revealed for the world to admire, not just a book.",
                "img" => "assets/images/icons/6.png",
            ],
            
        ],
        "biography-writing" => [
            "title"=>"Personalized Biographical Services for Each Narrative",
            [
                "heading" => "Standard biographies",
                "description" => "Standard biographies are in-depth accounts of a person’s life that include key moments, accomplishments, and noteworthy experiences. These can be anything from succinct synopses to extensive narratives. Our professional biography writers follow a chronological structure, presenting events in the order in which they occurred. This helps readers grasp the developmental arc of the subject’s life. We aim to provide a thorough and well-rounded portrait of you.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Memoirs",
                "description" => "Dedicated to highlighting particular eras, topics, or life lessons. Memoirs frequently go in-depth on the subject’s feelings, personal observations, and particular experiences. Authors share not only the events of their lives but also their feelings, struggles, and personal growth, creating a deep emotional connection with readers. Our professional biography writer understands every point and delivers its best.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Family biographies",
                "description" => "Documenting a family’s or lineage’s history and experiences over several generations in order to preserve cultural heritage and morals. Family biographies encompass multiple generations, tracing the lineage and stories of various family members. Our biography writing service’s holistic approach provides a comprehensive understanding of the family’s history.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Celebrity or Public Figure Biographies",
                "description" => "Our biography writer for hire traces the celebrity’s career trajectory, highlighting significant milestones, breakthroughs, and pivotal moments in their professional journey. This includes the projects that garnered acclaim and recognition. Our Celebrity biographies explore the balance between a public persona and the private life of the individual. Through this readers gain insights into how celebrities navigate the challenges of fame and maintain a sense of self.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Corporate biographies",
                "description" => "A record of an organization’s origins, development, and significant turning points that emphasize the individuals, inventions, and difficulties that contributed to the business’s success. Our corporate professional biography writer delves into the historical evolution of the company, tracing its origins, the vision of its founders, and the early years of establishment. This provides context for understanding the organization’s roots.",
                "img" => "assets/images/icons/5.webp",
            ]
        ],
        "autobiography-writing" => [
            "title"=>"Search for the Ideal Ghostwriter for Autobiography",
            [
                "heading" => "Customized Consultation",
                "description" => "We start the process with a one-on-one session to better grasp your autobiography’s purpose, voice, and tale. We can better understand the subtleties that make your story distinctively yours thanks to this in-depth conversation.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Expertise Matching",
                "description" => "We are proud of the varied backgrounds and specializations within our staff of seasoned autobiography ghostwriters. Whether the foundation of your life story is in business, the arts, academics, or any other sector, we take great care to pair you with a ghostwriter whose experience and background fit your narrative.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Aligning Writing Styles",
                "description" => "Every writer has a unique style, and we understand how important it is to match your preferences with this style. We take into account the writing style, tone, and pacing while making our selections to make sure it fits in perfectly with your story voice.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Cooperation Method",
                "description" => "We think that working together is essential to the writing process. Your selected autobiography ghostwriter becomes into a creative collaborator, collaborating closely with you to distill the essence of your experiences and present them truthfully in the pages of your memoir.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Frequent check-ins",
                "description" => "The trick is to communicate. We arrange for frequent check-ins to go over the status, resolve any issues, and take into account your input. This guarantees that the story will play out precisely as you have envisioned, giving you the chance to make changes as you go.",
                "img" => "assets/images/icons/5.webp",
            ],
            [
                "heading" => "Understanding and Sensitivity",
                "description" => "Trust and understanding are necessary for sharing personal narratives. Every ghost writer autobiography project that our ghostwriters take on is handled with tact and understanding, providing a secure environment in which you may share your ideas, recollections, and feelings.",
                "img" => "assets/images/icons/6.png",
            ]
        ],
        "business-book-writing" => [
            "title"=>"Different kinds of business book writing eBook Ghostwriting Services has to offer:",
            [
                "heading" => "Brand Storytelling: Crafting Emotional Connections with Your Audience",
                "description" => "Every successful brand has an enthralling backstory at its core. Our services for brand storytelling go above and beyond the ordinary, crafting stories that evoke strong feelings in your target audience. We incorporate narrative into your brand’s DNA, from origin stories to brand progression.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Company Blogs: A Vital Source for Your Content Marketing Machine",
                "description" => "The foundation of content marketing is a blog, and our business book ghostwriters can help you maintain your site operating efficiently with our business blog ghostwriting services. Our ghostwriters create blog entries that establish your company as the authority in your sector, whether they are filled with industry insights, current events, or professional guidance.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Email Marketing: Creating Converting Messages",
                "description" => "With the help of our ghostwritten messages, maximize the potential of your email campaigns. We guarantee that your emails, whether they are newsletters or targeted campaigns, reach recipients’ inboxes and compel them to interact, leading to conversions.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Press Releases: How to Make Your Story Stand Out",
                "description" => "Our corporate ghostwriting services go far beyond the established categories and are very adaptable. Our talented business ghostwriters can customize their skills to fit your exact needs if you have a specific writing project for your company.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Personalized Content Creation: Adapted to Your Requirements",
                "description" => "The trick is to communicate. We arrange for frequent check-ins to go over the status, resolve any issues, and take into account your input. This guarantees that the story will play out precisely as you have envisioned, giving you the chance to make changes as you go.",
                "img" => "assets/images/icons/5.webp",
            ]
        ],
        "hip-hop-writing" => [
            "title"=>"Our Five Adaptable Hip Hop Ghostwriting Services",
            [
                "heading" => "Lyric Enhancement",
                "description" => "Our ghostwriters for rappers can help you bring your ideas to life, whether you merely have a concept or a rough draft of lyrics. We polish and improve the lyrics you already have, giving them depth, flow, and that distinct hip-hop flare.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Original Work",
                "description" => "Our unique writing service is the ideal choice for individuals who are just getting started. We create original, custom lyrics that fit your message, style, and desired beats. It’s a completely original hip-hop composition.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Flexible Genre Adjustment",
                "description" => "Our hip-hop ghostwriters for hire are knowledgeable about all of the many hip-hop subgenres, including trap, conscious rap, and everything in between. We customize our writing to your desired hip-hop sound, so it accurately reflects your creative intent.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Complete Album Coordination",
                "description" => "Our full album collaboration service is the best option for anyone looking to create a whole hip-hop record. From the first idea to the very last song, we collaborate with you to create a coherent and memorable record that conveys your narrative and connects with listeners.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Consultation on Performance Dynamics",
                "description" => "Making hip-hop involves more than just crafting words—it also involves delivering them with impact. Beyond just writing, our performance dynamics advice offers guidance on how to make your lines come to life on stage, in the studio, or on your next song.",
                "img" => "assets/images/icons/5.webp",
            ]
        ],
        "grant-writing" => [
                "title"=>"Learn Why Our Grant Writing Services Stand Out",
                [
                    "heading" => "Broad Industry Experience and Expertise",
                    "description" => "Our staff of grant writers has extensive experience and expertise in a range of sectors, including non-profits, healthcare, education, and technology. Because of our industry-specific knowledge, we can comprehend the particular possibilities and problems facing your business and create recommendations that are both compelling and highly relevant. We can draw attention to the crucial elements of your project that will appeal to potential donors the most by utilizing our professional knowledge.",
                    "img" => "assets/images/icons/1.webp",
                ],
                [
                    "heading" => "Tailored Client Coordination",
                    "description" => "We think that individualized cooperation with our clients is the key to establishing long-lasting relationships. As part of our process, we will collaborate closely with you to fully grasp your goals, aspirations, and ideal state. We take your feedback seriously and apply it to the grant proposals so that your voice and goals are reflected in the finished product. This cooperative strategy guarantees that the material is genuine and in line with your objectives while also fostering a sense of teamwork.",
                    "img" => "assets/images/icons/2.webp",
                ],
                [
                    "heading" => "Thorough Analysis and Data-Driven Proposals",
                    "description" => "The incorporation of thoroughly researched and data-driven content is a crucial component of successful grant proposals. Our professional grant writers carry out in-depth research to compile pertinent information, figures, and proof that bolster the necessity and significance of your project. This painstaking attention to detail raises the legitimacy of your proposals and strengthens their appeal to funders. Our research and data support will greatly increase your project’s chances of getting funded.",
                    "img" => "assets/images/icons/3.webp",
                ],
                [
                    "heading" => "Continuous Monitoring and modification",
                    "description" => "The financial landscape is ever-changing, with new awards and financing sources appearing regularly. To find fresh chances that fit your ideas, our grant writing company continually monitors the financing climate to stay up to date on these changes. We make the necessary adjustments to our methods to make sure you are always in a position to benefit from the most recent and pertinent financing opportunities. This proactive strategy maintains the competitiveness and currentity of your funding efforts.",
                    "img" => "assets/images/icons/4.png",
                ],
                [
                    "heading" => "Comprehensive Proposal Review and Refinement",
                    "description" => "We guarantee that each grant proposal goes through a thorough evaluation and improvement process as part of our dedication to quality. Each proposal is carefully edited and checked by us to remove mistakes and improve coherence and clarity. We also take into account input from a variety of stakeholders, including subject-matter experts, to make sure the plan is as solid and convincing as possible. Your entries will be reviewed thoroughly to ensure that they are of the greatest caliber and professionalism.",
                    "img" => "assets/images/icons/5.webp",
                ],
                [
                    "heading" => "Enhanced Competitive Edge",
                    "description" => "In the current competitive grant-seeking landscape, an advantage can make a big difference. By crafting unique grant proposals that funders are interested in, our grant writing services provide you with that competitive edge. We concentrate on emphasizing the distinctive features of your project, demonstrating its potential influence and fit with the objectives of the funder. This focus on uniqueness makes your proposals stand out in a crowded field, improving your chances of getting the money you need.",
                    "img" => "assets/images/icons/6.png",
                ]
            ],
        "white-paper-writing" => [
            "title"=>"Overcoming White Paper Challenges Our Solution-Oriented Approach",
            [
                "heading" => "Defining Clear Objectives",
                "description" => "A clear goal is essential to the success of a white paper. Many companies find it difficult to express their objectives clearly. Our staff works directly with customers to establish specific, measurable, achievable, relevant, and time-bound (SMART) objectives to make sure the white paper complements overarching corporate plans.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Carrying out Extensive Study",
                "description" => "Obtaining precise and pertinent information is crucial to writing credible white papers. To ensure that our content is informative and well-supported, our white paper writers for hire carefully combine primary and secondary research in our research method. To obtain thorough insights, we make use of scholarly articles, industrial databases, and expert interviews.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Creating Captivating Storylines",
                "description" => "It takes expert storytelling to turn complex facts into interesting content. Our white paper writers are skilled at writing compelling stories that draw readers in and successfully convey important points. We develop white papers that effectively communicate to your target audience by fusing compelling storytelling with data-driven insights.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Preserving Brand Voice and Consistency",
                "description" => "Establishing a solid brand identity requires consistency. Our team carefully collaborates with clients to comprehend their messaging and brand voice. To strengthen brand awareness and trust, we make sure that all white papers adhere to the company’s tone and style.",
                "img" => "assets/images/icons/4.png",
            ],
            [
                "heading" => "Fulfilling Tight Deadlines",
                "description" => "Timelines can be difficult, particularly for writing and extensive research assignments. Our knowledgeable staff and effective project management procedures allow us to produce excellent white papers on time without sacrificing quality.",
                "img" => "assets/images/icons/5.webp",
            ],
            [
                "heading" => "Providing Impactful Results",
                "description" => "One of the most common hurdles businesses face is the creation of high-quality, impactful white papers. Time constraints, lack of in-house expertise, and the challenge of translating complex ideas into engaging content often hinder the process. Ebook Ghostwriting understands these obstacles and has developed a streamlined approach to overcome them.",
                "img" => "assets/images/icons/6.png",
            ]
        ],
        "book-formatting" => [
            "title"=>"Customized Style - Reasons to Select eBook Ghostwriting Services for E-book Formatting",
            [
                "heading" => "Accurate Precision",
                "description" => "Our specialty is accuracy. Our ebook formatters take care of even the smallest elements, such as typefaces and spacing, to make sure your book looks great on all digital platforms. We work tirelessly to achieve flawlessness in every facet of your ebook’s design.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "All-encompassing compatibility",
                "description" => "Everyone, everywhere, should be able to access what you have to say. Our formatting specialists make sure your ebook appears great on Kindles, iPads, and other devices by optimizing it for each one. We promise that, on every platform the reader chooses, your literary masterpiece will retain its visual appeal.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Time-Tested Proficiency",
                "description" => "Our years of experience have allowed us to become the go-to company for authors looking for the best ebook formatting possible. Our track record of pleased authors who have seen their books become digital pieces of art speaks for itself. Become one of the many accomplished authors who have trusted our ebook formatting services with their works of literature.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Economical Couture",
                "description" => "It’s not necessary to spend a fortune to look amazing. Our ebook formatting services are reasonably priced without sacrificing quality. Enhance the look of your book without breaking the bank since every writer should have a little glitz in their digital closet. Our eBook Formatting Services- The Fusion of Style and Words!",
                "img" => "assets/images/icons/4.png",
            ]
        ],
        "book-proofreading" => [
            "title"=>"Presenting the perks of eBook Ghostwriting Service's Proofreading Magic",
            [
                "heading" => "Craftsmanship with Compassion",
                "description" => "Proofreading is an art form, not a mechanical duty. We treat every manuscript as though it were a work of art, focusing on the subtleties that set your writing apart. Our book proofreading services provide consistency and clarity while preserving your voice with a kind touch.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Trained Eyes for Detail",
                "description" => "When it comes to proofreading, the finer points are crucial. Our hardworking crew of book proofreaders consists of sharp-eyed word enthusiasts who painstakingly go over every line looking for punctuation errors, spelling errors, and grammatical errors. Nothing eludes our watchful eyes, not even the smallest punctuation mark or the big narrative arc.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Reader-Centric Precision",
                "description" => "Although we take great pleasure in grammatically correct sentences, your readers are our priority. We recognize that the purpose of book proofreading is not merely correctness but also enriching the reader’s experience. We make sure your text is a smooth read for your audience with accuracy and attention.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Manuscript TLC - Tender Loving Corrections",
                "description" => "Working with us on book proofreading is a process full of loving, tender corrections rather than a strict approach. We nurture your writing, transforming possible mistakes into scholastic treasures, rather than just making corrections. Your words are treated carefully so they maintain their substance while shining brilliantly.",
                "img" => "assets/images/icons/4.png",
            ]
        ],
        "children-book-editing" => [
            "title" => "Our Comprehensive Children’s Book Editing Services",
            [
                "heading" => "Manuscript Editing",
                "description" => "With the help of our careful children’s book editing services, elevate your story. Our services cover everything from editing and language to suggesting content that is acceptable for young readers. We make sure your book is not only well-written but also has a deeper impact on young readers.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Structural & Developmental Editing",
                "description" => "Develop an engaging story that appeals to young readers. By offering incisive comments on character arcs, narrative development, and overall story coherence, our developmental children book editors help authors produce a book that stands out in the crowded field of children’s fiction.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Enhancement of Educational Content",
                "description" => "Turn your kid’s book into a teaching tool. Our children book editors work hard to include instructional components into the story in a way that makes your book an invaluable tool for parents and teachers.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Genre-Specific Editing",
                "description" => "Whether your book is a young adult novel or a whimsical picture book, our genre-specific children’s book editing makes sure it satisfies the particular needs and expectations of its intended readership. At eBook Ghostwriting Services, you will get specialists of every genre to make your child’s book a work of unbeatable art. ",
                "img" => "assets/images/icons/4.png",
            ]
        ],
        "book-cover-design" => [
            "title" => "Unveiling Aesthetic Wonders: Diverse Design Techniques by Our Elite Book Cover Artists",
            [
                "heading" => "Illustrative Design",
                "description" => "Our book cover illustrators for hire use visually striking pictures that effectively illustrate story aspects that can captivate an audience and provide an immersive reading experience.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Typographic Mastery",
                "description" => "The book cover designers for hire by eBook Ghostwriting Services make unique and eye-catching book covers by utilizing typography’s power. Skillfully crafted typefaces have the power to both visually arrest and communicate the spirit of your work.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Photographic Brilliance",
                "description" => "Hire book cover designers of eBook Ghostwriting Services that give readers a glimpse into the universe you’ve created within your pages by using expertly taken or carefully chosen photos to capture the essence of your story and bring it to life.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Abstract Artistry",
                "description" => "Embrace the world of abstraction, where distinctive and symbolic images are created by our book cover illustrators for hire to arouse readers’ curiosity and make them want to solve the riddles your book contains.",
                "img" => "assets/images/icons/4.png",
            ]        
        ],
        "book-publishing" => [
            "title" => "Getting on the Road to Book Publishing Greatness",
            [
                "heading" => "Strategic Planning Expertise",
                "description" => "Careful planning is necessary to create a successful Kindle book publishing journey. To guarantee a path toward publishing success, our team works with you to create a strategic plan that is in line with your objectives.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Meticulous Editing Services",
                "description" => "Your manuscript is carefully tended to by our professional editors, who make sure every word is polished to the highest standard. We work hard to make your writing even better under our Amazon publishing services so that readers and critics will take notice.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Outstanding Cover Design",
                "description" => "Your book’s identity is in its cover, especially in the busy literary world. Our designers produce outstanding covers that guarantee your book stands out by drawing attention to it and leaving a lasting impression.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Worldwide Distribution Options",
                "description" => "To provide your book with international exposure, we investigate a wide range of distribution options. We make sure that individuals all over the literary world may access your work.",
                "img" => "assets/images/icons/4.png",
            ] 
        ],
        "book-marketing-company" => [
            "title" => "Our Comprehensive Book Marketing Services",
            [
                "heading" => "Strategic Book Marketing",
                "description" => "Our team of experienced book marketers will design a customized marketing strategy to ensure your book reaches its target audience. From identifying key demographics to planning promotional campaigns, we’ve got you covered.",
                "img" => "assets/images/icons/1.webp",
            ],
            [
                "heading" => "Professional Book Cover Design",
                "description" => "Capture readers’ attention with a visually stunning book cover. Our talented designers will collaborate with you to create a cover that not only represents your story but also entices potential readers.",
                "img" => "assets/images/icons/2.webp",
            ],
            [
                "heading" => "Online Presence Building",
                "description" => "In today’s digital age, a strong online presence is crucial. We’ll optimize your author’s website, set up social media profiles, and implement effective SEO strategies to boost your book’s visibility.",
                "img" => "assets/images/icons/3.webp",
            ],
            [
                "heading" => "Targeted Advertising Campaigns",
                "description" => "Reach your ideal readers with precision through targeted advertising. Our team will design and implement advertising campaigns across various platforms to maximize exposure and engagement.",
                "img" => "assets/images/icons/4.png",
            ] 
        ],
    ];

    // Get the current URL path
    $currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

    // Clean and normalize the path (trim slashes and convert to lowercase)
    $currentPath = trim($currentPath, '/');
    $currentPath = strtolower($currentPath);

    // Adjust path to check for main page cases
    if ($currentPath === "" || $currentPath === "index") {
        $currentPath = "index";
    }

    // Debugging output to check the path being used
    echo "<!-- Debug: Current Path = $currentPath -->";

    // Function to get the matching content based on the URL path
    function getCompanyContent_SR($path, $content)
    {
        // If a matching key is found, return the content. Otherwise, return default content.
        return $content[$path] ?? $content["index"];
    }

    // Fetch the appropriate content based on the current URL path
    $currentPath = explode('/', $currentPath);
    $currentPath = $currentPath[count($currentPath) - 1];
    $data = getCompanyContent_SR($currentPath, $content);
    $title = $data['title'];
    ?>
<section class="modules_wapper_services">
    <div class="container" >
        <div class="head_area mb-4">
            <h2 class="txtcl1"><?php echo htmlspecialchars($title); ?></h2>
        </div>  
        <div class="row d-flex justify-content-start">
            <?php
            if (!empty($data)) {
                foreach ($data as $key => $item) {
                    if ($key === "title") {
                        continue;
                    }
                    ?>
                    <div class="col-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="crd">
                            <img src="<?php echo htmlspecialchars($item['img']); ?>" alt="<?php echo htmlspecialchars($item['heading'] ?? 'Not Found'); ?>">
                            <h3><?php echo htmlspecialchars($item['heading']); ?></h3>
                            <p><?php echo htmlspecialchars($item['description']); ?></p>
                        </div>
                    </div>
                    <?php
                }
            } else {
                echo "<p>No content available for this section.</p>";
            }
            ?>
        </div>
    </div>
</section>
