<?php
    $content = [
        "book-writing" => [
            "heading" => "Seeking direction outside of the writing process?",
            "description" =>"Selecting eBook Ghostwriting Services entails selecting a writing partner who will be committed to your entire endeavor. We are here to help you at every stage, from composition to publication. Hire ghostwriter for book now!",
            "description2" =>"Whether you’re seeking information about our book writing services or need specific assistance we understand the importance of your queries. Expect a swift response from one of our knowledgeable Customer Support Representatives. Or you can contact us at info@ebookghostwriting.com"
        ],
        "ghostwriting-company" => [
            "heading" => "It takes one step to <br/> climb a stair",
            "description" =>"Now let’s begin writing your ebook! To arrange a consultation and go over your project in greater detail, just contact us via our website or give us a call. Our book writing company is eager to assist you in realizing your aspirations of being a published author.",
            "description2" =>"Whether you’re seeking information about our ghostwriting services or need specific assistance we understand the importance of your queries. Expect a swift response from one of our knowledgeable Customer Support Representatives. Or you can contact us at info@ebookghostwriting.com"
        ],
        "book-editing" => [
            "heading" => "It takes one step to climb a stair",
            "description" =>"Now let’s begin writing your book! To arrange a consultation and go over your project in greater detail, just contact us via our website or give us a call. Our book editing company is eager to assist you in realizing your aspirations of being a published author.",
            "description2" =>""
        ],
        "fiction-writing" => [
            "heading" => "Your Unexpected Book Journey with eBook Ghostwriting Services",
            "description" => "We at eBook Ghostwriting Services recognize that your novel is more than just a manuscript—rather, it’s an expression of your creativity, feelings, and narrative skill. Trust us to be your companions as you set out on this artistic journey; we provide more than simply ghostwritten fiction—we give a life-changing experience that will live on forever in the annals of literature. Are you prepared to start your writing adventure?",
            "description2" => "Whether you’re seeking information about our ghostwriting services or need specific assistance we understand the importance of your queries. Expect a swift response from one of our knowledgeable Customer Support Representatives. Or you can contact us at info@ebookghostwriting.com"
        ],
        "memoir-writing" => [
            "heading" => "eBook Ghostwriting Services' Commitment to Excellence",
            "description" => "Our goal as memoir ghostwriters is to enable people to share their special journeys with the world. Everyone, in our opinion, has a story worth saying that can uplift, console, and unite generations. Together with our unwavering confidentiality and craftsmanship, our collaborative approach guarantees that every memoir stands as a testament to the diversity of human experience.",
            "description2" => "We are the first step in helping you create a memoir masterpiece. If you would like to start this literary journey or have any questions, our team can be reached via message. One of our experienced customer service representatives will get back to you right away, answering your questions and assisting you with the first steps. As an alternative, please contact us directly at info@ebookghostwriting.com via email. We can’t wait to help you turn your memories into an exquisitely written memoir that will endure a lifetime."
        ],
        "biography-writing" => [
            "heading" => "Your Biography Treasure is Here",
            "description" => "With eBook Ghostwriting Services, set out on a unique biography adventure. We’re more than simply biography writers for hire, we’re builders of appealing biographies, Whether it’s a captivating life story, a professional profile, or a memoir that leaves an indelible mark, our biography writing services are designed to transform your experiences into an engaging narrative Together, let’s create an ever-lasting story!",
            "description2" => "Whether you’re seeking information about our ghostwriting services or need specific assistance we understand the importance of your queries. Expect a swift response from one of our knowledgeable Customer Support Representatives. Or you can contact us at info@ebookghostwriting.com",
        ],
        "autobiography-writing" => [
            "heading" => "Take Off on Your Literary Adventure Now!",
            "description" => "Your life narrative ought to be conveyed with the sincerity and artistry it merits. We at eBook Ghostwriting Services, cordially encourage you to set out on a literary voyage that will turn your autobiography into an enduring work of art. Give your life meaning, polish your story, and allow our ghostwriters to create a tale that will be remembered for many years to come. Get in touch with us right now to start your amazing literary journey!",
            "description2" => "Whether you’re seeking information about our autobiography writing services or need specific assistance we understand the importance of your queries. Expect a swift response from one of our knowledgeable Customer Support Representatives. Or you can contact us at info@ebookghostwriting.com",
        ],
        "business-book-writing" => [
            "heading" => "Together, we can enhance your business narrative!",
            "description" => "Choosing to work with eBook Ghostwriting Services is an investment in the transformational power of words, not just in business ghostwriting services. Allow us to craft tales that speak to your target audience, motivate them, and help you build a brand that will reach new heights. Are you prepared to write your success story with me? Come along for the literary ride with us now!",   
            "description2" => "Whether you’re seeking information about our business ghostwriting services or need specific assistance we understand the importance of your queries. Expect a swift response from one of our knowledgeable Customer Support Representatives. Or you can contact us at info@ebookghostwriting.com",
        ],
        "hip-hop-writing" => [
            "heading" => "Your Hip-Hop Odyssey Begins Here",
            "description" => "With eBook Ghostwriting Services, set out on a unique hip-hop adventure. We’re more than simply ghostwriters for rappers, we’re master builders of hip-hop, from creating distinctive sound identities to narrating gripping stories through your songs. Select us, and let the beats of your own rhythm distinctively resonate with your music. This is the beginning of your tale, your style, and your hip-hop journey. Together, let’s create some musical magic!"   ,
            "description2" => "Whether you’re seeking information about our hip hop ghostwriting or need specific assistance we understand the importance of your queries. Expect a swift response from one of our knowledgeable Customer Support Representatives. Or you can contact us at info@ebookghostwriting.com"   ,
        ],
        "grant-writing" => [
            "heading" => "Are You Prepared to Unlock the Potential of Your Company?",
            "description" => "Our top priority is your success. Allow us to be your dependable partner in obtaining the funding necessary to advance your company.",  
            "description2" => "For a free consultation regarding your grant writing needs, get in touch with us right now at info@ebookghostwriting.com. Hire our grant writers who are eager to support you in reaching your objectives."   
            ],
        "white-paper-writing" => [
            "heading" => "Boost Your Company with Skilled White Paper Writing",
            "description" => "Shuffle in the cutthroat corporate world of today. Working with Ebook Ghostwriting gives you access to a group of professional white paper writers who are committed to producing outstanding work. Our knowledge and dedication to customer pleasure guarantee that your white paper will not only fulfill but also surpass your expectations." ,
            "description2" => "Allow us to assist you in realizing the full potential of your company by utilizing the influence of captivating content. Reach out to us at info@ebookghostwriting.com right now to talk about your white paper project and start along the path to success."
        ],
        "book-formatting" => [
            "heading"=>"Utilize eBook Ghostwriting Services to Unleash the Spark of Your Book",
            "description" => "Selecting us guarantees that your book will receive the red carpet treatment. We are the personal stylists for your book, not merely book formatters. Your remarks will express gratitude for the added glitz! So, why settle with plain formatting when your book may have its entourage? We can turn your book into a local sensation because words have a right to shine. Come celebrate with eBook Ghostwriting Services and start the formatting celebration!",
            "description2"=>""
        ],
        "book-proofreading" => [
            "heading" => "With eBook Ghostwriting Services, Set Out on an Erudite Expedition!",
            "description"=>"When it comes to language, we don’t only make corrections—we elevate, polish, and refine your work until it gleams brilliantly. Selecting eBook Ghostwriting Services is committing to a literary journey in which your writing will go beyond the commonplace and serve as a showcase for your superb narrative. Come along with us, and let us reveal our book proofreaders’ talent to you!",
            "description2"=>""
        ],
        "children-book-editing" => [
            "heading" => "Utilize eBook Ghostwriting Services to Unleash the Spark of Your Children",
            "description"=>"Do words have more meaning than first meets the eye? Explore the extraordinary as we provide children’s book editing quality that turns the stories of your young storyteller into lasting treasures. We go beyond words. We go beyond worlds.",
            "description2"=>""
        ],
        "book-cover-design" => [
            "heading" => "Your Literary Journey Deserves A Visual Companion That Speaks Volumes",
            "description"=>"Our book cover design services incorporate your story’s spirit, accuracy, and inventiveness beyond just pretty pictures. Give your book cover a facelift from our talented book cover artists for hire to make it pop off the shelves and draw in readers. Select eBook Ghostwriting Services to give your story the graphic backing it needs and make it shine brighter than it has ever done!",
            "description2"=>""
        ],
        "book-publishing" => [
            "heading" => "Your Journey To Becoming A Published Author Begins Here!",
            "description"=>"Our staff is committed to turning your story into an engrossing masterpiece so that your literary ambitions can come true. With the help of eBook Ghostwriting Services’ experience, where words become wonders and books become legacies, let your tale come to life.",
            "description2"=>""        
        ],
        "book-marketing-company" => [
            "heading" => "Utilize eBook Ghostwriting Services to Brand Yourself as an Author",
            "description"=>"Generate buzz, increase visibility, and connect directly with your audience through our book marketing services. Our expert marketers become a central hub for your services, where they give their best to make your dream a asuccess. We go beyond words. We go beyond worlds.",
            "description2"=>""
        ],
    ];

    // Get the current URL path
    $currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

    // Clean and normalize the path (trim slashes and convert to lowercase)
    $currentPath = trim($currentPath, '/');
    $currentPath = strtolower($currentPath);

    // Adjust path to check for main page cases
    if ($currentPath === "" || $currentPath === "index") {
        $currentPath = "index";
    }

    // Debugging output to check the path being used
    echo "<!-- Debug: Current Path = $currentPath -->";

    // Function to get the matching content based on the URL path
    function getCompanyContent_CTF($path, $content)
    {
        // If a matching key is found, return the content. Otherwise, return default content.
        return $content[$path] ?? $content["index"];
    }

    // Fetch the appropriate content based on the current URL path
    $currentPath = explode('/', $currentPath);
    $currentPath = $currentPath[count($currentPath) - 1];
    $data = getCompanyContent_CTF($currentPath, $content);
    $heading = $data["heading"];
    $description = $data["description"];
    $description2 = $data["description2"];
?>
<section class="container">
    <div class="contact_form_wrapper">
        <div class="row d-flex justify-content-center mt-4">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6">
                <div class="cta_form_text">
                    <h2><?php echo $heading?></h2>
                    <p><?php echo $description?></p>
                    <p><?php echo $description2?></p>
                </div>
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6">
            <form action="https://designproboards.com/brand/ebookghostwriting/lead" method="GET">
                    <input type="hidden" name="brand_name" value="ebookghostwriting.services">
                    <input type="hidden" id="lead_area" name="lead_area" value="https://ebookghostwriting.services/<?php echo $currentPath?>-bottom-form">
                    <input type="text" name="website" tabindex="-1" autocomplete="off" style="position:absolute;left:-9999px;">
                    <input type="hidden" name="form_start_time" value="<?php echo time() ?>">
                    <input type="hidden" name="city" value="<?php echo $ipwhois['city'] ?>">
                    <input type="hidden" name="country" value="<?php echo $ipwhois['country'] ?>">
                    <input type="hidden" name="ipaddress" value="<?php echo $ipwhois['ip'] ?>">
                    <input type="hidden" name="url" value="<?php echo $actual_link ?>">
                    <input type="hidden" name="clickid" value="<?php echo $clickid[5] ?>">
                    <input type="text" placeholder="Name" name="name" required >
                    <input type="number" placeholder="Number" name="number" required>
                    <input type="email" placeholder="Email Address" name="email" required>
                    <textarea name="message" placeholder="Message"></textarea>
                    <button type="submit">GET IN TOUCH</button>
                </form>
            </div>
        </div>
    </div>
</section>      