<?php include 'includes/links.php';?>

<div class="head-box">
    <div class="main-img">
        <a href="./"><img src="images/logo.png" alt="img" class="w-100"></a>
    </div>
    <div class="menu-box">
        <button class="btn btn-menu" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <i class="fa-regular fa-bars"></i>
        </button>
        <div class="offcanvas offcanvas-end offcanvas-main" tabindex="-1" id="offcanvasRight"
            aria-labelledby="offcanvasRightLabel">
            <div class="offcanvas-body">
                <div class="head">
                    <img src="images/svg19.svg" alt="">
                    <h2>Hi, guest!</h2>
                </div>
                <a href="javascript:;" class="btn sign-btn">Sign Up</a>
                <a href="javascript:;" class="btn sign-btn log-btn">Log In</a>
            </div>
        </div>
    </div>
</div>

<section class="step-main-sec">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-sm-12 col-md-10 col-lg-8 col-xl-8 col-xxl-8">
                <div class="delivery-step">
                    <div class="modal-body">
                        <form id="multi-step-form">
                            <div class="steps-container">
                                <h2>How can we help?</h2>
                                <!-- Store Delivery -->
                                <!-- step1 -->
                                <div class="store-box">
                                    <div class="txt">
                                        <h3>Store Delivery</h3>
                                        <p>Get your purchase home</p>
                                    </div>
                                    <div class="main-img">
                                        <img src="images/svg1.svg" alt="img" class="img-fluid">
                                        <p>from $56</p>
                                    </div>
                                </div>
                                <!-- step1 -->
                                <!-- step2 -->
                                <div class="where">
                                    <h2>Where to?</h2>
                                    <div class="up-location" onclick="openPopup()">
                                        <img src="images/svg7.svg" alt="img" class="img-fluid">
                                        <h5>Pick up location</h5>
                                    </div>
                                    <!-- Popup Modal -->
                                    <div id="popupOverlay" class="popup-overlay">
                                        <div class="popup-box">
                                            <span class="close-btn" onclick="closePopup()">Close</span>
                                            <h3>Pick up location</h3>
                                            <div class="main-input">
                                                <i class="fa-solid fa-magnifying-glass"></i>
                                                <input type="search" name="search" id="" class="input-search"
                                                    placeholder="Enter an address">
                                            </div>
                                            <div class="update-btn">
                                                <button class="update-location">Update Location</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="up-location" onclick="openPopup()">
                                        <img src="images/svg8.svg" alt="img" class="img-fluid">
                                        <h5>Drop off location</h5>
                                    </div>
                                    <div id="drop-popupOverlay" class="popup-overlay">
                                        <div class="popup-box">
                                            <span class="close-btn" onclick="closePopup()">Close</span>
                                            <h3>Drop off location</h3>
                                            <div class="main-input">
                                                <i class="fa-solid fa-magnifying-glass"></i>
                                                <input type="search" name="search" id="" class="input-search"
                                                    placeholder="Enter an address">

                                            </div>
                                            <div class="update-btn">
                                                <button class="update-location">Update Location</button>
                                            </div>
                                        </div>
                                    </div>
                                    <h6>Estimate cost without locations</h6>
                                    <div class="ifream-box">
                                        <iframe
                                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d12635353.70628292!2d-107.89945876006982!3d39.36069416527219!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x54eab584e432360b%3A0x1c3bb99243deb742!2sUnited%20States!5e0!3m2!1sen!2s!4v1752258713001!5m2!1sen!2s"
                                            width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                                    </div>
                                    <div class="main-img">
                                        <img src="images/svg1.svg" alt="img" class="svg-1 img-fluid">
                                    </div>
                                    <h3>How store deliveries work</h3>
                                    <p>There's no need to meet your Helper at the store.</p>
                                    <p class="last-p">Simply tell the store that Dolly will pick up your purchase and
                                        upload your receipt photo when prompted.</p>
                                    <button class="help-btn">Help</button>
                                </div>
                                <!-- step2 -->
                                <!-- step3 -->
                                <div class="tell-us">
                                    <h2>Tell us more</h2>
                                    <div class="jersey">
                                        <h3><img src="images/svg20.svg" alt="img">New Jersey, USA</h3>
                                        <div class="group-input">
                                            <label class="lable">Store name</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="purch">
                                            <h4>Are you the item purchaser <img src="images/svg21.svg" alt="img">
                                            </h4>
                                            <div class="purch-ratio">
                                                <div class="form-check">
                                                    <label class="form-check-label" for="flexRadioDefault1">
                                                        Yes
                                                    </label>
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault"
                                                        id="flexRadioDefault1">
                                                </div>
                                                <div class="form-check">
                                                    <label class="form-check-label" for="flexRadioDefault2">
                                                        No
                                                    </label>
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault"
                                                        id="flexRadioDefault2">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="group-input">
                                            <label class="lable">Purchaser name</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="group-input">
                                            <label class="lable">Purchaser phone number</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="flights">
                                            <h6>Flights of stairs</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <h3 class="mt-5">
                                            <img src="images/svg20.svg" alt="img">New Jersey, USA
                                        </h3>
                                        <div class="group-input">
                                            <label class="lable">Unit/Apt</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="helper">
                                            <div class="form-check">
                                                <label class="form-check-label" for="option1">
                                                    Helper(s) needs to use stairs <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option1">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option2">
                                                    Helper can use elevator
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option2">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Has hardwood floors <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                        </div>
                                        <div class="flights">
                                            <h6>Flights of stairs</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="textare">
                                            <div class="parking">
                                                <h3>Parking or building instructions</h3>
                                                <h6>clear</h6>
                                            </div>
                                            <textarea name="message" rows="5"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="add-an">
                                    <h2>Add an item</h2>
                                    <div class="main-input">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                        <input type="search" name="search" id="" class="input-search"
                                            placeholder="Search items">
                                    </div>
                                    <h4>Item size guide</h4>
                                    <h3>Popular items</h3>
                                    <div class="items-box">
                                        <div class="box" onclick="nextStep()">
                                            <h5>Chair</h5>
                                            <img src="images/svg9.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Box</h5>
                                            <img src="images/svg10.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Mattress</h5>
                                            <img src="images/svg11.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Couch</h5>
                                            <img src="images/svg12.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Dining Table</h5>
                                            <img src="images/svg13.svg" alt="img">
                                        </div>
                                    </div>
                                </div>
                                <!-- step3 -->
                                <!-- step4 -->
                                <div class="add-an-items">
                                    <h2>Add an item</h2>
                                    <div class="main-input">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                        <input type="search" name="search" id="" class="input-search"
                                            placeholder="Search items">
                                    </div>
                                    <h4>Item size guide</h4>
                                    <div class="row">
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault1">
                                                    Dining
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault1">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault2">
                                                    Office
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault2">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault3">
                                                    Folding
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault3">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault4">
                                                    Arm
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault4">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="line"></div>
                                    <div id="howmany" style="display:none">
                                        <div class="how-many">
                                            <h6>How many?</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="smoothly">
                                            <p>Please upload a photo of your receipt or proof of purchase to help
                                                your Dolly
                                                go
                                                smoothly.</p>
                                        </div>
                                        <div class="message">
                                            <label for="" class="notes">Important notes</label>
                                            <textarea name="message" id="" rows="3"
                                                placeholder="Example: 2’ x 3' x 5’ and bulky; needs two people to carry"></textarea>
                                        </div>
                                        <div class="file-upload-box">
                                            <input type="file" id="fileInput" class="file-input">
                                            <label for="fileInput" class="file-label">
                                                <img src="images/svg14.svg" alt="upload icon">
                                                <p>Add</p>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <!-- step4 -->
                                <!-- step5 -->
                                <div class="we-moving">
                                    <h2>What are we moving?</h2>
                                    <div class="total">
                                        <p>1 item total</p>
                                        <div class="item-box">
                                            <div class="txt">
                                                <h5>1</h5>
                                                <h4>Chair <span>Dining</span></h4>
                                            </div>
                                            <i class="fa-solid fa-ellipsis"></i>
                                        </div>
                                    </div>
                                    <div class="btn-item">
                                        <button class="item">
                                            + Add items
                                        </button>
                                    </div>
                                </div>
                                <!-- step5 -->
                                <!-- step6 -->
                                <div class="helpers">
                                    <h2>How many Helpers?</h2>
                                    <div class="box">
                                        <h3>2 Helpers</h3>
                                        <ul>
                                            <li>
                                                <p>Two Helpers with a pickup truck will arrive to get your Dolly
                                                    done quick
                                                    and easy.</p>
                                            </li>
                                            <li>
                                                <img src="images/img1.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$$</p>
                                    </div>
                                    <div class="box">
                                        <h3>1 Helper + You</h3>
                                        <ul>
                                            <li>
                                                <p>If your Dolly needs 2 people to lift and carry, you can save
                                                    money by
                                                    helping!</p>
                                            </li>
                                            <li>
                                                <img src="images/img2.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$</p>
                                    </div>
                                    <div class="box">
                                        <h3>1 Helper</h3>
                                        <ul>
                                            <li>
                                                <p>One Helper is perfect for boxes, bags, or items that can be
                                                    carried with
                                                    2 hands.</p>
                                            </li>
                                            <li>
                                                <img src="images/img3.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$</p>
                                    </div>
                                </div>
                                <div class="helpers vehicle">
                                    <h2>Which vehicle?</h2>
                                    <div class="box pickup">
                                        <h3>Pickup Truck</h3>
                                        <ul>
                                            <li>
                                                <p>Great for a couple large items, or multiple small items.</p>
                                            </li>
                                            <li>
                                                <img src="images/img4.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="box pickup">
                                        <h3>Cargo Van</h3>
                                        <ul>
                                            <li>
                                                <p>Upgrade to a covered vehicle for a low price! Speed up your
                                                    move
                                                    with
                                                    fewer trips.</p>
                                            </li>
                                            <li>
                                                <img src="images/img5.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="box pickup">
                                        <h3>Box Truck</h3>
                                        <ul>
                                            <li>
                                                <p>Upgrade to a covered vehicle and get everything moved in one
                                                    trip!</p>
                                            </li>
                                            <li>
                                                <img src="images/img6.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- step6 -->
                                <!-- step7 -->
                                <div class="what-time">
                                    <h2>What time?</h2>
                                    <h4>Helpers should arrive at the store between</h4>
                                    <div class="select">
                                        <select class="form-select" aria-label="Default select example">
                                            <option selected>Select time</option>
                                            <option value="1">8:00AM</option>
                                            <option value="2">8:30AM</option>
                                            <option value="3">9:00AM</option>
                                            <option value="3">9:30AM</option>
                                            <option value="3">10:00AM</option>
                                            <option value="3">10:30AM</option>
                                            <option value="3">11:00AM</option>
                                            <option value="3">11:30AM</option>
                                        </select>
                                    </div>
                                    <div class="btn-helpe">
                                        <button class="help-btn">Help</button>
                                    </div>
                                </div>
                                <!-- step7 -->
                                <!-- step8 -->
                                <div class="review">
                                    <h2>Review your details</h2>
                                    <p>Does everything look right? You’ll enter a payment method before
                                        scheduling.
                                    </p>
                                    <div class="store">
                                        <h6>Store Delivery</h6>
                                        <img src="images/img7.jpg" alt="img">
                                    </div>
                                    <div class="included">
                                        <h2>Always included</h2>
                                        <ul>
                                            <li><img src="images/svg15.svg" alt="img"> Upfront, guaranteed
                                                pricing
                                            </li>
                                            <li><img src="images/svg16.svg" alt="img"> Customer support 7 days a
                                                week</li>
                                            <li><img src="images/svg17.svg" alt="img"> Complimentary damage
                                                protection</li>
                                        </ul>
                                    </div>
                                    <div class="included">
                                        <h2>Where we're going</h2>
                                        <h6>Delivery Location <img src="images/svg18.svg" alt="img"></h6>
                                        <ul class="nav nav-pills mb-3 room-ul" id="pills-tab" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active choice-btn" id="pills-home-tab"
                                                    data-bs-toggle="pill" data-bs-target="#pills-home" type="button"
                                                    role="tab" aria-controls="pills-home" aria-selected="true">Room of
                                                    Choice <span>$$</span></button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link choice-btn" id="pills-profile-tab"
                                                    data-bs-toggle="pill" data-bs-target="#pills-profile" type="button"
                                                    role="tab" aria-controls="pills-profile"
                                                    aria-selected="false">Curbside <span>$</span>
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="tab-content" id="pills-tabContent">
                                        <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                                            aria-labelledby="pills-home-tab">
                                            <div class="included">
                                                <h2>When we'll arrive</h2>
                                                <ul>
                                                    <li>Thursday, 8/7</li>
                                                    <li>2:00pm-6:00pm</li>
                                                </ul>
                                            </div>
                                            <div class="included">
                                                <h2>Your crew</h2>
                                                <ul>
                                                    <li>1 Helper + You</li>
                                                    <li>1 Cargo Van</li>
                                                </ul>
                                            </div>
                                            <div class="included">
                                                <h2>What we're moving</h2>
                                                <ul>
                                                    <li>1 Chair(Dining)</li>
                                                </ul>
                                            </div>
                                            <div class="guaranteed">
                                                <h2>Guaranteed Price</h2>
                                                <div class="total">
                                                    <h6>Subtotal</h6>
                                                    <h6>$152</h6>
                                                </div>
                                                <div class="Taxes">
                                                    <h6>Taxes</h6>
                                                    <h6>included</h6>
                                                </div>
                                                <ul>
                                                    <li>Total</li>
                                                    <li>$152</li>
                                                </ul>
                                                <h4>Add discount</h4>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                            aria-labelledby="pills-profile-tab">
                                            <div class="included">
                                                <h2>When we'll arrive</h2>
                                                <ul>
                                                    <li>Thursday, 8/7</li>
                                                    <li>2:00pm-6:00pm</li>
                                                </ul>
                                            </div>
                                            <div class="included">
                                                <h2>Your crew</h2>
                                                <ul>
                                                    <li>1 Helper + You</li>
                                                    <li>1 Cargo Van</li>
                                                </ul>
                                            </div>
                                            <div class="included">
                                                <h2>What we're moving</h2>
                                                <ul>
                                                    <li>1 Chair(Dining)</li>
                                                </ul>
                                            </div>
                                            <div class="guaranteed">
                                                <h2>Guaranteed Price</h2>
                                                <div class="total">
                                                    <h6>Subtotal</h6>
                                                    <h6>$152</h6>
                                                </div>
                                                <div class="total">
                                                    <h6>Service Fee</h6>
                                                    <h6>$4</h6>
                                                </div>
                                                <div class="Taxes">
                                                    <h6>Taxes</h6>
                                                    <h6>included</h6>
                                                </div>
                                                <ul>
                                                    <li>Total</li>
                                                    <li>$152</li>
                                                </ul>
                                                <h4>Add discount</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- step8 -->
                                <!-- Store Delivery -->

                                <!-- Move a Few Items -->
                                <!-- step1 -->
                                <div class="store-box">
                                    <div class="txt">
                                        <h3>Move a Few Items</h3>
                                        <p>Low rates, zero back pain</p>
                                    </div>
                                    <div class="main-img">
                                        <img src="images/svg2.svg" alt="img" class="img-fluid">
                                        <p>from $67</p>
                                    </div>
                                </div>
                                <!-- step1 -->
                                <!-- step2 -->
                                <div class="where">
                                    <h2>Where to?</h2>
                                    <div class="up-location" onclick="openPopup()">
                                        <img src="images/svg7.svg" alt="img" class="img-fluid">
                                        <h5>Pick up location</h5>
                                    </div>
                                    <!-- Popup Modal -->
                                    <div id="popupOverlay" class="popup-overlay">
                                        <div class="popup-box">
                                            <span class="close-btn" onclick="closePopup()">Close</span>
                                            <h3>Pick up location</h3>
                                            <div class="main-input">
                                                <i class="fa-solid fa-magnifying-glass"></i>
                                                <input type="search" name="search" id="" class="input-search"
                                                    placeholder="Enter an address">
                                            </div>
                                            <div class="update-btn">
                                                <button class="update-location">Update Location</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="up-location" onclick="openPopup()">
                                        <img src="images/svg8.svg" alt="img" class="img-fluid">
                                        <h5>Drop off location</h5>
                                    </div>
                                    <div id="drop-popupOverlay" class="popup-overlay">
                                        <div class="popup-box">
                                            <span class="close-btn" onclick="closePopup()">Close</span>
                                            <h3>Drop off location</h3>
                                            <div class="main-input">
                                                <i class="fa-solid fa-magnifying-glass"></i>
                                                <input type="search" name="search" id="" class="input-search"
                                                    placeholder="Enter an address">
                                            </div>
                                            <div class="update-btn">
                                                <button class="update-location">Update Location</button>
                                            </div>
                                        </div>
                                    </div>
                                    <h6>Estimate cost without locations</h6>
                                    <div class="ifream-box">
                                        <iframe
                                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d12635353.70628292!2d-107.89945876006982!3d39.36069416527219!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x54eab584e432360b%3A0x1c3bb99243deb742!2sUnited%20States!5e0!3m2!1sen!2s!4v1752258713001!5m2!1sen!2s"
                                            width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                                    </div>
                                    <button class="help-btn">Help</button>
                                </div>
                                <!-- step2 -->
                                <!-- step3 -->
                                <div class="tell-us">
                                    <h2>Tell us more</h2>
                                    <div class="jersey">
                                        <h3 class="mt-5">
                                            <img src="images/svg20.svg" alt="img">New Jersey, USA
                                        </h3>
                                        <div class="group-input">
                                            <label class="lable">Unit/Apt</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="helper">
                                            <div class="form-check">
                                                <label class="form-check-label" for="option1">
                                                    Helper(s) needs to use stairs <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option1">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option2">
                                                    Helper can use elevator
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option2">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Has hardwood floors <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                        </div>
                                        <div class="flights">
                                            <h6>Flights of stairs</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="textare">
                                            <div class="parking">
                                                <h3>Parking or building instructions</h3>
                                                <h6>clear</h6>
                                            </div>
                                            <textarea name="message" rows="5"></textarea>
                                        </div>
                                        <h3 class="mt-5">
                                            <img src="images/svg20.svg" alt="img">New Jersey, USA
                                        </h3>
                                        <div class="group-input">
                                            <label class="lable">Unit/Apt</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="helper">
                                            <div class="form-check">
                                                <label class="form-check-label" for="option1">
                                                    Helper(s) needs to use stairs <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option1">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option2">
                                                    Helper can use elevator
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option2">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Has hardwood floors <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                        </div>
                                        <div class="flights">
                                            <h6>Flights of stairs</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="textare">
                                            <div class="parking">
                                                <h3>Parking or building instructions</h3>
                                                <h6>clear</h6>
                                            </div>
                                            <textarea name="message" rows="5"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="add-an">
                                    <h2>Add an item</h2>
                                    <div class="main-input">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                        <input type="search" name="search" id="" class="input-search"
                                            placeholder="Search items">
                                    </div>
                                    <h4>Item size guide</h4>
                                    <h3>Popular items</h3>
                                    <div class="items-box">
                                        <div class="box" onclick="nextStep()">
                                            <h5>Bed</h5>
                                            <img src="images/svg9.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Couch</h5>
                                            <img src="images/svg10.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>TV</h5>
                                            <img src="images/svg11.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Chair</h5>
                                            <img src="images/svg12.svg" alt="img">
                                        </div>
                                    </div>
                                </div>
                                <!-- step3 -->
                                <!-- step4 -->
                                <div class="add-an-items">
                                    <h2>Add an item</h2>
                                    <div class="main-input">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                        <input type="search" name="search" id="" class="input-search"
                                            placeholder="Search items">
                                    </div>
                                    <h4>Item size guide</h4>
                                    <div class="row">
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault1">
                                                    Dining
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault1">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault2">
                                                    Office
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault2">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault3">
                                                    Folding
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault3">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault4">
                                                    Arm
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault4">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="line"></div>
                                    <div class="howmany">
                                        <div class="how-many">
                                            <h6>How many?</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="sleeper">
                                            <div class="form-check">
                                                <label class="form-check-label" for="option1">
                                                    Is a sleeper sofa <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option1">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option2">
                                                    Is a sectional <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option2">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Has power recliner <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Ottoman <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                        </div>
                                        <div class="smoothly required">
                                            <p>This item needs to be broken down and reassembled after moving. If there
                                                are any special tools required, please let us know in the notes section.
                                            </p>
                                        </div>
                                        <div class="message">
                                            <label for="" class="notes">Important notes</label>
                                            <textarea name="message" id="" rows="3"
                                                placeholder="Example: 2’ x 3' x 5’ and bulky; needs two people to carry">
                                            </textarea>
                                        </div>
                                        <div class="file-upload-box">
                                            <input type="file" id="fileInput" class="file-input">
                                            <label for="fileInput" class="file-label">
                                                <img src="images/svg14.svg" alt="upload icon">
                                                <p>Add</p>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <!-- step4 -->
                                <!-- step5 -->
                                <div class="we-moving">
                                    <h2>What are we moving?</h2>
                                    <div class="total">
                                        <p>1 item total</p>
                                        <div class="item-box">
                                            <div class="txt">
                                                <h5>1</h5>
                                                <h4>Chair <span>Dining</span></h4>
                                            </div>
                                            <i class="fa-solid fa-ellipsis"></i>
                                        </div>
                                    </div>
                                    <div class="btn-item">
                                        <button class="item">
                                            + Add items
                                        </button>
                                    </div>
                                </div>
                                <!-- step5 -->
                                <!-- step6 -->
                                <div class="helpers">
                                    <h2>How many Helpers?</h2>
                                    <div class="box">
                                        <h3>2 Helpers</h3>
                                        <ul>
                                            <li>
                                                <p>Two Helpers with a pickup truck will arrive to get your Dolly
                                                    done quick
                                                    and easy.</p>
                                            </li>
                                            <li>
                                                <img src="images/img1.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$$</p>
                                    </div>
                                    <div class="box">
                                        <h3>1 Helper + You</h3>
                                        <ul>
                                            <li>
                                                <p>If your Dolly needs 2 people to lift and carry, you can save
                                                    money by
                                                    helping!</p>
                                            </li>
                                            <li>
                                                <img src="images/img2.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$</p>
                                    </div>
                                    <div class="box">
                                        <h3>1 Helper</h3>
                                        <ul>
                                            <li>
                                                <p>One Helper is perfect for boxes, bags, or items that can be
                                                    carried with
                                                    2 hands.</p>
                                            </li>
                                            <li>
                                                <img src="images/img3.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$</p>
                                    </div>
                                </div>
                                <div class="helpers vehicle">
                                    <h2>Which vehicle?</h2>
                                    <div class="box pickup">
                                        <h3>Pickup Truck</h3>
                                        <ul>
                                            <li>
                                                <p>Great for a couple large items, or multiple small items.</p>
                                            </li>
                                            <li>
                                                <img src="images/img4.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="box pickup">
                                        <h3>Cargo Van</h3>
                                        <ul>
                                            <li>
                                                <p>Upgrade to a covered vehicle for a low price! Speed up your
                                                    move
                                                    with
                                                    fewer trips.</p>
                                            </li>
                                            <li>
                                                <img src="images/img5.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="box pickup">
                                        <h3>Box Truck</h3>
                                        <ul>
                                            <li>
                                                <p>Upgrade to a covered vehicle and get everything moved in one
                                                    trip!</p>
                                            </li>
                                            <li>
                                                <img src="images/img6.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- step6 -->
                                <!-- step7 -->
                                <div class="what-time">
                                    <h2>What time?</h2>
                                    <p>Please ensure the store will be open when Helpers arrive.</p>
                                    <h4>Helpers should arrive at the store between</h4>
                                    <div class="select">
                                        <select class="form-select" aria-label="Default select example">
                                            <option selected>Select time</option>
                                            <option value="1">8:00AM</option>
                                            <option value="2">8:30AM</option>
                                            <option value="3">9:00AM</option>
                                            <option value="3">9:30AM</option>
                                            <option value="3">10:00AM</option>
                                            <option value="3">10:30AM</option>
                                            <option value="3">11:00AM</option>
                                            <option value="3">11:30AM</option>
                                        </select>
                                        <p>and</p>
                                        <select class="form-select" aria-label="Default select example">
                                            <option selected>Select time</option>
                                            <option value="1">8:00AM</option>
                                            <option value="2">8:30AM</option>
                                            <option value="3">9:00AM</option>
                                            <option value="3">9:30AM</option>
                                            <option value="3">10:00AM</option>
                                            <option value="3">10:30AM</option>
                                            <option value="3">11:00AM</option>
                                            <option value="3">11:30AM</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- step7 -->
                                <!-- step8 -->
                                <div class="review">
                                    <h2>Review your details</h2>
                                    <p>Does everything look right? You’ll enter a payment method before
                                        scheduling.
                                    </p>
                                    <div class="store">
                                        <h6>Store Delivery</h6>
                                        <img src="images/img7.jpg" alt="img">
                                    </div>
                                    <div class="included">
                                        <h2>Always included</h2>
                                        <ul>
                                            <li><img src="images/svg15.svg" alt="img"> Upfront, guaranteed
                                                pricing
                                            </li>
                                            <li><img src="images/svg16.svg" alt="img"> Customer support 7 days a
                                                week</li>
                                            <li><img src="images/svg17.svg" alt="img"> Complimentary damage
                                                protection</li>
                                        </ul>
                                    </div>
                                    <div class="included">
                                        <h2>Where we're going</h2>
                                        <!-- <h6>Delivery Location <img src="images/svg18.svg" alt="img"></h6> -->
                                    </div>
                                    <div class="included">
                                        <h2>When we'll arrive</h2>
                                        <ul>
                                            <li>Thursday, 8/7</li>
                                            <li>2:00pm-6:00pm</li>
                                        </ul>
                                        <p><i>We'll schedule you for a 30-minute arrival time prior to your
                                                Dolly
                                                starting.</i></p>
                                    </div>
                                    <div class="included">
                                        <h2>Your crew</h2>
                                        <ul>
                                            <li>1 Helper + You</li>
                                            <li>1 Cargo Van</li>
                                        </ul>
                                    </div>
                                    <div class="included">
                                        <h2>What we're moving</h2>
                                        <ul>
                                            <li>1 Chair(Dining)</li>
                                        </ul>
                                    </div>
                                    <div class="guaranteed">
                                        <h2>Guaranteed Price</h2>
                                        <div class="total">
                                            <h6>Subtotal</h6>
                                            <h6>$152</h6>
                                        </div>
                                        <div class="total">
                                            <h6>Service Fee</h6>
                                            <h6>$4</h6>
                                        </div>
                                        <div class="Taxes">
                                            <h6>Taxes</h6>
                                            <h6>included</h6>
                                        </div>
                                        <ul>
                                            <li>Total</li>
                                            <li>$152</li>
                                        </ul>
                                        <h4>Add discount</h4>
                                    </div>
                                </div>
                                <!-- step8 -->
                                <!-- Move a Few Items -->

                                <!-- Facebook Marketplace -->
                                <!-- step1 -->
                                <div class="store-box">
                                    <div class="txt">
                                        <h3>Facebook Marketplace</h3>
                                        <p>Get items you buy and sell on Facebook <br>Marketplace delivered</p>
                                    </div>
                                    <div class="main-img">
                                        <img src="images/svg3.svg" alt="img" class="img-fluid">
                                        <p>from $63</p>
                                    </div>
                                </div>
                                <!-- step1 -->
                                <!-- step2 -->
                                <div class="where">
                                    <img src="images/svg22.svg" alt="">
                                    <h3>Get your purchase delivered with Dolly</h3>
                                    <p>Enter your address and items to get a guaranteed price fast. You'll shortly be
                                        introduced to your Helper. All Helpers are background checked and insured.</p>
                                    <div class="up-location" onclick="openPopup()">
                                        <img src="images/svg7.svg" alt="img" class="img-fluid">
                                        <h5>Pick up location</h5>
                                    </div>
                                    <!-- Popup Modal -->
                                    <div id="popupOverlay" class="popup-overlay">
                                        <div class="popup-box">
                                            <span class="close-btn" onclick="closePopup()">Close</span>
                                            <h3>Pick up location</h3>
                                            <div class="main-input">
                                                <i class="fa-solid fa-magnifying-glass"></i>
                                                <input type="search" name="search" id="" class="input-search"
                                                    placeholder="Enter an address">
                                            </div>
                                            <div class="update-btn">
                                                <button class="update-location">Update Location</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="up-location" onclick="openPopup()">
                                        <img src="images/svg8.svg" alt="img" class="img-fluid">
                                        <h5>Drop off location</h5>
                                    </div>
                                    <div id="drop-popupOverlay" class="popup-overlay">
                                        <div class="popup-box">
                                            <span class="close-btn" onclick="closePopup()">Close</span>
                                            <h3>Drop off location</h3>
                                            <div class="main-input">
                                                <i class="fa-solid fa-magnifying-glass"></i>
                                                <input type="search" name="search" id="" class="input-search"
                                                    placeholder="Enter an address">
                                            </div>
                                            <div class="update-btn">
                                                <button class="update-location">Update Location</button>
                                            </div>
                                        </div>
                                    </div>
                                    <h6>Estimate cost without locations</h6>
                                    <div class="ifream-box">
                                        <iframe
                                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d12635353.70628292!2d-107.89945876006982!3d39.36069416527219!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x54eab584e432360b%3A0x1c3bb99243deb742!2sUnited%20States!5e0!3m2!1sen!2s!4v1752258713001!5m2!1sen!2s"
                                            width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                                    </div>
                                    <button class="help-btn">Help</button>
                                </div>
                                <!-- step2 -->
                                <!-- step3 -->
                                <div class="tell-us">
                                    <h2>Tell us more</h2>
                                    <div class="jersey">
                                        <h3 class="mt-5">
                                            <img src="images/svg20.svg" alt="img">New Jersey, USA
                                        </h3>
                                        <div class="group-input">
                                            <label class="lable">Unit/Apt</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="helper">
                                            <div class="form-check">
                                                <label class="form-check-label" for="option1">
                                                    Helper(s) needs to use stairs <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option1">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option2">
                                                    Helper can use elevator
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option2">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Has hardwood floors <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                        </div>
                                        <div class="flights">
                                            <h6>Flights of stairs</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="textare">
                                            <div class="parking">
                                                <h3>Parking or building instructions</h3>
                                                <h6>clear</h6>
                                            </div>
                                            <textarea name="message" rows="5"></textarea>
                                        </div>
                                        <h3 class="mt-5">
                                            <img src="images/svg20.svg" alt="img">New Jersey, USA
                                        </h3>
                                        <div class="group-input">
                                            <label class="lable">Unit/Apt</label>
                                            <input type="search" name="" placeholder="Add">
                                        </div>
                                        <div class="helper">
                                            <div class="form-check">
                                                <label class="form-check-label" for="option1">
                                                    Helper(s) needs to use stairs <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option1">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option2">
                                                    Helper can use elevator
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option2">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Has hardwood floors <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                        </div>
                                        <div class="flights">
                                            <h6>Flights of stairs</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="textare">
                                            <div class="parking">
                                                <h3>Parking or building instructions</h3>
                                                <h6>clear</h6>
                                            </div>
                                            <textarea name="message" rows="5"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="add-an">
                                    <h2>Add an item</h2>
                                    <div class="main-input">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                        <input type="search" name="search" id="" class="input-search"
                                            placeholder="Search items">
                                    </div>
                                    <h4>Item size guide</h4>
                                    <h3>Popular items</h3>
                                    <div class="items-box">
                                        <div class="box" onclick="nextStep()">
                                            <h5>Bed</h5>
                                            <img src="images/svg9.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Couch</h5>
                                            <img src="images/svg10.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>TV</h5>
                                            <img src="images/svg11.svg" alt="img">
                                        </div>
                                        <div class="box" onclick="nextStep()">
                                            <h5>Chair</h5>
                                            <img src="images/svg12.svg" alt="img">
                                        </div>
                                    </div>
                                </div>
                                <!-- step3 -->
                                <!-- step4 -->
                                <div class="add-an-items">
                                    <h2>Add an item</h2>
                                    <div class="main-input">
                                        <i class="fa-solid fa-magnifying-glass"></i>
                                        <input type="search" name="search" id="" class="input-search"
                                            placeholder="Search items">
                                    </div>
                                    <h4>Item size guide</h4>
                                    <div class="row">
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault1">
                                                    2 seater
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault1">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault2">
                                                    3 seater
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault2">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault3">
                                                    4 seater
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault3">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault4">
                                                    5 seater
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault4">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault4">
                                                    6 seater
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault4">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault4">
                                                    7 seater
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault4">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <div class="form-check">
                                                <label class="form-check-label" for="flexRadioDefault4">
                                                    8 seater
                                                </label>
                                                <input class="form-check-input howmany" type="radio"
                                                    name="flexRadioDefault" id="flexRadioDefault4">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="line"></div>
                                    <div class="howmany">
                                        <div class="how-many">
                                            <h6>How many?</h6>
                                            <div class="frame">
                                                <div class="cir-btn">
                                                    <div class="minus-btn">-</div>
                                                </div>
                                                <div class="number">
                                                    <h1 class="count">0</h1>
                                                </div>
                                                <div class="cir-btn">
                                                    <div class="plus-btn">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="sleeper">
                                            <div class="form-check">
                                                <label class="form-check-label" for="option1">
                                                    Is a sleeper sofa <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option1">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option2">
                                                    Is a sectional <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option2">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Has power recliner <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                            <div class="form-check">
                                                <label class="form-check-label" for="option3">
                                                    Ottoman <img src="images/svg21.svg" alt="img">
                                                </label>
                                                <input class="form-check-input" type="checkbox" id="option3">
                                            </div>
                                        </div>
                                        <div class="smoothly required">
                                            <p>This item needs to be broken down and reassembled after moving.
                                                 If there
                                                are any special tools required, please let us know in the notes section.
                                            </p>
                                        </div>
                                        <div class="message">
                                            <label for="" class="notes">Important notes</label>
                                            <textarea name="message" id="" rows="3"
                                                placeholder="Example: 2’ x 3' x 5’ and bulky; needs two people to carry">
                                            </textarea>
                                        </div>
                                        <div class="file-upload-box">
                                            <input type="file" id="fileInput" class="file-input">
                                            <label for="fileInput" class="file-label">
                                                <img src="images/svg14.svg" alt="upload icon">
                                                <p>Add</p>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <!-- step4 -->
                                <!-- step5 -->
                                <div class="we-moving">
                                    <h2>What are we moving?</h2>
                                    <div class="total">
                                        <p>1 item total</p>
                                        <div class="item-box">
                                            <div class="txt">
                                                <h5>1</h5>
                                                <h4>Chair <span>Dining</span></h4>
                                            </div>
                                            <i class="fa-solid fa-ellipsis"></i>
                                        </div>
                                    </div>
                                    <div class="btn-item">
                                        <button class="item">
                                            + Add items
                                        </button>
                                    </div>
                                </div>
                                <!-- step5 -->
                                <!-- step6 -->
                                <div class="helpers">
                                    <h2>How many Helpers?</h2>
                                    <div class="box">
                                        <h3>2 Helpers</h3>
                                        <ul>
                                            <li>
                                                <p>Two Helpers with a pickup truck will arrive to get your Dolly
                                                    done quick
                                                    and easy.</p>
                                            </li>
                                            <li>
                                                <img src="images/img1.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$$</p>
                                    </div>
                                    <div class="box">
                                        <h3>1 Helper + You</h3>
                                        <ul>
                                            <li>
                                                <p>If your Dolly needs 2 people to lift and carry, you can save
                                                    money by
                                                    helping!</p>
                                            </li>
                                            <li>
                                                <img src="images/img2.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$</p>
                                    </div>
                                    <div class="box">
                                        <h3>1 Helper</h3>
                                        <ul>
                                            <li>
                                                <p>One Helper is perfect for boxes, bags, or items that can be
                                                    carried with
                                                    2 hands.</p>
                                            </li>
                                            <li>
                                                <img src="images/img3.png" alt="">
                                            </li>
                                        </ul>
                                        <p>$</p>
                                    </div>
                                </div>
                                <div class="helpers vehicle">
                                    <h2>Which vehicle?</h2>
                                    <div class="box pickup">
                                        <h3>Pickup Truck</h3>
                                        <ul>
                                            <li>
                                                <p>Great for a couple large items, or multiple small items.</p>
                                            </li>
                                            <li>
                                                <img src="images/img4.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="box pickup">
                                        <h3>Cargo Van</h3>
                                        <ul>
                                            <li>
                                                <p>Upgrade to a covered vehicle for a low price! Speed up your
                                                    move
                                                    with
                                                    fewer trips.</p>
                                            </li>
                                            <li>
                                                <img src="images/img5.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="box pickup">
                                        <h3>Box Truck</h3>
                                        <ul>
                                            <li>
                                                <p>Upgrade to a covered vehicle and get everything moved in one
                                                    trip!</p>
                                            </li>
                                            <li>
                                                <img src="images/img6.png" alt="">
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- step6 -->
                                <!-- step7 -->
                                <div class="what-time">
                                    <h2>What time?</h2>
                                    <p>Please ensure the store will be open when Helpers arrive.</p>
                                    <h4>Helpers should arrive at the store between</h4>
                                    <div class="select">
                                        <select class="form-select" aria-label="Default select example">
                                            <option selected>Select time</option>
                                            <option value="1">8:00AM</option>
                                            <option value="2">8:30AM</option>
                                            <option value="3">9:00AM</option>
                                            <option value="3">9:30AM</option>
                                            <option value="3">10:00AM</option>
                                            <option value="3">10:30AM</option>
                                            <option value="3">11:00AM</option>
                                            <option value="3">11:30AM</option>
                                        </select>
                                        <p>and</p>
                                        <select class="form-select" aria-label="Default select example">
                                            <option selected>Select time</option>
                                            <option value="1">8:00AM</option>
                                            <option value="2">8:30AM</option>
                                            <option value="3">9:00AM</option>
                                            <option value="3">9:30AM</option>
                                            <option value="3">10:00AM</option>
                                            <option value="3">10:30AM</option>
                                            <option value="3">11:00AM</option>
                                            <option value="3">11:30AM</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- step7 -->
                                <!-- step8 -->
                                <div class="review">
                                    <h2>Review your details</h2>
                                    <p>Does everything look right? You’ll enter a payment method before
                                        scheduling.
                                    </p>
                                    <div class="store">
                                        <h6>Store Delivery</h6>
                                        <img src="images/img7.jpg" alt="img">
                                    </div>
                                    <div class="included">
                                        <h2>Always included</h2>
                                        <ul>
                                            <li><img src="images/svg15.svg" alt="img"> Upfront, guaranteed
                                                pricing
                                            </li>
                                            <li><img src="images/svg16.svg" alt="img"> Customer support 7 days a
                                                week</li>
                                            <li><img src="images/svg17.svg" alt="img"> Complimentary damage
                                                protection</li>
                                        </ul>
                                    </div>
                                    <div class="included">
                                        <h2>Where we're going</h2>
                                    </div>
                                    <div class="included">
                                        <h2>When we'll arrive</h2>
                                        <ul>
                                            <li>Thursday, 8/7</li>
                                            <li>2:00pm-6:00pm</li>
                                        </ul>
                                        <p><i>We'll schedule you for a 30-minute arrival time prior to your
                                                Dolly
                                                starting.</i></p>
                                    </div>
                                    <div class="included">
                                        <h2>Your crew</h2>
                                        <ul>
                                            <li>1 Helper + You</li>
                                            <li>1 Cargo Van</li>
                                        </ul>
                                    </div>
                                    <div class="included">
                                        <h2>What we're moving</h2>
                                        <ul>
                                            <li>1 Chair(Dining)</li>
                                        </ul>
                                    </div>
                                    <div class="guaranteed">
                                        <h2>Guaranteed Price</h2>
                                        <div class="total">
                                            <h6>Subtotal</h6>
                                            <h6>$152</h6>
                                        </div>
                                        <div class="Taxes">
                                            <h6>Taxes</h6>
                                            <h6>included</h6>
                                        </div>
                                        <ul>
                                            <li>Total</li>
                                            <li>$152</li>
                                        </ul>
                                        <h4>Add discount</h4>
                                        <div class="additional">
                                            <p>Additional Services</p>
                                            <div class="box">
                                                <div class="txt">
                                                    <img src="images/svg23.svg" alt="">
                                                    <h2>Extra Damage Protection <span>Adding extra coverage is
                                                            easy</span></h2>
                                                </div>
                                                <i class="fa-solid fa-angle-right"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- step8 -->
                                <!-- Facebook Marketplace -->
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="step-btn-fixed step-btn">
    <button type="button" class="next btn step-next" onclick="prevStep()">Back</button>
    <button type="button" class="next btn step-next" id="nextBtn" onclick="nextStep()">Next</button>
</div>
<?php include 'includes/script.php';?>