<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.22
 */

// If this theme is a free version of premium theme
if ( ! defined( 'TEDISS_THEME_FREE' ) ) {
	define( 'TEDISS_THEME_FREE', false );
}
if ( ! defined( 'TEDISS_THEME_FREE_WP' ) ) {
	define( 'TEDISS_THEME_FREE_WP', false );
}

// If this theme uses multiple skins
if ( ! defined( 'TEDISS_ALLOW_SKINS' ) ) {
	define( 'TEDISS_ALLOW_SKINS', false );
}
if ( ! defined( 'TEDISS_DEFAULT_SKIN' ) ) {
	define( 'TEDISS_DEFAULT_SKIN', 'default' );
}

// Theme storage
// Attention! Must be in the global namespace to compatibility with WP CLI
$GLOBALS['TEDISS_STORAGE'] = array(

	// Theme required plugin's slugs
	'required_plugins'   => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'         => esc_html__( 'ThemeREX Addons', 'tediss' ),
			

			// If theme use OCDI instead (or both) ThemeREX Addons Installer
			

			// Recommended (supported) plugins for both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'elementor'              => esc_html__( 'Elementor', 'tediss' ),
			'contact-form-7'         => esc_html__( 'Contact Form 7', 'tediss' ),
			// GDPR Support: uncomment only one of two following plugins
			'date-time-picker-field' => esc_html__( 'Date Time Picker Field', 'tediss' ),
		),
		// List of plugins for the FREE version only
		//-----------------------------------------------------
		TEDISS_THEME_FREE
			? array(
				// Recommended (supported) plugins for the FREE (lite) version
				'siteorigin-panels' => esc_html__( 'SiteOrigin Panels', 'tediss' ),
			)

		// List of plugins for the PREMIUM version only
		//-----------------------------------------------------
			: array(
				// Recommended (supported) plugins for the PRO (full) version
				// If plugin not need - comment (or remove) it
				'quickcal'                     => esc_html__( 'QuickCal', 'tediss' ),
				'essential-grid'             => esc_html__( 'Essential Grid', 'tediss' ),
				'the-events-calendar'        => esc_html__( 'The Events Calendar', 'tediss' ),
				'revslider'                  => esc_html__( 'Revolution Slider', 'tediss' ),
				'js_composer'                => esc_html__( 'WPBakery PageBuilder', 'tediss' ),
				'trx_updater'         => esc_html__( 'ThemeREX Updater', 'tediss' ),
			)
	),

	// Theme-specific blog layouts
	'blog_styles'        => array_merge(
		// Layouts for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			'excerpt' => array(
				'title'   => esc_html__( 'Standard', 'tediss' ),
				'archive' => 'index-excerpt',
				'item'    => 'content-excerpt',
				'styles'  => 'excerpt',
			),
			'classic' => array(
				'title'   => esc_html__( 'Classic', 'tediss' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'classic',
			),
		),
		// Layouts for the FREE version only
		//-----------------------------------------------------
		TEDISS_THEME_FREE
		? array()

		// Layouts for the PREMIUM version only
		//-----------------------------------------------------
		: array(
			'masonry'   => array(
				'title'   => esc_html__( 'Masonry', 'tediss' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'masonry',
			),
			'portfolio' => array(
				'title'   => esc_html__( 'Portfolio', 'tediss' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio',
				'columns' => array( 2, 3, 4 ),
				'styles'  => 'portfolio',
			),
			'gallery'   => array(
				'title'   => esc_html__( 'Gallery', 'tediss' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio-gallery',
				'columns' => array( 2, 3, 4 ),
				'styles'  => array( 'portfolio', 'gallery' ),
			),
			'chess'     => array(
				'title'   => esc_html__( 'Chess', 'tediss' ),
				'archive' => 'index-chess',
				'item'    => 'content-chess',
				'columns' => array( 1, 2, 3 ),
				'styles'  => 'chess',
			),
		)
	),

	// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
	'theme_pro_key'      => 'env-themerex',

	// Generate Personal token from Envato to automatic upgrade theme
	'upgrade_token_url'  => '//build.envato.com/create-token/?default=t&purchase:download=t&purchase:list=t',

	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'     => '//tediss.themerex.net',
	'theme_doc_url'      => '//tediss.themerex.net/doc',
	'theme_download_url' => '//themeforest.net/item/tediss-play-area-child-care-center-wordpress-theme/23158793',

	'theme_support_url'  => '//themerex.net/support/',                             // ThemeREX

	'theme_video_url'    => '//www.youtube.com/channel/UCnFisBimrK2aIE-hnY70kCA',  // ThemeREX

	'theme_privacy_url'  => '//themerex.net/privacy-policy/',                      // ThemeREX

	// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
	// (i.e. 'children,kindergarten')
	'theme_categories'   => '',

	// Responsive resolutions
	// Parameters to create css media query: min, max
	'responsive'         => array(
		// By device
		'wide'       => array(
			'min' => 2160
		),
		'desktop'    => array(
			'min' => 1680,
			'max' => 2159,
		),
		'notebook'   => array(
			'min' => 1280,
			'max' => 1679,
		),
		'tablet'     => array(
			'min' => 768,
			'max' => 1279,
		),
		'not_mobile' => array( 'min' => 768 ),
		'mobile'     => array( 'max' => 767 ),
		// By size
		'xxl'        => array( 'max' => 1679 ),
		'xl'         => array( 'max' => 1439 ),
		'lg'         => array( 'max' => 1279 ),
		'md_over'    => array( 'min' => 1024 ),
		'md'         => array( 'max' => 1023 ),
		'sm'         => array( 'max' => 767 ),
		'sm_wp'      => array( 'max' => 600 ),
		'xs'         => array( 'max' => 479 ),
	),
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( ! function_exists( 'tediss_customizer_theme_setup1' ) ) {
	add_action( 'after_setup_theme', 'tediss_customizer_theme_setup1', 1 );
	function tediss_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		tediss_storage_set(
			'settings', array(

				'duplicate_options'      => 'child',            // none  - use separate options for the main and the child-theme
																// child - duplicate theme options from the main theme to the child-theme only
																// both  - sinchronize changes in the theme options between main and child themes

				'customize_refresh'      => 'auto',             // Refresh method for preview area in the Appearance - Customize:
																// auto - refresh preview area on change each field with Theme Options
																// manual - refresh only obn press button 'Refresh' at the top of Customize frame

				'max_load_fonts'         => 5,                  // Max fonts number to load from Google fonts or from uploaded fonts

				'comment_after_name'     => true,               // Place 'comment' field after the 'name' and 'email'

				'show_author_avatar'     => true,               // Display author's avatar in the post meta

				'icons_selector'         => 'internal',         // Icons selector in the shortcodes:
																// vc (default) - standard VC (very slow) or Elementor's icons selector (not support images and svg)
																// internal - internal popup with plugin's or theme's icons list (fast and support images and svg)

				'icons_type'             => 'icons',            // Type of icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present icons
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'socials_type'           => 'icons',            // Type of socials icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present social networks
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'check_min_version'      => true,               // Check if exists a .min version of .css and .js and return path to it
																// instead the path to the original file
																// (if debug_mode is off and modification time of the original file < time of the .min file)

				'autoselect_menu'        => false,              // Show any menu if no menu selected in the location 'main_menu'
																// (for example, the theme is just activated)

				'disable_jquery_ui'      => false,              // Prevent loading custom jQuery UI libraries in the third-party plugins

				'use_mediaelements'      => true,               // Load script "Media Elements" to play video and audio

				'tgmpa_upload'           => false,              // Allow upload not pre-packaged plugins via TGMPA

				'allow_no_image'         => false,              // Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.

				'separate_schemes'       => true,               // Save color schemes to the separate files __color_xxx.css (true) or append its to the __custom.css (false)

				'allow_fullscreen'       => false,              // Allow cases 'fullscreen' and 'fullwide' for the body style in the Theme Options
																// In the Page Options this styles are present always
																// (can be removed if filter 'tediss_filter_allow_fullscreen' return false)

				'attachments_navigation' => false,              // Add arrows on the single attachment page to navigate to the prev/next attachment
				
				'gutenberg_safe_mode'    => array(),            // 'vc', 'elementor' - Prevent simultaneous editing of posts for Gutenberg and other PageBuilders (VC, Elementor)

				'allow_gutenberg_blocks' => true,               // Allow our shortcodes and widgets as blocks in the Gutenberg (not ready yet - in the development now)

				'subtitle_above_title'   => true,               // Put subtitle above the title in the shortcodes

				'add_hide_on_xxx'        => 'replace',          // Add our breakpoints to the Responsive section of each element
																// 'add' - add our breakpoints after Elementor's
																// 'replace' - add our breakpoints instead Elementor's
																// 'none' - don't add our breakpoints (using only Elementor's)
			)
		);

		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------

		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		tediss_storage_set(
			'load_fonts', array(
				// Google font
				array(
					'name'   => 'Roboto',
					'family' => 'sans-serif',
					'styles' => '300,300italic,400,400italic,700,700italic',     // Parameter 'style' used only for the Google fonts
				),
				// Font-face packed with theme
                array(
					'name'   => 'Linotte',
					'family' => 'sans-serif',
				),
                array(
					'name'   => 'Woodford_bourneregular',
					'family' => 'sans-serif',
				),
                array(
					'name'   => 'Woodford_bournethin',
					'family' => 'sans-serif',
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		tediss_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		
		
		

		tediss_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'tediss' ),
					'description'     => esc_html__( 'Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'tediss' ),
					'font-family'     => '"Woodford_bournethin",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '100',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '0.7em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'tediss' ),
					'font-family'     => '"Linotte",sans-serif',
					'font-size'       => '3.4em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.205em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.68em',
					'margin-bottom'   => '0.75em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'tediss' ),
					'font-family'     => '"Linotte",sans-serif',
					'font-size'       => '2.75em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.78em',
					'margin-bottom'   => '0.6em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'tediss' ),
					'font-family'     => '"Linotte",sans-serif',
					'font-size'       => '1.9em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.21em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.68em',
					'margin-bottom'   => '1.1em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'tediss' ),
					'font-family'     => '"Woodford_bourneregular",sans-serif',
					'font-size'       => '1.6em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.19em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '2em',
					'margin-bottom'   => '0.8em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'tediss' ),
					'font-family'     => '"Woodford_bourneregular",sans-serif',
					'font-size'       => '1.3em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.46em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.7em',
					'margin-bottom'   => '0.6em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'tediss' ),
					'font-family'     => '"Woodford_bourneregular",sans-serif',
					'font-size'       => '1.1em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.364em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '2.15em',
					'margin-bottom'   => '.75em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'tediss' ),
					'description'     => esc_html__( 'Font settings of the text case of the logo', 'tediss' ),
					'font-family'     => '"Вk_smiling_catregular",sans-serif',
					'font-size'       => '1.8em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'tediss' ),
					'font-family'     => '"Woodford_bourneregular",sans-serif',
					'font-size'       => '20px',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '22px',
					'text-decoration' => 'none',
					'text-transform'  => 'capitalize',
					'letter-spacing'  => '0',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'tediss' ),
					'description'     => esc_html__( 'Font settings of the input fields, dropdowns and textareas', 'tediss' ),
					'font-family'     => 'inherit',
					'font-size'       => '1em',
					'font-weight'     => '100',
					'font-style'      => 'normal',
					'line-height'     => '1.5em', // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'tediss' ),
					'description'     => esc_html__( 'Font settings of the post meta: date, counters, share, etc.', 'tediss' ),
					'font-family'     => 'inherit',
					'font-size'       => '0.9em',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '100',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'tediss' ),
					'description'     => esc_html__( 'Font settings of the main menu items', 'tediss' ),
					'font-family'     => '"Linotte",sans-serif',
					'font-size'       => '0.9em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'tediss' ),
					'description'     => esc_html__( 'Font settings of the dropdown menu items', 'tediss' ),
					'font-family'     => '"Linotte",sans-serif',
					'font-size'       => '0.9rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
			)
		);

		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		tediss_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'tediss' ),
					'description' => esc_html__( 'Colors of the main content area', 'tediss' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'tediss' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'tediss' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'tediss' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'tediss' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'tediss' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'tediss' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'tediss' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'tediss' ),
				),
			)
		);
		tediss_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'tediss' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'tediss' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'tediss' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'tediss' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'tediss' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'tediss' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'tediss' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'tediss' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'tediss' ),
					'description' => esc_html__( 'Color of the plain text inside this block', 'tediss' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'tediss' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'tediss' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'tediss' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'tediss' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'tediss' ),
					'description' => esc_html__( 'Color of the links inside this block', 'tediss' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'tediss' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'tediss' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Link 2', 'tediss' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'tediss' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Link 2 hover', 'tediss' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'tediss' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Link 3', 'tediss' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'tediss' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Link 3 hover', 'tediss' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'tediss' ),
				),
			)
		);
		
		
		tediss_storage_set(
			'schemes', array(

				// Color scheme: 'default'
				'default' => array(
					'title'    => esc_html__( 'Default', 'tediss' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#ffffff', //+
						'bd_color'         => '#F3ECE3', //+

						// Text and links colors
						'text'             => '#474446', //+
						'text_light'       => '#8C8989', //+
						'text_dark'        => '#312F30', //+
						'text_link'        => '#FD5C37', //+
						'text_hover'       => '#341C77', //+
						'text_link2'       => '#FCC953', //+
						'text_hover2'      => '#B2EAEE', //+
						'text_link3'       => '#31C9A8', //+
						'text_hover3'      => '#341C77', //+

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#FFF6E9', //+
						'alter_bg_hover'   => '#F3ECE3', //+
						'alter_bd_color'   => '#F3ECE3', //+
						'alter_bd_hover'   => '#4A4294', //+
						'alter_text'       => '#474446', //+
						'alter_light'      => '#8C8989', //+
						'alter_dark'       => '#312F30', //+
						'alter_link'       => '#FD5C37', //+
						'alter_hover'      => '#341C77', //+
						'alter_link2'      => '#FCC953', //+
						'alter_hover2'     => '#B2EAEE', //+
						'alter_link3'      => '#31C9A8', //+
						'alter_hover3'     => '#341C77', //+

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#341C77', //+
						'extra_bg_hover'   => '#FFF6E9', //+
						'extra_bd_color'   => '#8E89C0', //+
						'extra_bd_hover'   => '#3d3d3d',
						'extra_text'       => '#bfbfbf',
						'extra_light'      => '#8C8989', //+
						'extra_dark'       => '#ffffff', //+
						'extra_link'       => '#FD5C37', //+
						'extra_hover'      => '#FCC953', //+
						'extra_link2'      => '#FECBBA', //+
						'extra_hover2'     => '#8be77c',
						'extra_link3'      => '#ddb837',
						'extra_hover3'     => '#eec432',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#ffffff', //+
						'input_bg_hover'   => '#ffffff', //+
						'input_bd_color'   => '#F3ECE3', //+
						'input_bd_hover'   => '#341C77', //+
						'input_text'       => '#474446', //+
						'input_light'      => '#8C8989', //+
						'input_dark'       => '#312F30', //+

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#B2EAEE', //+
						'inverse_bd_hover' => '#341C77', //+
						'inverse_text'     => '#474446', //+
						'inverse_light'    => '#8C8989', //+
						'inverse_dark'     => '#312F30', //+
						'inverse_link'     => '#ffffff', //+
						'inverse_hover'    => '#341C77', //+
					),
				),

				// Color scheme: 'dark'
				'dark'    => array(
					'title'    => esc_html__( 'Dark', 'tediss' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#341C77', //+
						'bd_color'         => '#4A4294', //+

						// Text and links colors
						'text'             => '#E1DFE8', //+
						'text_light'       => '#8E89C0', //+
						'text_dark'        => '#ffffff', //+
						'text_link'        => '#FD5C37', //+
						'text_hover'       => '#ffffff', //+
						'text_link2'       => '#FCC953', //+
						'text_hover2'      => '#B2EAEE', //+
						'text_link3'       => '#31C9A8', //+
						'text_hover3'      => '#FD5C37', //+

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#FCC953', //+
						'alter_bg_hover'   => '#FFD383', //+
						'alter_bd_color'   => '#FFD383', //+
						'alter_bd_hover'   => '#4A4294', //+
						'alter_text'       => '#474446', //+
						'alter_light'      => '#B78B26', //+
						'alter_dark'       => '#312F30', //+
						'alter_link'       => '#341C77', //+
						'alter_hover'      => '#ffffff', //+
						'alter_link2'      => '#FCC953', //+
						'alter_hover2'     => '#B2EAEE', //+
						'alter_link3'      => '#31C9A8', //+
						'alter_hover3'     => '#341C77', //+

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#FFFFFF', //+
						'extra_bg_hover'   => '#FFF6E9', //+
						'extra_bd_color'   => '#F3ECE3', //+
						'extra_bd_hover'   => '#4a4a4a',
						'extra_text'       => '#312F30', //+
						'extra_light'      => '#8E89C0', //+
						'extra_dark'       => '#312F30', //+
						'extra_link'       => '#FD5C37', //+
						'extra_hover'      => '#FD5C37', //+
						'extra_link2'      => '#FECBBA', //+
						'extra_hover2'     => '#8be77c',
						'extra_link3'      => '#ddb837',
						'extra_hover3'     => '#eec432',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#ffffff', //+
						'input_bg_hover'   => '#ffffff', //+
						'input_bd_color'   => '#ffffff', //+
						'input_bd_hover'   => '#FD5C37', //+
						'input_text'       => '#474446', //+
						'input_light'      => '#6f6f6f',
						'input_dark'       => '#312F30', //+

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#31C9A8', //+
						'inverse_bd_hover' => '#FCC953', //+
						'inverse_text'     => '#474446', //+
						'inverse_light'    => '#8C8989', //+
						'inverse_dark'     => '#312F30', //+
						'inverse_link'     => '#ffffff',
						'inverse_hover'    => '#341C77', //+
					),
				),

			)
		);
		
		tediss_storage_set( 'schemes_original', tediss_storage_get( 'schemes' ) );

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		tediss_storage_set(
			'schemes_simple', array(
				'text_link'        => array(
					'alter_hover'      => 1,
					'extra_link'       => 1,
					'inverse_bd_color' => 0.85,
					'inverse_bd_hover' => 0.7,
				),
				'text_hover'       => array(
					'alter_link'  => 1,
					'extra_hover' => 1,
				),
				'text_link2'       => array(
					'alter_hover2' => 1,
					'extra_link2'  => 1,
				),
				'text_hover2'      => array(
					'alter_link2'  => 1,
					'extra_hover2' => 1,
				),
				'text_link3'       => array(
					'alter_hover3' => 1,
					'extra_link3'  => 1,
				),
				'text_hover3'      => array(
					'alter_link3'  => 1,
					'extra_hover3' => 1,
				),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
				'inverse_bd_color' => array(),
				'inverse_bd_hover' => array(),
			)
		);

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		tediss_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'extra_dark_02'      => array(
					'color' => 'extra_dark',
					'alpha' => 0.2,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Parameters to set order of schemes in the css
		tediss_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		tediss_storage_set(
			'theme_thumbs', apply_filters(
				'tediss_filter_add_thumb_sizes', array(
					// Width of the image is equal to the content area width (without sidebar)
					// Height is fixed
					'tediss-thumb-huge'        => array(
						'size'  => array( 1170, 658, true ),
						'title' => esc_html__( 'Huge image', 'tediss' ),
						'subst' => 'trx_addons-thumb-huge',
					),
					// Width of the image is equal to the content area width (with sidebar)
					// Height is fixed
					'tediss-thumb-big'         => array(
						'size'  => array( 760, 428, true ),
						'title' => esc_html__( 'Large image', 'tediss' ),
						'subst' => 'trx_addons-thumb-big',
					),

					// Width of the image is equal to the 1/3 of the content area width (without sidebar)
					// Height is fixed
					'tediss-thumb-med'         => array(
						'size'  => array( 370, 208, true ),
						'title' => esc_html__( 'Medium image', 'tediss' ),
						'subst' => 'trx_addons-thumb-medium',
					),

					// Small square image (for avatars in comments, etc.)
					'tediss-thumb-tiny'        => array(
						'size'  => array( 90, 90, true ),
						'title' => esc_html__( 'Small square avatar', 'tediss' ),
						'subst' => 'trx_addons-thumb-tiny',
					),

					// Width of the image is equal to the content area width (with sidebar)
					// Height is proportional (only downscale, not crop)
					'tediss-thumb-masonry-big' => array(
						'size'  => array( 760, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry Large (scaled)', 'tediss' ),
						'subst' => 'trx_addons-thumb-masonry-big',
					),

					// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
					// Height is proportional (only downscale, not crop)
					'tediss-thumb-masonry'     => array(
						'size'  => array( 370, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry (scaled)', 'tediss' ),
						'subst' => 'trx_addons-thumb-masonry',
					),
                    'tediss-thumb-pricing'         => array(
                        'size'  => array( 390, 220, true ),
                        'title' => esc_html__( 'Pricing image', 'tediss' ),
                        'subst' => 'trx_addons-thumb-pricing',
                    ),
                    'tediss-thumb-excerpt'         => array(
                        'size'  => array( 780, 438, true ),
                        'title' => esc_html__( 'Excerpt image', 'tediss' ),
                        'subst' => 'trx_addons-thumb-excerpt',
                    ),
				)
			)
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'tediss_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'tediss_importer_set_options', 9 );
	function tediss_importer_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Allow import/export functionality
			$options['allow_import'] = true;
			$options['allow_export'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url( tediss_get_protocol() . '://demofiles.themerex.net/tediss/' );
			// Required plugins
			$options['required_plugins'] = array_keys( tediss_storage_get( 'required_plugins' ) );
			// Set number of thumbnails (usually 3 - 5) to regenerate at once when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 0;
			// Default demo
			$options['files']['default']['title']       = esc_html__( 'Tediss Demo', 'tediss' );
			$options['files']['default']['domain_dev']  = '';       // Developers domain
			$options['files']['default']['domain_demo'] = esc_url( tediss_get_protocol() . '://tediss.themerex.net' );       // Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter
			
			
			
			// Banners
			$options['banners'] = array(
				array(
					'image'        => tediss_get_file_url( 'theme-specific/theme-about/images/frontpage.png' ),
					'title'        => esc_html__( 'Front Page Builder', 'tediss' ),
					'content'      => wp_kses( __( "Create your front page right in the WordPress Customizer. There's no need in any page builder. Simply enable/disable sections, fill them out with content, and customize to your liking.", 'tediss' ), 'tediss_kses_content' ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=VT0AUbMl_KA' ),
					'link_caption' => esc_html__( 'Watch Video Introduction', 'tediss' ),
					'duration'     => 20,
				),
				array(
					'image'        => tediss_get_file_url( 'theme-specific/theme-about/images/layouts.png' ),
					'title'        => esc_html__( 'Layouts Builder', 'tediss' ),
					'content'      => wp_kses( __( 'Use Layouts Builder to create and customize header and footer styles for your website. With a flexible page builder interface and custom shortcodes, you can create as many header and footer layouts as you want with ease.', 'tediss' ), 'tediss_kses_content' ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=pYhdFVLd7y4' ),
					'link_caption' => esc_html__( 'Learn More', 'tediss' ),
					'duration'     => 20,
				),
				array(
					'image'        => tediss_get_file_url( 'theme-specific/theme-about/images/documentation.png' ),
					'title'        => esc_html__( 'Read Full Documentation', 'tediss' ),
					'content'      => wp_kses( __( 'Need more details? Please check our full online documentation for detailed information on how to use Tediss.', 'tediss' ), 'tediss_kses_content' ),
					'link_url'     => esc_url( tediss_storage_get( 'theme_doc_url' ) ),
					'link_caption' => esc_html__( 'Online Documentation', 'tediss' ),
					'duration'     => 15,
				),
				array(
					'image'        => tediss_get_file_url( 'theme-specific/theme-about/images/video-tutorials.png' ),
					'title'        => esc_html__( 'Video Tutorials', 'tediss' ),
					'content'      => wp_kses( __( 'No time for reading documentation? Check out our video tutorials and learn how to customize Tediss in detail.', 'tediss' ), 'tediss_kses_content' ),
					'link_url'     => esc_url( tediss_storage_get( 'theme_video_url' ) ),
					'link_caption' => esc_html__( 'Video Tutorials', 'tediss' ),
					'duration'     => 15,
				),
				array(
					'image'        => tediss_get_file_url( 'theme-specific/theme-about/images/studio.png' ),
					'title'        => esc_html__( 'Website Customization', 'tediss' ),
					'content'      => wp_kses( __( "Need a website fast? Order our custom service, and we'll build a website based on this theme for a very fair price. We can also implement additional functionality such as website translation, setting up WPML, and much more.", 'tediss' ), 'tediss_kses_content' ),
					'link_url'     => esc_url( '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash' ),
					'link_caption' => esc_html__( 'Contact Us', 'tediss' ),
					'duration'     => 25,
				),
			);
		}
		return $options;
	}
}


//------------------------------------------------------------------------
// OCDI support
//------------------------------------------------------------------------

// Set theme specific OCDI options
if ( ! function_exists( 'tediss_ocdi_set_options' ) ) {
	add_filter( 'trx_addons_filter_ocdi_options', 'tediss_ocdi_set_options', 9 );
	function tediss_ocdi_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Prepare demo data
			$options['demo_url'] = esc_url( tediss_get_protocol() . '://demofiles.themerex.net/tediss/' );
			// Required plugins
			$options['required_plugins'] = array_keys( tediss_storage_get( 'required_plugins' ) );
			// Demo-site domain
			$options['files']['ocdi']['title']       = esc_html__( 'Tediss OCDI Demo', 'tediss' );
			$options['files']['ocdi']['domain_demo'] = esc_url( tediss_get_protocol() . '://tediss.themerex.net' );
			// If theme need more demo - just copy 'default' and change required parameter
			
			
			
		}
		return $options;
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if ( ! function_exists( 'tediss_create_theme_options' ) ) {

	function tediss_create_theme_options() {

		// Message about options override.
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __( 'Attention! Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages. If you changed such parameter and nothing happened on the page, this option may be overridden in the corresponding section or in the Page Options of this page. These options are marked with an asterisk (*) in the title.', 'tediss' );

		// Color schemes number: if < 2 - hide fields with selectors
		$hide_schemes = count( tediss_storage_get( 'schemes' ) ) < 2;

		tediss_storage_set(
			'options', array(

				// 'Logo & Site Identity'
				'title_tagline'                 => array(
					'title'    => esc_html__( 'Logo & Site Identity', 'tediss' ),
					'desc'     => '',
					'priority' => 10,
					'type'     => 'section',
				),
				'logo_info'                     => array(
					'title'    => esc_html__( 'Logo Settings', 'tediss' ),
					'desc'     => '',
					'priority' => 20,
					'qsetup'   => esc_html__( 'General', 'tediss' ),
					'type'     => 'info',
				),
				'logo_text'                     => array(
					'title'    => esc_html__( 'Use Site Name as Logo', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Use the site title and tagline as a text logo if no image is selected', 'tediss' ) ),
					'class'    => 'tediss_column-1_2 tediss_new_row',
					'priority' => 30,
					'std'      => 1,
					'qsetup'   => esc_html__( 'General', 'tediss' ),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_retina_enabled'           => array(
					'title'    => esc_html__( 'Allow retina display logo', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Show fields to select logo images for Retina display', 'tediss' ) ),
					'class'    => 'tediss_column-1_2',
					'priority' => 40,
					'refresh'  => false,
					'std'      => 0,
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_zoom'                     => array(
					'title'   => esc_html__( 'Logo zoom', 'tediss' ),
					'desc'    => wp_kses(
									__( 'Zoom the logo (set 1 to leave original size).', 'tediss' )
									. ' <br>'
									. __( 'Attention! For this parameter to affect images, their max-height should be specified in "em" instead of "px" when creating a header.', 'tediss' )
									. ' <br>'
									. __( 'In this case maximum size of logo depends on the actual size of the picture.', 'tediss' ), 'tediss_kses_content'
								),
					'std'     => 1,
					'min'     => 0.2,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => TEDISS_THEME_FREE ? 'hidden' : 'slider',
				),
				// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
				'logo_retina'                   => array(
					'title'      => esc_html__( 'Logo for Retina', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'tediss' ) ),
					'class'      => 'tediss_column-1_2',
					'priority'   => 70,
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile_header'            => array(
					'title' => esc_html__( 'Logo for the mobile header', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'tediss' ) ),
					'class' => 'tediss_column-1_2 tediss_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_header_retina'     => array(
					'title'      => esc_html__( 'Logo for the mobile header on Retina', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'tediss' ) ),
					'class'      => 'tediss_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile'                   => array(
					'title' => esc_html__( 'Logo for the mobile menu', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile menu', 'tediss' ) ),
					'class' => 'tediss_column-1_2 tediss_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_retina'            => array(
					'title'      => esc_html__( 'Logo mobile on Retina', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'tediss' ) ),
					'class'      => 'tediss_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_side'                     => array(
					'title' => esc_html__( 'Logo for the side menu', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu', 'tediss' ) ),
					'class' => 'tediss_column-1_2 tediss_new_row',
					'std'   => '',
					'type'  => 'hidden', //image
				),
				'logo_side_retina'              => array(
					'title'      => esc_html__( 'Logo for the side menu on Retina', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'tediss' ) ),
					'class'      => 'tediss_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => 'hidden', //'image'
				),

				// 'General settings'
				'general'                       => array(
					'title'    => esc_html__( 'General Settings', 'tediss' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 20,
					'type'     => 'section',
				),

				'general_layout_info'           => array(
					'title'  => esc_html__( 'Layout', 'tediss' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'tediss' ),
					'type'   => 'info',
				),
				'body_style'                    => array(
					'title'    => esc_html__( 'Body style', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select width of the body content', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'qsetup'   => esc_html__( 'General', 'tediss' ),
					'refresh'  => false,
					'std'      => 'wide',
					'options'  => tediss_get_list_body_styles( false ),
					'type'     => 'select',
				),
				'page_width'                    => array(
					'title'      => esc_html__( 'Page width', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Total width of the site content and sidebar (in pixels). If empty - use default width', 'tediss' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed', 'wide' ),
					),
					'std'        => 1230,
					'min'        => 1000,
					'max'        => 1400,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'page',         // SASS variable's name to preview changes 'on fly'
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'slider',
				),
				'boxed_bg_image'                => array(
					'title'      => esc_html__( 'Boxed bg image', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select or upload image, used as background in the boxed body', 'tediss' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed' ),
					),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'std'        => '',
					'qsetup'     => esc_html__( 'General', 'tediss' ),
					
					'type'       => 'image',
				),
				'remove_margins'                => array(
					'title'    => esc_html__( 'Remove margins', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Remove margins above and below the content area', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'refresh'  => false,
					'std'      => 0,
					'type'     => 'checkbox',
				),

				'general_sidebar_info'          => array(
					'title' => esc_html__( 'Sidebar', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position'              => array(
					'title'    => esc_html__( 'Sidebar position', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page',		// Override parameters for single posts moved to the 'sidebar_position_single'
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'std'      => 'right',
					'qsetup'   => esc_html__( 'General', 'tediss' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_position_mobile'       => array(
					'title'    => esc_html__( 'Sidebar position on mobile', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page',		// Override parameters for single posts moved to the 'sidebar_position_mobile_single'
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'dependency' => array(
						'sidebar_position' => array( '^hide' ),
					),
					'std'      => 'below',
					'qsetup'   => esc_html__( 'General', 'tediss' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets'               => array(
					'title'      => esc_html__( 'Sidebar widgets', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',		// Override parameters for single posts moved to the 'sidebar_widgets_single'
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'dependency' => array(
						'sidebar_position' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'tediss' ),
					'type'       => 'select',
				),
				'sidebar_width'                 => array(
					'title'      => esc_html__( 'Sidebar width', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Width of the sidebar (in pixels). If empty - use default width', 'tediss' ) ),
					'std'        => 390,
					'min'        => 150,
					'max'        => 500,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'sidebar',      // SASS variable's name to preview changes 'on fly'
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'slider',
				),
				'sidebar_gap'                   => array(
					'title'      => esc_html__( 'Sidebar gap', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Gap between content and sidebar (in pixels). If empty - use default gap', 'tediss' ) ),
					'std'        => 60,
					'min'        => 0,
					'max'        => 100,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'gap',          // SASS variable's name to preview changes 'on fly'
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'slider',
				),
				'expand_content'                => array(
					'title'   => esc_html__( 'Expand content', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'tediss' ) ),
					'refresh' => false,
					'override'   => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'general_widgets_info'          => array(
					'title' => esc_html__( 'Additional widgets', 'tediss' ),
					'desc'  => '',
					'type'  => TEDISS_THEME_FREE ? 'hidden' : 'info',
				),
				'widgets_above_page'            => array(
					'title'    => esc_html__( 'Widgets at the top of the page', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_above_content'         => array(
					'title'    => esc_html__( 'Widgets above the content', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_content'         => array(
					'title'    => esc_html__( 'Widgets below the content', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_page'            => array(
					'title'    => esc_html__( 'Widgets at the bottom of the page', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),

				'general_effects_info'          => array(
					'title' => esc_html__( 'Design & Effects', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'border_radius'                 => array(
					'title'      => esc_html__( 'Border radius', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Specify the border radius of the form fields and buttons in pixels', 'tediss' ) ),
					'std'        => 40,
					'min'        => 0,
					'max'        => 50,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'rad',      // SASS name to preview changes 'on fly'
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'slider',
				),

				'general_misc_info'             => array(
					'title' => esc_html__( 'Miscellaneous', 'tediss' ),
					'desc'  => '',
					'type'  => TEDISS_THEME_FREE ? 'hidden' : 'info',
				),
				'seo_snippets'                  => array(
					'title' => esc_html__( 'SEO snippets', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Add structured data markup to the single posts and pages', 'tediss' ) ),
					'std'   => 0,
					'type'  => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'privacy_text' => array(
					"title" => esc_html__("Text with Privacy Policy link", 'tediss'),
					"desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'tediss') ),
					"std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'tediss' ), 'tediss_kses_content' ),
					"type"  => "text"
				),

				// 'Header'
				'header'                        => array(
					'title'    => esc_html__( 'Header', 'tediss' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 30,
					'type'     => 'section',
				),

				'header_style_info'             => array(
					'title' => esc_html__( 'Header style', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type'                   => array(
					'title'    => esc_html__( 'Header style', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'std'      => 'default',
					'options'  => tediss_get_list_header_footer_types(),
					'type'     => TEDISS_THEME_FREE || ! tediss_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'tediss' ),
					'desc'       => wp_kses( __( 'Select custom header from Layouts Builder', 'tediss' ), 'tediss_kses_content' ),
					'override'   => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'dependency' => array(
						'header_type' => array( 'custom' ),
					),
					'std'        => TEDISS_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position'               => array(
					'title'    => esc_html__( 'Header position', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight'             => array(
					'title'    => esc_html__( 'Header fullheight', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'std'      => 0,
					'type'     => 'hidden',
				),
				'header_wide'                   => array(
					'title'      => esc_html__( 'Header fullwidth', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page,post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_zoom'                   => array(
					'title'   => esc_html__( 'Header zoom', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Zoom the header title. 1 - original size', 'tediss' ) ),
					'std'     => 1,
					'min'     => 0.3,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => TEDISS_THEME_FREE ? 'hidden' : 'slider',
				),

				'header_widgets_info'           => array(
					'title' => esc_html__( 'Header widgets', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Here you can place a widget slider, advertising banners, etc.', 'tediss' ) ),
					'type'  => 'info',
				),
				'header_widgets'                => array(
					'title'    => esc_html__( 'Header widgets', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select set of widgets to show in the header on each page', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
						'desc'    => wp_kses_data( __( 'Select set of widgets to show in the header on this page', 'tediss' ) ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => 'select',
				),
				'header_columns'                => array(
					'title'      => esc_html__( 'Header columns', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'dependency' => array(
						'header_type'    => array( 'default' ),
						'header_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => tediss_get_list_range( 0, 6 ),
					'type'       => 'select',
				),

				'menu_info'                     => array(
					'title' => esc_html__( 'Main menu', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Select main menu style, position and other parameters', 'tediss' ) ),
					'type'  => TEDISS_THEME_FREE ? 'hidden' : 'info',
				),
				'menu_style'                    => array(
					'title'    => esc_html__( 'Menu position', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position of the main menu', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'std'      => 'top',
					'options'  => array(
						'top'   => esc_html__( 'Top', 'tediss' ),
					),
					'type'     => TEDISS_THEME_FREE || ! tediss_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'menu_side_stretch'             => array(
					'title'      => esc_html__( 'Stretch sidemenu', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Stretch sidemenu to window height (if menu items number >= 5)', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 0,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_side_icons'               => array(
					'title'      => esc_html__( 'Iconed sidemenu', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 1,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_mobile_fullscreen'        => array(
					'title' => esc_html__( 'Mobile menu fullscreen', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'tediss' ) ),
					'std'   => 1,
					'type'  => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_image_info'             => array(
					'title' => esc_html__( 'Header image', 'tediss' ),
					'desc'  => '',
					'type'  => TEDISS_THEME_FREE ? 'hidden' : 'info',
				),
				'header_image_override'         => array(
					'title'    => esc_html__( 'Header image override', 'tediss' ),
					'desc'     => wp_kses_data( __( "Allow override the header image with the page's/post's/product's/etc. featured image", 'tediss' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'std'      => 0,
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_mobile_info'            => array(
					'title'      => esc_html__( 'Mobile header', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Configure the mobile version of the header', 'tediss' ) ),
					'priority'   => 500,
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'info',
				),
				'header_mobile_enabled'         => array(
					'title'      => esc_html__( 'Enable the mobile header', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Use the mobile version of the header (if checked) or relayout the current header on mobile devices', 'tediss' ) ),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_additional_info' => array(
					'title'      => esc_html__( 'Additional info', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Additional info to show at the top of the mobile header', 'tediss' ) ),
					'std'        => '',
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'refresh'    => false,
					'teeny'      => false,
					'rows'       => 20,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'text_editor',
				),
				'header_mobile_hide_info'       => array(
					'title'      => esc_html__( 'Hide additional info', 'tediss' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_logo'       => array(
					'title'      => esc_html__( 'Hide logo', 'tediss' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_login'      => array(
					'title'      => esc_html__( 'Hide login/logout', 'tediss' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_search'     => array(
					'title'      => esc_html__( 'Hide search', 'tediss' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_cart'       => array(
					'title'      => esc_html__( 'Hide cart', 'tediss' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),

                // Custom Section 'Theme Specific'
                'custom_section' => array(
                    "title" => esc_html__('Custom Section', 'tediss'),
                    "desc" => wp_kses_data( __("Theme specific settings", 'tediss') ),
                    "type" => "section"
                ),
                'custom_section_info' => array(
                    "title" => esc_html__('Custom section of the side button', 'tediss'),
                    "desc" => wp_kses_data( __("General settings of the Side Button", 'tediss') ),
                    "type" => "info"
                ),
                'side_button_section' => array(
                    "title" => esc_html__('Show section with Side Button', 'tediss'),
                    "desc" => wp_kses_data( __("Check this field to show section with Side Button", 'tediss') ),
                    "override" => array(
                        'mode' => 'page',
                        'section' => esc_html__('Content', 'tediss')
                    ),
                    "std" => 1,
                    "type" => "checkbox"
                ),
                'side_button_caption' => array(
                    "title" => esc_html__("Caption for button", 'tediss'),
                    "desc" => wp_kses_data( __("Caption of the Side Button", 'tediss') ),
                    "std" => 'Opening Hours',
                    "type" => "text"
                ),
                'side_button_icon' => array(
                    "title" => esc_html__("Icon for button",  'tediss'),
                    "desc" => wp_kses_data( __("Select any icon for button", 'tediss') ),
                    "std" => "icon-wall-clock",
                    "options" => array(),
                    "style" => tediss_exists_trx_addons() ? trx_addons_get_setting('icons_type') : '',
                    "type" => tediss_exists_trx_addons() ? "icon" : "hidden"
                ),
                'side_button_layout' => array(
                    "title" => esc_html__('Layout for button', 'tediss'),
                    "desc" => wp_kses_data( __('Select any previously created layout to insert to "Side Button"', 'tediss') ),
                    "std" => 'none',
                    "options" => tediss_list_custom_styles(),
                    "type" => "select"
                ),


				// 'Footer'
				'footer'                        => array(
					'title'    => esc_html__( 'Footer', 'tediss' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 50,
					'type'     => 'section',
				),
				'footer_type'                   => array(
					'title'    => esc_html__( 'Footer style', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'tediss' ),
					),
					'std'      => 'default',
					'options'  => tediss_get_list_header_footer_types(),
					'type'     => TEDISS_THEME_FREE || ! tediss_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'footer_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'tediss' ),
					'desc'       => wp_kses( __( 'Select custom footer from Layouts Builder', 'tediss' ), 'tediss_kses_content' ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'tediss' ),
					),
					'dependency' => array(
						'footer_type' => array( 'custom' ),
					),
					'std'        => TEDISS_THEME_FREE ? 'footer-custom-elementor-footer-default' : 'footer-custom-footer-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_widgets'                => array(
					'title'      => esc_html__( 'Footer widgets', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'tediss' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 'footer_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_columns'                => array(
					'title'      => esc_html__( 'Footer columns', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'tediss' ),
					),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'footer_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => tediss_get_list_range( 0, 6 ),
					'type'       => 'select',
				),
				'footer_wide'                   => array(
					'title'      => esc_html__( 'Footer fullwidth', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'tediss' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_in_footer'                => array(
					'title'      => esc_html__( 'Show logo', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show logo in the footer', 'tediss' ) ),
					'refresh'    => false,
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_footer'                   => array(
					'title'      => esc_html__( 'Logo for footer', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo to display it in the footer', 'tediss' ) ),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'logo_in_footer' => array( 1 ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'logo_footer_retina'            => array(
					'title'      => esc_html__( 'Logo for footer (Retina)', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'tediss' ) ),
					'dependency' => array(
						'footer_type'         => array( 'default' ),
						'logo_in_footer'      => array( 1 ),
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'image',
				),
				'socials_in_footer'             => array(
					'title'      => esc_html__( 'Show social icons', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show social icons in the footer (under logo or footer widgets)', 'tediss' ) ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => ! tediss_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'copyright'                     => array(
					'title'      => esc_html__( 'Copyright', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'tediss' ) ),
					'translate'  => true,
					'std'        => esc_html__( 'Copyright &copy; {Y} by ThemeREX. All rights reserved.', 'tediss' ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'refresh'    => false,
					'type'       => 'textarea',
				),

				// 'Blog'
				'blog'                          => array(
					'title'    => esc_html__( 'Blog', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Options of the the blog archive', 'tediss' ) ),
					'priority' => 70,
					'type'     => 'panel',
				),

				// Blog - Posts page
				'blog_general'                  => array(
					'title' => esc_html__( 'Posts page', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Style and components of the blog archive', 'tediss' ) ),
					'type'  => 'section',
				),
				'blog_general_info'             => array(
					'title'  => esc_html__( 'Posts page settings', 'tediss' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'tediss' ),
					'type'   => 'info',
				),
				'blog_style'                    => array(
					'title'      => esc_html__( 'Blog style', 'tediss' ),
					'desc'       => '',
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'std'        => 'excerpt',
					'qsetup'     => esc_html__( 'General', 'tediss' ),
					'options'    => array(),
					'type'       => 'select',
				),
				'first_post_large'              => array(
					'title'      => esc_html__( 'First post large', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Make your first post stand out by making it bigger', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
						'blog_style' => array( 'classic', 'masonry' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'blog_content'                  => array(
					'title'      => esc_html__( 'Posts content', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Display either post excerpts or the full post content', 'tediss' ) ),
					'std'        => 'excerpt',
					'dependency' => array(
						'blog_style' => array( 'excerpt' ),
					),
					'options'    => array(
						'excerpt'  => esc_html__( 'Excerpt', 'tediss' ),
						'fullpost' => esc_html__( 'Full post', 'tediss' ),
					),
					'type'       => 'switch',
				),
				'excerpt_length'                => array(
					'title'      => esc_html__( 'Excerpt length', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged', 'tediss' ) ),
					'dependency' => array(
						'blog_style'   => array( 'excerpt' ),
						'blog_content' => array( 'excerpt' ),
					),
					'std'        => 32,
					'type'       => 'text',
				),
				'blog_columns'                  => array(
					'title'   => esc_html__( 'Blog columns', 'tediss' ),
					'desc'    => wp_kses_data( __( 'How many columns should be used in the blog archive (from 2 to 4)?', 'tediss' ) ),
					'std'     => 2,
					'options' => tediss_get_list_range( 2, 4 ),
					'type'    => 'hidden',      // This options is available and must be overriden only for some modes (for example, 'shop')
				),
				'post_type'                     => array(
					'title'      => esc_html__( 'Post type', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select post type to show in the blog archive', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'linked'     => 'parent_cat',
					'refresh'    => false,
					'hidden'     => true,
					'std'        => 'post',
					'options'    => array(),
					'type'       => 'select',
				),
				'parent_cat'                    => array(
					'title'      => esc_html__( 'Category to show', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select category to show in the blog archive', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'refresh'    => false,
					'hidden'     => true,
					'std'        => '0',
					'options'    => array(),
					'type'       => 'select',
				),
				'posts_per_page'                => array(
					'title'      => esc_html__( 'Posts per page', 'tediss' ),
					'desc'       => wp_kses_data( __( 'How many posts will be displayed on this page', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'hidden'     => true,
					'std'        => '',
					'type'       => 'text',
				),
				'blog_pagination'               => array(
					'title'      => esc_html__( 'Pagination style', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show Older/Newest posts or Page numbers below the posts list', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'std'        => 'pages',
					'qsetup'     => esc_html__( 'General', 'tediss' ),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'options'    => array(
						'pages'    => esc_html__( 'Page numbers', 'tediss' ),
						'links'    => esc_html__( 'Older/Newest', 'tediss' ),
						'more'     => esc_html__( 'Load more', 'tediss' ),
						'infinite' => esc_html__( 'Infinite scroll', 'tediss' ),
					),
					'type'       => 'select',
				),
				'blog_animation'                => array(
					'title'      => esc_html__( 'Animation for the posts', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'std'        => 'none',
					'options'    => array(),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'show_filters'                  => array(
					'title'      => esc_html__( 'Show filters', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show categories as tabs to filter posts', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
						'blog_style'     => array( 'portfolio', 'gallery' ),
					),
					'hidden'     => true,
					'std'        => 0,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_header_info'              => array(
					'title' => esc_html__( 'Header', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type_blog'              => array(
					'title'    => esc_html__( 'Header style', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'tediss' ) ),
					'std'      => 'inherit',
					'options'  => tediss_get_list_header_footer_types( true ),
					'type'     => TEDISS_THEME_FREE || ! tediss_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style_blog'             => array(
					'title'      => esc_html__( 'Select custom layout', 'tediss' ),
					'desc'       => wp_kses( __( 'Select custom header from Layouts Builder', 'tediss' ), 'tediss_kses_content' ),
					'dependency' => array(
						'header_type_blog' => array( 'custom' ),
					),
					'std'        => TEDISS_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position_blog'          => array(
					'title'    => esc_html__( 'Header position', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'tediss' ) ),
					'std'      => 'inherit',
					'options'  => array(),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight_blog'        => array(
					'title'    => esc_html__( 'Header fullheight', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'tediss' ) ),
					'std'      => 0,
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_wide_blog'              => array(
					'title'      => esc_html__( 'Header fullwidth', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'tediss' ) ),
					'dependency' => array(
						'header_type_blog' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_sidebar_info'             => array(
					'title' => esc_html__( 'Sidebar', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position_blog'         => array(
					'title'   => esc_html__( 'Sidebar position', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Select position to show sidebar', 'tediss' ) ),
					'std'     => 'inherit',
					'options' => array(),
					'qsetup'     => esc_html__( 'General', 'tediss' ),
					'type'    => 'switch',
				),
				'sidebar_position_mobile_blog'  => array(
					'title'    => esc_html__( 'Sidebar position on mobile', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'tediss' ) ),
					'dependency' => array(
						'sidebar_position_blog' => array( '^hide' ),
					),
					'std'      => 'inherit',
					'qsetup'   => esc_html__( 'General', 'tediss' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets_blog'          => array(
					'title'      => esc_html__( 'Sidebar widgets', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'tediss' ) ),
					'dependency' => array(
						'sidebar_position_blog' => array( '^hide' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'tediss' ),
					'type'       => 'select',
				),
				'expand_content_blog'           => array(
					'title'   => esc_html__( 'Expand content', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'tediss' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'blog_widgets_info'             => array(
					'title' => esc_html__( 'Additional widgets', 'tediss' ),
					'desc'  => '',
					'type'  => TEDISS_THEME_FREE ? 'hidden' : 'info',
				),
				'widgets_above_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the top of the page', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'tediss' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_above_content_blog'    => array(
					'title'   => esc_html__( 'Widgets above the content', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'tediss' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_content_blog'    => array(
					'title'   => esc_html__( 'Widgets below the content', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'tediss' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the bottom of the page', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'tediss' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),

				'blog_advanced_info'            => array(
					'title' => esc_html__( 'Advanced settings', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'no_image'                      => array(
					'title' => esc_html__( 'Image placeholder', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Select or upload an image used as placeholder for posts without a featured image', 'tediss' ) ),
					'std'   => '',
					'type'  => 'image',
				),
				'time_diff_before'              => array(
					'title' => esc_html__( 'Easy Readable Date Format', 'tediss' ),
					'desc'  => wp_kses_data( __( "For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'tediss' ) ),
					'std'   => 5,
					'type'  => 'text',
				),
				'sticky_style'                  => array(
					'title'   => esc_html__( 'Sticky posts style', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Select style of the sticky posts output', 'tediss' ) ),
					'std'     => 'inherit',
					'options' => array(
						'inherit' => esc_html__( 'Decorated posts', 'tediss' ),
						'columns' => esc_html__( 'Mini-cards', 'tediss' ),
					),
					'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'meta_parts'                    => array(
					'title'      => esc_html__( 'Post meta', 'tediss' ),
					'desc'       => wp_kses_data( __( "If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Post counters and Share Links are available only if plugin ThemeREX Addons is active", 'tediss' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'categories=0|date=1|counters=1|author=1|share=0|edit=0',
					'options'    => tediss_get_list_meta_parts(),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters'                      => array(
					'title'      => esc_html__( 'Post counters', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if ThemeREX Addons is active', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'views=0|likes=0|comments=1',
					'options'    => tediss_get_list_counters(),
					'type'       => TEDISS_THEME_FREE || ! tediss_exists_trx_addons() ? 'hidden' : 'checklist',
				),

				// Blog - Single posts
				'blog_single'                   => array(
					'title' => esc_html__( 'Single posts', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Settings of the single post', 'tediss' ) ),
					'type'  => 'section',
				),

				'blog_single_header_info'       => array(
					'title' => esc_html__( 'Header', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type_post'              => array(
					'title'    => esc_html__( 'Header style', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'tediss' ) ),
					'std'      => 'inherit',
					'options'  => tediss_get_list_header_footer_types( true ),
					'type'     => TEDISS_THEME_FREE || ! tediss_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style_post'             => array(
					'title'      => esc_html__( 'Select custom layout', 'tediss' ),
					'desc'       => wp_kses( __( 'Select custom header from Layouts Builder', 'tediss' ), 'tediss_kses_content' ),
					'dependency' => array(
						'header_type_post' => array( 'custom' ),
					),
					'std'        => TEDISS_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position_post'          => array(
					'title'    => esc_html__( 'Header position', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'tediss' ) ),
					'std'      => 'inherit',
					'options'  => array(),
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight_post'        => array(
					'title'    => esc_html__( 'Header fullheight', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'tediss' ) ),
					'std'      => 0,
					'type'     => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_wide_post'              => array(
					'title'      => esc_html__( 'Header fullwidth', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'tediss' ) ),
					'dependency' => array(
						'header_type_post' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_single_sidebar_info'      => array(
					'title' => esc_html__( 'Sidebar', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position_single'       => array(
					'title'   => esc_html__( 'Sidebar position', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Select position to show sidebar on the single posts', 'tediss' ) ),
					'std'     => 'right',
					'override'   => array(
						'mode'    => 'post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'options' => array(),
					'type'    => 'switch',
				),
				'sidebar_position_mobile_single'=> array(
					'title'    => esc_html__( 'Sidebar position on mobile', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar on the single posts on mobile devices - above or below the content', 'tediss' ) ),
					'override' => array(
						'mode'    => 'post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'dependency' => array(
						'sidebar_position_single' => array( '^hide' ),
					),
					'std'      => 'below',
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets_single'        => array(
					'title'      => esc_html__( 'Sidebar widgets', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar on the single posts', 'tediss' ) ),
					'override'   => array(
						'mode'    => 'post,product,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'tediss' ),
					),
					'dependency' => array(
						'sidebar_position_single' => array( '^hide' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'expand_content_post'           => array(
					'title'   => esc_html__( 'Expand content', 'tediss' ),
					'desc'    => wp_kses_data( __( 'Expand the content width on the single posts if the sidebar is hidden', 'tediss' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'blog_single_title_info'      => array(
					'title' => esc_html__( 'Featured image and title', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'hide_featured_on_single'       => array(
					'title'    => esc_html__( 'Hide featured image on the single post', 'tediss' ),
					'desc'     => wp_kses_data( __( "Hide featured image on the single post's pages", 'tediss' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'post_thumbnail_type'      => array(
					'title'      => esc_html__( 'Type of post thumbnail', 'tediss' ),
					'desc'       => wp_kses_data( __( "Select type of post thumbnail on the single post's pages", 'tediss' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 'is_empty', 0 ),
					),
					'std'        => 'default',
					'options'    => array(
						'fullwidth'   => esc_html__( 'Fullwidth', 'tediss' ),
						'boxed'       => esc_html__( 'Boxed', 'tediss' ),
						'default'     => esc_html__( 'Default', 'tediss' ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'post_header_position'          => array(
					'title'      => esc_html__( 'Post header position', 'tediss' ),
					'desc'       => wp_kses_data( __( "Select post header position on the single post's pages", 'tediss' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 'is_empty', 0 ),
					),
					'std'        => 'default',
					'options'    => array(
						'above'      => esc_html__( 'Above the post thumbnail', 'tediss' ),
						'on_thumb'   => esc_html__( 'On the post thumbnail', 'tediss' ),
						'default'    => esc_html__( 'Default', 'tediss' ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'post_header_align'             => array(
					'title'      => esc_html__( 'Align of the post header', 'tediss' ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'dependency' => array(
						'post_header_position' => array( 'on_thumb' ),
					),
					'std'        => 'mc',
					'options'    => array(
						'ts' => esc_html__('Top Stick Out', 'tediss'),
						'tl' => esc_html__('Top Left', 'tediss'),
						'tc' => esc_html__('Top Center', 'tediss'),
						'tr' => esc_html__('Top Right', 'tediss'),
						'ml' => esc_html__('Middle Left', 'tediss'),
						'mc' => esc_html__('Middle Center', 'tediss'),
						'mr' => esc_html__('Middle Right', 'tediss'),
						'bl' => esc_html__('Bottom Left', 'tediss'),
						'bc' => esc_html__('Bottom Center', 'tediss'),
						'br' => esc_html__('Bottom Right', 'tediss'),
						'bs' => esc_html__('Bottom Stick Out', 'tediss'),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'post_subtitle'                 => array(
					'title' => esc_html__( 'Post subtitle', 'tediss' ),
					'desc'  => wp_kses_data( __( "Specify post subtitle to display it under the post title.", 'tediss' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'std'   => '',
					'hidden' => true,
					'type'  => 'text',
				),
				'show_post_meta'                => array(
					'title' => esc_html__( 'Show post meta', 'tediss' ),
					'desc'  => wp_kses_data( __( "Display block with post's meta: date, categories, counters, etc.", 'tediss' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'meta_parts_post'               => array(
					'title'      => esc_html__( 'Post meta', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Meta parts for single posts. Post counters and Share Links are available only if plugin ThemeREX Addons is active', 'tediss' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'tediss' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'categories=0|date=1|counters=1|author=1|share=0|edit=0',
					'options'    => tediss_get_list_meta_parts(),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters_post'                 => array(
					'title'      => esc_html__( 'Post counters', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if plugin ThemeREX Addons is active', 'tediss' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'views=0|likes=0|comments=1',
					'options'    => tediss_get_list_counters(),
					'type'       => TEDISS_THEME_FREE || ! tediss_exists_trx_addons() ? 'hidden' : 'checklist',
				),
				'show_share_links'              => array(
					'title' => esc_html__( 'Show share links', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Display share links on the single post', 'tediss' ) ),
					'std'   => 1,
					'type'  => ! tediss_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'show_author_info'              => array(
					'title' => esc_html__( 'Show author info', 'tediss' ),
					'desc'  => wp_kses_data( __( "Display block with information about post's author", 'tediss' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),

				'blog_single_related_info'      => array(
					'title' => esc_html__( 'Related posts', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_related_posts'            => array(
					'title'    => esc_html__( 'Show related posts', 'tediss' ),
					'desc'     => wp_kses_data( __( "Show section 'Related posts' on the single post's pages", 'tediss' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'tediss' ),
					),
					'std'      => 1,
					'type'     => 'checkbox',
				),
				'related_posts'                 => array(
					'title'      => esc_html__( 'Related posts', 'tediss' ),
					'desc'       => wp_kses_data( __( 'How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => tediss_get_list_range( 1, 9 ),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'related_columns'               => array(
					'title'      => esc_html__( 'Related columns', 'tediss' ),
					'desc'       => wp_kses_data( __( 'How many columns should be used to output related posts in the single page (from 2 to 4)?', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => tediss_get_list_range( 1, 4 ),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_style'                 => array(
					'title'      => esc_html__( 'Related posts style', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select style of the related posts output', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => tediss_get_list_styles( 1, 3 ),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_slider'                => array(
					'title'      => esc_html__( 'Use slider layout', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Use slider layout in case related posts count is more than columns count', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 0,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'related_slider_controls'       => array(
					'title'      => esc_html__( 'Slider controls', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show arrows in the slider', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'none',
					'options'    => array(
						'none'    => esc_html__('None', 'tediss'),
						'side'    => esc_html__('Side', 'tediss'),
						'outside' => esc_html__('Outside', 'tediss'),
						'top'     => esc_html__('Top', 'tediss'),
						'bottom'  => esc_html__('Bottom', 'tediss')
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
				),
				'related_slider_pagination'       => array(
					'title'      => esc_html__( 'Slider pagination', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Show bullets after the slider', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'bottom',
					'options'    => array(
						'none'    => esc_html__('None', 'tediss'),
						'bottom'  => esc_html__('Bottom', 'tediss')
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_slider_space'          => array(
					'title'      => esc_html__( 'Space', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Space between slides', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 30,
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'text',
				),
				'related_position'              => array(
					'title'      => esc_html__( 'Related posts position', 'tediss' ),
					'desc'       => wp_kses_data( __( 'Select position to display the related posts', 'tediss' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 'below_content',
					'options'    => array (
						'below_content' => esc_html__( 'After content', 'tediss' ),
						'below_page'    => esc_html__( 'After content & sidebar', 'tediss' ),
					),
					'type'       => TEDISS_THEME_FREE ? 'hidden' : 'switch',
				),
				'posts_navigation_info'      => array(
					'title' => esc_html__( 'Posts navigation', 'tediss' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_posts_navigation'		=> array(
					'title'    => esc_html__( 'Show posts navigation', 'tediss' ),
					'desc'     => wp_kses_data( __( "Show posts navigation on the single post's pages", 'tediss' ) ),
					'std'      => 1,
					'type'     => 'checkbox',
				),
				'fixed_posts_navigation'		=> array(
					'title'    => esc_html__( 'Fixed posts navigation', 'tediss' ),
					'desc'     => wp_kses_data( __( "Make posts navigation fixed position. Display it when the content of the article is inside the window.", 'tediss' ) ),
					'dependency' => array(
						'show_posts_navigation' => array( 1 ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'blog_end'                      => array(
					'type' => 'panel_end',
				),

				// 'Colors'
				'panel_colors'                  => array(
					'title'    => esc_html__( 'Colors', 'tediss' ),
					'desc'     => '',
					'priority' => 300,
					'type'     => 'section',
				),

				'color_schemes_info'            => array(
					'title'  => esc_html__( 'Color schemes', 'tediss' ),
					'desc'   => wp_kses_data( __( 'Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'tediss' ) ),
					'hidden' => $hide_schemes,
					'type'   => 'info',
				),
				'color_scheme'                  => array(
					'title'    => esc_html__( 'Site Color Scheme', 'tediss' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'tediss' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'header_scheme'                 => array(
					'title'    => esc_html__( 'Header Color Scheme', 'tediss' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'tediss' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'menu_scheme'                   => array(
					'title'    => esc_html__( 'Sidemenu Color Scheme', 'tediss' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'tediss' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => 'hidden' // 'switch'
				),
				'sidebar_scheme'                => array(
					'title'    => esc_html__( 'Sidebar Color Scheme', 'tediss' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'tediss' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'footer_scheme'                 => array(
					'title'    => esc_html__( 'Footer Color Scheme', 'tediss' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'tediss' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),

				'color_scheme_editor_info'      => array(
					'title' => esc_html__( 'Color scheme editor', 'tediss' ),
					'desc'  => wp_kses_data( __( 'Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'tediss' ) ),
					'type'  => 'info',
				),
				'scheme_storage'                => array(
					'title'       => esc_html__( 'Color scheme editor', 'tediss' ),
					'desc'        => '',
					'std'         => '$tediss_get_scheme_storage',
					'refresh'     => false,
					'colorpicker' => 'tiny',
					'type'        => 'scheme_editor',
				),

				// Internal options.
				// Attention! Don't change any options in the section below!
				// Use huge priority to call render this elements after all options!
				'reset_options'                 => array(
					'title'    => '',
					'desc'     => '',
					'std'      => '0',
					'priority' => 10000,
					'type'     => 'hidden',
				),

				'last_option'                   => array(     // Need to manually call action to include Tiny MCE scripts
					'title' => '',
					'desc'  => '',
					'std'   => 1,
					'type'  => 'hidden',
				),

			)
		);

		// Prepare panel 'Fonts'
		// -------------------------------------------------------------
		$fonts = array(

			// 'Fonts'
			'fonts'             => array(
				'title'    => esc_html__( 'Typography', 'tediss' ),
				'desc'     => '',
				'priority' => 200,
				'type'     => 'panel',
			),

			// Fonts - Load_fonts
			'load_fonts'        => array(
				'title' => esc_html__( 'Load fonts', 'tediss' ),
				'desc'  => wp_kses_data( __( 'Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'tediss' ) )
						. '<br>'
						. wp_kses_data( __( 'Attention! Press "Refresh" button to reload preview area after the all fonts are changed', 'tediss' ) ),
				'type'  => 'section',
			),
			'load_fonts_subset' => array(
				'title'   => esc_html__( 'Google fonts subsets', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Specify comma separated list of the subsets which will be load from Google fonts', 'tediss' ) )
						. '<br>'
						. wp_kses_data( __( 'Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'tediss' ) ),
				'class'   => 'tediss_column-1_3 tediss_new_row',
				'refresh' => false,
				'std'     => '$tediss_get_load_fonts_subset',
				'type'    => 'text',
			),
		);

		for ( $i = 1; $i <= tediss_get_theme_setting( 'max_load_fonts' ); $i++ ) {
			if ( tediss_get_value_gp( 'page' ) != 'theme_options' ) {
				$fonts[ "load_fonts-{$i}-info" ] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					'title' => esc_html( sprintf( __( 'Font %s', 'tediss' ), $i ) ),
					'desc'  => '',
					'type'  => 'info',
				);
			}
			$fonts[ "load_fonts-{$i}-name" ]   = array(
				'title'   => esc_html__( 'Font name', 'tediss' ),
				'desc'    => '',
				'class'   => 'tediss_column-1_3 tediss_new_row',
				'refresh' => false,
				'std'     => '$tediss_get_load_fonts_option',
				'type'    => 'text',
			);
			$fonts[ "load_fonts-{$i}-family" ] = array(
				'title'   => esc_html__( 'Font family', 'tediss' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Select font family to use it if font above is not available', 'tediss' ) )
							: '',
				'class'   => 'tediss_column-1_3',
				'refresh' => false,
				'std'     => '$tediss_get_load_fonts_option',
				'options' => array(
					'inherit'    => esc_html__( 'Inherit', 'tediss' ),
					'serif'      => esc_html__( 'serif', 'tediss' ),
					'sans-serif' => esc_html__( 'sans-serif', 'tediss' ),
					'monospace'  => esc_html__( 'monospace', 'tediss' ),
					'cursive'    => esc_html__( 'cursive', 'tediss' ),
					'fantasy'    => esc_html__( 'fantasy', 'tediss' ),
				),
				'type'    => 'select',
			);
			$fonts[ "load_fonts-{$i}-styles" ] = array(
				'title'   => esc_html__( 'Font styles', 'tediss' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'tediss' ) )
								. '<br>'
								. wp_kses_data( __( 'Attention! Each weight and style increase download size! Specify only used weights and styles.', 'tediss' ) )
							: '',
				'class'   => 'tediss_column-1_3',
				'refresh' => false,
				'std'     => '$tediss_get_load_fonts_option',
				'type'    => 'text',
			);
		}
		$fonts['load_fonts_end'] = array(
			'type' => 'section_end',
		);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = tediss_get_theme_fonts();
		foreach ( $theme_fonts as $tag => $v ) {
			$fonts[ "{$tag}_section" ] = array(
				'title' => ! empty( $v['title'] )
								? $v['title']
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html( sprintf( __( '%s settings', 'tediss' ), $tag ) ),
				'desc'  => ! empty( $v['description'] )
								? $v['description']
								// Translators: Add tag's name to make description
								: wp_kses( sprintf( __( 'Font settings of the "%s" tag.', 'tediss' ), $tag ), 'tediss_kses_content' ),
				'type'  => 'section',
			);

			foreach ( $v as $css_prop => $css_value ) {
				if ( in_array( $css_prop, array( 'title', 'description' ) ) ) {
					continue;
				}
				$options    = '';
				$type       = 'text';
				$load_order = 1;
				$title      = ucfirst( str_replace( '-', ' ', $css_prop ) );
				if ( 'font-family' == $css_prop ) {
					$type       = 'select';
					$options    = array();
					$load_order = 2;        // Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} elseif ( 'font-weight' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'tediss' ),
						'100'     => esc_html__( '100 (Light)', 'tediss' ),
						'200'     => esc_html__( '200 (Light)', 'tediss' ),
						'300'     => esc_html__( '300 (Thin)', 'tediss' ),
						'400'     => esc_html__( '400 (Normal)', 'tediss' ),
						'500'     => esc_html__( '500 (Semibold)', 'tediss' ),
						'600'     => esc_html__( '600 (Semibold)', 'tediss' ),
						'700'     => esc_html__( '700 (Bold)', 'tediss' ),
						'800'     => esc_html__( '800 (Black)', 'tediss' ),
						'900'     => esc_html__( '900 (Black)', 'tediss' ),
					);
				} elseif ( 'font-style' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'tediss' ),
						'normal'  => esc_html__( 'Normal', 'tediss' ),
						'italic'  => esc_html__( 'Italic', 'tediss' ),
					);
				} elseif ( 'text-decoration' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'      => esc_html__( 'Inherit', 'tediss' ),
						'none'         => esc_html__( 'None', 'tediss' ),
						'underline'    => esc_html__( 'Underline', 'tediss' ),
						'overline'     => esc_html__( 'Overline', 'tediss' ),
						'line-through' => esc_html__( 'Line-through', 'tediss' ),
					);
				} elseif ( 'text-transform' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'    => esc_html__( 'Inherit', 'tediss' ),
						'none'       => esc_html__( 'None', 'tediss' ),
						'uppercase'  => esc_html__( 'Uppercase', 'tediss' ),
						'lowercase'  => esc_html__( 'Lowercase', 'tediss' ),
						'capitalize' => esc_html__( 'Capitalize', 'tediss' ),
					);
				}
				$fonts[ "{$tag}_{$css_prop}" ] = array(
					'title'      => $title,
					'desc'       => '',
					'class'      => 'tediss_column-1_5',
					'refresh'    => false,
					'load_order' => $load_order,
					'std'        => '$tediss_get_theme_fonts_option',
					'options'    => $options,
					'type'       => $type,
				);
			}

			$fonts[ "{$tag}_section_end" ] = array(
				'type' => 'section_end',
			);
		}

		$fonts['fonts_end'] = array(
			'type' => 'panel_end',
		);

		// Add fonts parameters to Theme Options
		tediss_storage_set_array_before( 'options', 'panel_colors', $fonts );

		// Add Header Video if WP version < 4.7
		// -----------------------------------------------------
		if ( ! function_exists( 'get_header_video_url' ) ) {
			tediss_storage_set_array_after(
				'options', 'header_image_override', 'header_video', array(
					'title'    => esc_html__( 'Header video', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select video to use it as background for the header', 'tediss' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'tediss' ),
					),
					'std'      => '',
					'type'     => 'video',
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is not 'Customize'
		// ------------------------------------------------------
		if ( ! function_exists( 'the_custom_logo' ) || ! tediss_check_current_url( 'customize.php' ) ) {
			tediss_storage_set_array_before(
				'options', 'logo_retina', function_exists( 'the_custom_logo' ) ? 'custom_logo' : 'logo', array(
					'title'    => esc_html__( 'Logo', 'tediss' ),
					'desc'     => wp_kses_data( __( 'Select or upload the site logo', 'tediss' ) ),
					'class'    => 'tediss_column-1_2 tediss_new_row',
					'priority' => 60,
					'std'      => '',
					'qsetup'   => esc_html__( 'General', 'tediss' ),
					'type'     => 'image',
				)
			);
		}

	}
}


// Returns a list of options that can be overridden for CPT
if ( ! function_exists( 'tediss_options_get_list_cpt_options' ) ) {
	function tediss_options_get_list_cpt_options( $cpt, $title = '' ) {
		if ( empty( $title ) ) {
			$title = ucfirst( $cpt );
		}
		return array(
			"content_info_{$cpt}"           => array(
				'title' => esc_html__( 'Content', 'tediss' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"body_style_{$cpt}"             => array(
				'title'    => esc_html__( 'Body style', 'tediss' ),
				'desc'     => wp_kses_data( __( 'Select width of the body content', 'tediss' ) ),
				'std'      => 'inherit',
				'options'  => tediss_get_list_body_styles( true ),
				'type'     => 'select',
			),
			"boxed_bg_image_{$cpt}"         => array(
				'title'      => esc_html__( 'Boxed bg image', 'tediss' ),
				'desc'       => wp_kses_data( __( 'Select or upload image, used as background in the boxed body', 'tediss' ) ),
				'dependency' => array(
					"body_style_{$cpt}" => array( 'boxed' ),
				),
				'std'        => 'inherit',
				'type'       => 'image',
			),
			"header_info_{$cpt}"            => array(
				'title' => esc_html__( 'Header', 'tediss' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"header_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Header style', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'tediss' ) ),
				'std'     => 'inherit',
				'options' => tediss_get_list_header_footer_types( true ),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'tediss' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select custom layout to display the site header on the %s pages', 'tediss' ), $title ) ),
				'dependency' => array(
					"header_type_{$cpt}" => array( 'custom' ),
				),
				'std'        => 'inherit',
				'options'    => array(),
				'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
			),
			"header_position_{$cpt}"        => array(
				'title'   => esc_html__( 'Header position', 'tediss' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to display the site header on the %s pages', 'tediss' ), $title ) ),
				'std'     => 'inherit',
				'options' => array(),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_image_override_{$cpt}"  => array(
				'title'   => esc_html__( 'Header image override', 'tediss' ),
				'desc'    => wp_kses_data( __( "Allow override the header image with the post's featured image", 'tediss' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'tediss' ),
					1         => esc_html__( 'Yes', 'tediss' ),
					0         => esc_html__( 'No', 'tediss' ),
				),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_widgets_{$cpt}"         => array(
				'title'   => esc_html__( 'Header widgets', 'tediss' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select set of widgets to show in the header on the %s pages', 'tediss' ), $title ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => 'select',
			),

			"sidebar_info_{$cpt}"           => array(
				'title' => esc_html__( 'Sidebar', 'tediss' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"sidebar_position_{$cpt}"       => array(
				'title'   => sprintf( esc_html__( 'Sidebar position on the %s list', 'tediss' ), $title ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to show sidebar on the %s list', 'tediss' ), $title ) ),
				'std'     => 'left',
				'options' => array(),
				'type'    => 'switch',
			),
			"sidebar_position_mobile_{$cpt}"=> array(
                'title'   => sprintf( esc_html__( 'Sidebar position on the %s list on mobile', 'tediss' ), $title ),
				'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'tediss' ) ),
				'std'      => 'below',
				'dependency' => array(
					"sidebar_position_{$cpt}" => array( '^hide' ),
				),
				'options'  => array(),
				'type'     => 'switch',
			),
			"sidebar_widgets_{$cpt}"        => array(
				'title'      => sprintf( esc_html__( 'Sidebar widgets on the %s list', 'tediss' ), $title ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select sidebar to show on the %s list', 'tediss' ), $title ) ),
				'dependency' => array(
					"sidebar_position_{$cpt}" => array( '^hide' ),
				),
				'std'        => 'hide',
				'options'    => array(),
				'type'       => 'select',
			),
			"sidebar_position_single_{$cpt}"       => array(
				'title'   => sprintf( esc_html__( 'Sidebar position on the single post', 'tediss' ), $title ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to show sidebar on the single posts of the %s', 'tediss' ), $title ) ),
				'std'     => 'left',
				'options' => array(),
				'type'    => 'switch',
			),
			"sidebar_position_mobile_single_{$cpt}"=> array(
				'title'    => esc_html__( 'Sidebar position on the single post on mobile', 'tediss' ),
				'desc'     => wp_kses_data( __( 'Select position to show sidebar on mobile devices - above or below the content', 'tediss' ) ),
				'dependency' => array(
					"sidebar_position_single_{$cpt}" => array( '^hide' ),
				),
				'std'      => 'below',
				'options'  => array(),
				'type'     => 'switch',
			),
			"sidebar_widgets_single_{$cpt}"        => array(
				'title'      => sprintf( esc_html__( 'Sidebar widgets on the single post', 'tediss' ), $title ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select widgets to show in the sidebar on the single posts of the %s', 'tediss' ), $title ) ),
				'dependency' => array(
					"sidebar_position_single_{$cpt}" => array( '^hide' ),
				),
				'std'        => 'hide',
				'options'    => array(),
				'type'       => 'select',
			),
			"expand_content_{$cpt}"         => array(
				'title'   => esc_html__( 'Expand content', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'tediss' ) ),
				'refresh' => false,
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'tediss' ),
					1         => esc_html__( 'Expand', 'tediss' ),
					0         => esc_html__( 'No', 'tediss' ),
				),
				'type'    => 'switch',
			),

			"footer_info_{$cpt}"            => array(
				'title' => esc_html__( 'Footer', 'tediss' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"footer_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Footer style', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'tediss' ) ),
				'std'     => 'inherit',
				'options' => tediss_get_list_header_footer_types( true ),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'switch',
			),
			"footer_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'tediss' ),
				'desc'       => wp_kses_data( __( 'Select custom layout to display the site footer', 'tediss' ) ),
				'std'        => 'inherit',
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'custom' ),
				),
				'options'    => array(),
				'type'       => TEDISS_THEME_FREE ? 'hidden' : 'select',
			),
			"footer_widgets_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer widgets', 'tediss' ),
				'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'tediss' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 'footer_widgets',
				'options'    => array(),
				'type'       => 'select',
			),
			"footer_columns_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer columns', 'tediss' ),
				'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'tediss' ) ),
				'dependency' => array(
					"footer_type_{$cpt}"    => array( 'default' ),
					"footer_widgets_{$cpt}" => array( '^hide' ),
				),
				'std'        => 0,
				'options'    => tediss_get_list_range( 0, 6 ),
				'type'       => 'select',
			),
			"footer_wide_{$cpt}"            => array(
				'title'      => esc_html__( 'Footer fullwidth', 'tediss' ),
				'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'tediss' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 0,
				'type'       => 'checkbox',
			),

			"widgets_info_{$cpt}"           => array(
				'title' => esc_html__( 'Additional panels', 'tediss' ),
				'desc'  => '',
				'type'  => TEDISS_THEME_FREE ? 'hidden' : 'info',
			),
			"widgets_above_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the top of the page', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'tediss' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_above_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets above the content', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'tediss' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_below_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets below the content', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'tediss' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_below_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the bottom of the page', 'tediss' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'tediss' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => TEDISS_THEME_FREE ? 'hidden' : 'select',
			),
		);
	}
}


// Return lists with choises when its need in the admin mode
if ( ! function_exists( 'tediss_options_get_list_choises' ) ) {
	add_filter( 'tediss_filter_options_get_list_choises', 'tediss_options_get_list_choises', 10, 2 );
	function tediss_options_get_list_choises( $list, $id ) {
		if ( is_array( $list ) && count( $list ) == 0 ) {
			if ( strpos( $id, 'header_style' ) === 0 ) {
				$list = tediss_get_list_header_styles( strpos( $id, 'header_style_' ) === 0 );
			} elseif ( strpos( $id, 'header_position' ) === 0 ) {
				$list = tediss_get_list_header_positions( strpos( $id, 'header_position_' ) === 0 );
			} elseif ( strpos( $id, 'header_widgets' ) === 0 ) {
				$list = tediss_get_list_sidebars( strpos( $id, 'header_widgets_' ) === 0, true );
			} elseif ( strpos( $id, '_scheme' ) > 0 ) {
				$list = tediss_get_list_schemes( 'color_scheme' != $id );
			} elseif ( strpos( $id, 'sidebar_widgets' ) === 0 ) {
				$list = tediss_get_list_sidebars( 'sidebar_widgets_single' != $id && ( strpos( $id, 'sidebar_widgets_' ) === 0 || strpos( $id, 'sidebar_widgets_single_' ) === 0 ), true );
			} elseif ( strpos( $id, 'sidebar_position_mobile' ) === 0 ) {
				$list = tediss_get_list_sidebars_positions_mobile( strpos( $id, 'sidebar_position_mobile_' ) === 0 );
			} elseif ( strpos( $id, 'sidebar_position' ) === 0 ) {
				$list = tediss_get_list_sidebars_positions( strpos( $id, 'sidebar_position_' ) === 0 );
			} elseif ( strpos( $id, 'widgets_above_page' ) === 0 ) {
				$list = tediss_get_list_sidebars( strpos( $id, 'widgets_above_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_above_content' ) === 0 ) {
				$list = tediss_get_list_sidebars( strpos( $id, 'widgets_above_content_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_page' ) === 0 ) {
				$list = tediss_get_list_sidebars( strpos( $id, 'widgets_below_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_content' ) === 0 ) {
				$list = tediss_get_list_sidebars( strpos( $id, 'widgets_below_content_' ) === 0, true );
			} elseif ( strpos( $id, 'footer_style' ) === 0 ) {
				$list = tediss_get_list_footer_styles( strpos( $id, 'footer_style_' ) === 0 );
			} elseif ( strpos( $id, 'footer_widgets' ) === 0 ) {
				$list = tediss_get_list_sidebars( strpos( $id, 'footer_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'blog_style' ) === 0 ) {
				$list = tediss_get_list_blog_styles( strpos( $id, 'blog_style_' ) === 0 );
			} elseif ( strpos( $id, 'post_type' ) === 0 ) {
				$list = tediss_get_list_posts_types();
			} elseif ( strpos( $id, 'parent_cat' ) === 0 ) {
				$list = tediss_array_merge( array( 0 => esc_html__( '- Select category -', 'tediss' ) ), tediss_get_list_categories() );
			} elseif ( strpos( $id, 'blog_animation' ) === 0 ) {
				$list = tediss_get_list_animations_in();
			} elseif ( 'color_scheme_editor' == $id ) {
				$list = tediss_get_list_schemes();
			} elseif ( strpos( $id, '_font-family' ) > 0 ) {
				$list = tediss_get_list_load_fonts( true );
			}
		}
		return $list;
	}
}
