<?php
/**
 * The template 'Style 1' to displaying related posts
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_link        = get_permalink();
$tediss_post_format = get_post_format();
$tediss_post_format = empty( $tediss_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tediss_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item related_item_style_1 post_format_' . esc_attr( $tediss_post_format ) ); ?>>
	<?php
	tediss_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'tediss_filter_related_thumb_size', tediss_get_thumb_size( (int) tediss_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
			'show_no_image' => tediss_get_theme_setting( 'allow_no_image' ),
			'singular'      => false,
			'post_info'     => '<div class="post_header entry-header">'
						. '<div class="post_categories">' . wp_kses( tediss_get_post_categories( '' ), 'tediss_kses_content' ) . '</div>'
						. '<h6 class="post_title entry-title"><a href="' . esc_url( $tediss_link ) . '">' . wp_kses_data( get_the_title() ) . '</a></h6>'
						. ( in_array( get_post_type(), array( 'post', 'attachment' ) )
								? '<span class="post_date"><a href="' . esc_url( $tediss_link ) . '">' . wp_kses_data( tediss_get_date() ) . '</a></span>'
								: '' )
					. '</div>',
		)
	);
	?>
</div>
