<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_link        = get_permalink();
$tediss_post_format = get_post_format();
$tediss_post_format = empty( $tediss_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tediss_post_format );
?><div id="post-<?php the_ID(); ?>" 
	<?php post_class( 'related_item related_item_style_2 post_format_' . esc_attr( $tediss_post_format ) ); ?>>
						<?php
						tediss_show_post_featured(
							array(
								'thumb_size'    => apply_filters( 'tediss_filter_related_thumb_size', tediss_get_thumb_size( (int) tediss_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
								'show_no_image' => tediss_get_theme_setting( 'allow_no_image' ),
								'singular'      => false,
							)
						);
						?>
	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $tediss_link ); ?>"><?php the_title(); ?></a></h6>
        <?php
        if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
            ?>
            <span class="post_date"><a href="<?php echo esc_url( $tediss_link ); ?>"><?php echo wp_kses_data( tediss_get_date() ); ?></a></span>
            <?php
        }
        ?>
	</div>
</div>
