<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

// Header sidebar
$tediss_header_name    = tediss_get_theme_option( 'header_widgets' );
$tediss_header_present = ! tediss_is_off( $tediss_header_name ) && is_active_sidebar( $tediss_header_name );
if ( $tediss_header_present ) {
	tediss_storage_set( 'current_sidebar', 'header' );
	$tediss_header_wide = tediss_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $tediss_header_name ) ) {
		dynamic_sidebar( $tediss_header_name );
	}
	$tediss_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $tediss_widgets_output ) ) {
		$tediss_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $tediss_widgets_output );
		$tediss_need_columns   = strpos( $tediss_widgets_output, 'columns_wrap' ) === false;
		if ( $tediss_need_columns ) {
			$tediss_columns = max( 0, (int) tediss_get_theme_option( 'header_columns' ) );
			if ( 0 == $tediss_columns ) {
				$tediss_columns = min( 6, max( 1, substr_count( $tediss_widgets_output, '<aside ' ) ) );
			}
			if ( $tediss_columns > 1 ) {
				$tediss_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $tediss_columns ) . ' widget', $tediss_widgets_output );
			} else {
				$tediss_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $tediss_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $tediss_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $tediss_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'tediss_action_before_sidebar' );
				tediss_show_layout( $tediss_widgets_output );
				do_action( 'tediss_action_after_sidebar' );
				if ( $tediss_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $tediss_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
