<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

// Page (category, tag, archive, author) title

if ( tediss_need_page_title() ) {
	tediss_sc_layouts_showed( 'title', true );
	tediss_sc_layouts_showed( 'postmeta', false );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if (  false && is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								tediss_show_post_meta(
									apply_filters(
										'tediss_filter_post_meta_args', array(
											'components' => tediss_array_get_keys_by_value( tediss_get_theme_option( 'meta_parts' ) ),
											'counters'   => tediss_array_get_keys_by_value( tediss_get_theme_option( 'counters' ) ),
											'seo'        => tediss_is_on( tediss_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$tediss_blog_title           = tediss_get_blog_title();
							$tediss_blog_title_text      = '';
							$tediss_blog_title_class     = '';
							$tediss_blog_title_link      = '';
							$tediss_blog_title_link_text = '';
							if ( is_array( $tediss_blog_title ) ) {
								$tediss_blog_title_text      = $tediss_blog_title['text'];
								$tediss_blog_title_class     = ! empty( $tediss_blog_title['class'] ) ? ' ' . $tediss_blog_title['class'] : '';
								$tediss_blog_title_link      = ! empty( $tediss_blog_title['link'] ) ? $tediss_blog_title['link'] : '';
								$tediss_blog_title_link_text = ! empty( $tediss_blog_title['link_text'] ) ? $tediss_blog_title['link_text'] : '';
							} else {
								$tediss_blog_title_text = $tediss_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $tediss_blog_title_class ); ?>">
								<?php
								$tediss_top_icon = tediss_get_category_icon();
								if ( ! empty( $tediss_top_icon ) ) {
									$tediss_attr = tediss_getimagesize( $tediss_top_icon );
									?>
									<img src="<?php echo esc_url( $tediss_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'tediss' ); ?>"
										<?php
										if ( ! empty( $tediss_attr[3] ) ) {
											tediss_show_layout( $tediss_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses( $tediss_blog_title_text, 'tediss_kses_content' );
								?>
							</h1>
							<?php
							if ( ! empty( $tediss_blog_title_link ) && ! empty( $tediss_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $tediss_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $tediss_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
                        <?php
                        if ( tediss_exists_trx_addons() ) { // Breadcrumbs ?>
                            <div class="sc_layouts_title_breadcrumbs">
                                <?php
                                do_action( 'tediss_action_breadcrumbs' );
                                ?>
                            </div>
                            <?php
                        }
                        ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>
