<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_args = get_query_var( 'tediss_logo_args' );

// Site logo
$tediss_logo_type   = isset( $tediss_args['type'] ) ? $tediss_args['type'] : '';
$tediss_logo_image  = tediss_get_logo_image( $tediss_logo_type );
$tediss_logo_text   = tediss_is_on( tediss_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$tediss_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $tediss_logo_image ) || ! empty( $tediss_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $tediss_logo_image ) ) {
			if ( empty( $tediss_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric( $tediss_logo_image ) && $tediss_logo_image > 0 ) {
				the_custom_logo();
			} else {
				$tediss_attr = tediss_getimagesize( $tediss_logo_image );
				echo '<img src="' . esc_url( $tediss_logo_image ) . '" alt="' . esc_attr( $tediss_logo_text ) . '"' . ( ! empty( $tediss_attr[3] ) ? ' ' . wp_kses_data( $tediss_attr[3] ) : '' ) . '>';
			}
		} else {
			tediss_show_layout( tediss_prepare_macros( $tediss_logo_text ), '<span class="logo_text">', '</span>' );
			tediss_show_layout( tediss_prepare_macros( $tediss_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
