<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

$tediss_header_css   = '';
$tediss_header_image = get_header_image();
$tediss_header_video = tediss_get_header_video();
if ( ! empty( $tediss_header_image ) && tediss_trx_addons_featured_image_override( is_singular() || tediss_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$tediss_header_image = tediss_get_current_mode_image( $tediss_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $tediss_header_image ) || ! empty( $tediss_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $tediss_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $tediss_header_image ) {
		echo ' ' . esc_attr( tediss_add_inline_css_class( 'background-image: url(' . esc_url( $tediss_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( tediss_is_on( tediss_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight tediss-full-height';
	}
	if ( ! tediss_is_inherit( tediss_get_theme_option( 'header_scheme' ) ) ) {
		echo ' scheme_' . esc_attr( tediss_get_theme_option( 'header_scheme' ) );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $tediss_header_video ) ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	if ( tediss_get_theme_option( 'menu_style' ) == 'top' ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-navi' ) );
	}

	// Mobile header
	if ( tediss_is_on( tediss_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-title' ) );

	// Header widgets area
	get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-widgets' ) );

	// Display featured image in the header on the single posts
	// Comment next line to prevent show featured image in the header area
	// and display it in the post's content
	get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-single' ) );

	?>
</header>
