<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.06
 */

$tediss_header_css   = '';
$tediss_header_image = get_header_image();
$tediss_header_video = tediss_get_header_video();
if ( ! empty( $tediss_header_image ) && tediss_trx_addons_featured_image_override( is_singular() || tediss_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$tediss_header_image = tediss_get_current_mode_image( $tediss_header_image );
}

$tediss_header_id = tediss_get_custom_header_id();
$tediss_header_meta = get_post_meta( $tediss_header_id, 'trx_addons_options', true );
if ( ! empty( $tediss_header_meta['margin'] ) ) {
	tediss_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( tediss_prepare_css_value( $tediss_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $tediss_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $tediss_header_id ) ) ); ?>
				<?php
				echo ! empty( $tediss_header_image ) || ! empty( $tediss_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $tediss_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $tediss_header_image ) {
					echo ' ' . esc_attr( tediss_add_inline_css_class( 'background-image: url(' . esc_url( $tediss_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( tediss_is_on( tediss_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight tediss-full-height';
				}
				if ( ! tediss_is_inherit( tediss_get_theme_option( 'header_scheme' ) ) ) {
					echo ' scheme_' . esc_attr( tediss_get_theme_option( 'header_scheme' ) );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $tediss_header_video ) ) {
		get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'tediss_action_show_layout', $tediss_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'tediss_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
