<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.10
 */

// Footer sidebar
$tediss_footer_name    = tediss_get_theme_option( 'footer_widgets' );
$tediss_footer_present = ! tediss_is_off( $tediss_footer_name ) && is_active_sidebar( $tediss_footer_name );
if ( $tediss_footer_present ) {
	tediss_storage_set( 'current_sidebar', 'footer' );
	$tediss_footer_wide = tediss_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $tediss_footer_name ) ) {
		dynamic_sidebar( $tediss_footer_name );
	}
	$tediss_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $tediss_out ) ) {
		$tediss_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $tediss_out );
		$tediss_need_columns = true;   //or check: strpos($tediss_out, 'columns_wrap')===false;
		if ( $tediss_need_columns ) {
			$tediss_columns = max( 0, (int) tediss_get_theme_option( 'footer_columns' ) );
			if ( 0 == $tediss_columns ) {
				$tediss_columns = min( 4, max( 1, substr_count( $tediss_out, '<aside ' ) ) );
			}
			if ( $tediss_columns > 1 ) {
				$tediss_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $tediss_columns ) . ' widget', $tediss_out );
			} else {
				$tediss_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $tediss_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $tediss_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $tediss_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'tediss_action_before_sidebar' );
				tediss_show_layout( $tediss_out );
				do_action( 'tediss_action_after_sidebar' );
				if ( $tediss_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $tediss_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
