<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.10
 */

// Logo
if ( tediss_is_on( tediss_get_theme_option( 'logo_in_footer' ) ) ) {
	$tediss_logo_image = tediss_get_logo_image( 'footer' );
	$tediss_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $tediss_logo_image ) || ! empty( $tediss_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $tediss_logo_image ) ) {
					$tediss_attr = tediss_getimagesize( $tediss_logo_image );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $tediss_logo_image ) . '"'
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'tediss' ) . '"'
								. ( ! empty( $tediss_attr[3] ) ? ' ' . wp_kses_data( $tediss_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $tediss_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $tediss_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
