<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.10
 */

$tediss_footer_id = tediss_get_custom_footer_id();
$tediss_footer_meta = get_post_meta( $tediss_footer_id, 'trx_addons_options', true );
if ( ! empty( $tediss_footer_meta['margin'] ) ) {
	tediss_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( tediss_prepare_css_value( $tediss_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $tediss_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $tediss_footer_id ) ) ); ?>
						<?php
						if ( ! tediss_is_inherit( tediss_get_theme_option( 'footer_scheme' ) ) ) {
							echo ' scheme_' . esc_attr( tediss_get_theme_option( 'footer_scheme' ) );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'tediss_action_show_layout', $tediss_footer_id );
	?>
</footer><!-- /.footer_wrap -->
