<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
if ( ! tediss_is_inherit( tediss_get_theme_option( 'copyright_scheme' ) ) ) {
	echo ' scheme_' . esc_attr( tediss_get_theme_option( 'copyright_scheme' ) );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$tediss_copyright = tediss_get_theme_option( 'copyright' );
			if ( ! empty( $tediss_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$tediss_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $tediss_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$tediss_copyright = tediss_prepare_macros( $tediss_copyright );
				// Display copyright
				echo wp_kses( nl2br( $tediss_copyright ), 'tediss_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
