<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0.1
 */

$tediss_theme_obj = wp_get_theme();
?>
<div class="tediss_admin_notice tediss_welcome_notice update-nag">
	<?php
	// Theme image
	$tediss_theme_img = tediss_get_file_url( 'screenshot.jpg' );
	if ( '' != $tediss_theme_img ) {
		?>
		<div class="tediss_notice_image"><img src="<?php echo esc_url( $tediss_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'tediss' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="tediss_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'tediss' ),
				$tediss_theme_obj->name . ( TEDISS_THEME_FREE ? ' ' . __( 'Free', 'tediss' ) : '' ),
				$tediss_theme_obj->version
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="tediss_notice_text">
		<p class="tediss_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $tediss_theme_obj->description ) );
			?>
		</p>
		<p class="tediss_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'tediss' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="tediss_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=tediss_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'tediss' );
			?>
		</a>
		<?php		
		// Dismiss this notice
		?>
		<a href="#" class="tediss_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="tediss_hide_notice_text"><?php esc_html_e( 'Dismiss', 'tediss' ); ?></span></a>
	</div>
</div>
