<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage TEDISS
 * @since TEDISS 1.0
 */

if ( tediss_sidebar_present() ) {
	ob_start();
	$tediss_sidebar_name = tediss_get_theme_option( 'sidebar_widgets' . ( is_single() ? '_single' : '' ) );
	tediss_storage_set( 'current_sidebar', 'sidebar' );
	if ( is_active_sidebar( $tediss_sidebar_name ) ) {
		dynamic_sidebar( $tediss_sidebar_name );
	}
	$tediss_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $tediss_out ) ) {
		$tediss_sidebar_position = tediss_get_theme_option( 'sidebar_position' . ( is_single() ? '_single' : '' ) );
		$tediss_sidebar_mobile   = tediss_get_theme_option( 'sidebar_position_mobile' . ( is_single() ? '_single' : '' ) );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $tediss_sidebar_position );
			echo ' sidebar_' . esc_attr( $tediss_sidebar_mobile );

			if ( 'above' == $tediss_sidebar_mobile ) {
			} else if ( 'float' == $tediss_sidebar_mobile ) {
				echo ' sidebar_float';
			}
			if ( ! tediss_is_inherit( tediss_get_theme_option( 'sidebar_scheme' ) ) ) {
				echo ' scheme_' . esc_attr( tediss_get_theme_option( 'sidebar_scheme' ) );
			}
			?>
		" role="complementary">
			<?php
			// Single posts banner before sidebar
			tediss_show_post_banner( 'sidebar' );
			// Button to show/hide sidebar on mobile
			if ( in_array( $tediss_sidebar_mobile, array( 'above', 'float' ) ) ) {
				$tediss_title = apply_filters( 'tediss_filter_sidebar_control_title', 'float' == $tediss_sidebar_mobile ? esc_html__( 'Show Sidebar', 'tediss' ) : '' );
				$tediss_text  = apply_filters( 'tediss_filter_sidebar_control_text', 'above' == $tediss_sidebar_mobile ? esc_html__( 'Show Sidebar', 'tediss' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $tediss_title ); ?>"><?php echo esc_html( $tediss_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'tediss_action_before_sidebar' );
				tediss_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $tediss_out ) );
				do_action( 'tediss_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<div class="clearfix"></div>
		<?php
	}
}
