<?php
/* ThemeREX Updater support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'tediss_trx_updater_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'tediss_trx_updater_theme_setup9', 9 );
    function tediss_trx_updater_theme_setup9() {

        if ( is_admin() ) {
            add_filter( 'tediss_filter_tgmpa_required_plugins', 'tediss_trx_updater_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'tediss_trx_updater_tgmpa_required_plugins' ) ) {
    
    function tediss_trx_updater_tgmpa_required_plugins( $list = array() ) {
        if ( tediss_storage_isset( 'required_plugins', 'trx_updater' ) && tediss_is_theme_activated() ) {
            $path = tediss_get_plugin_source_path( 'plugins/trx_updater/trx_updater.zip' );
            if ( ! empty( $path ) || tediss_get_theme_setting( 'tgmpa_upload' ) ) {
                $list[] = array(
                    'name'     => tediss_storage_get_array( 'required_plugins', 'trx_updater' ),
                    'slug'     => 'trx_updater',
                    'source'   => ! empty( $path ) ? $path : 'upload://trx_updater.zip',
                    'version'  => '2.1.1',
                    'required' => false,
                );
            }
        }
        return $list;
    }
}
// Check if plugin installed and activated
if ( ! function_exists( 'tediss_exists_trx_updater' ) ) {
	function tediss_exists_trx_updater() {
		return defined( 'EG_PLUGIN_PATH' );
	}
}