<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'tediss_tribe_events_get_css' ) ) {
	add_filter( 'tediss_filter_get_css', 'tediss_tribe_events_get_css', 10, 2 );
	function tediss_tribe_events_get_css( $css, $args ) {
		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

.tribe-common h3.tribe-common-h8,
.tribe-common h3.tribe-common-h7,
.tribe-common h3.tribe-common-h6,
.tribe-events-list .tribe-events-list-event-title {
	{$fonts['h3_font-family']}
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item,
.tribe-events-event-meta,
.tribe-events-content,
.tribe-common.tribe-events .tribe-events-c-view-selector__list-item-text,
.tribe-common--breakpoint-medium.tribe-common.tribe-events .tribe-common-form-control-text__input,
.tribe-common.tribe-events .tribe-common-form-control-text__input,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common .tribe-common-h1, .tribe-common .tribe-common-h2,
.tribe-common .tribe-common-h3, .tribe-common .tribe-common-h4,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h6,
.tribe-common .tribe-common-h7, .tribe-common .tribe-common-h8,
.tribe-common .tribe-common-b1, .tribe-common .tribe-common-b2,
.tribe-common .tribe-common-b3, .tribe-common .tribe-common-b4,
.tribe-common .tribe-common-b5, .tribe-common .tribe-common-b6,
.tribe-common .tribe-common-b7, .tribe-common .tribe-common-b8,
.tribe-events .datepicker .month,
.tribe-events .datepicker .day,
.tribe-events .datepicker .year,
.tribe-events .datepicker .datepicker-switch {
	{$fonts['p_font-family']}
}

.tribe-events-read-more,
#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a,
.tribe-events-button, .tribe-events-cal-links a,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-h3,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button,
.tribe-common .tribe-common-c-btn, .tribe-common a.tribe-common-c-btn,
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-events .tribe-events-c-nav__next, .tribe-events .tribe-events-c-nav__prev,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-b1--min-medium,
.tribe-common .tribe-events-c-ical__link,
.tribe-events .tribe-events-c-nav__list-item--today a,
.tribe-common .tribe-common-c-btn.tribe-events-c-search__button {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events-read-more {
	{$fonts['button_font-family']}
	{$fonts['button_letter-spacing']}
}
 .tribe-events .datepicker .dow,
.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-calendar thead th,
.tribe-events-schedule, .tribe-events-schedule h2 {
	{$fonts['h5_font-family']}
}
#tribe-bar-form input, #tribe-events-content.tribe-events-month,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events-list-widget ol li .tribe-event-title, #tribe-bar-views-toggle, .tribe-bar-views-list li, .tribe-bar-collapse #tribe-bar-collapse-toggle {
	{$fonts['p_font-family']}
}
.tribe-events-loop .tribe-event-schedule-details,
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt,
#tribe-mobile-container .type-tribe_events .tribe-event-date-start {
	{$fonts['info_font-family']};
}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

#tribe-events .tribe-events-button,
#tribe-bar-form .tribe-bar-submit input[type="submit"],
#tribe-bar-form button,
#tribe-events .tribe-events-button,
#tribe-bar-views .tribe-bar-views-list,
.tribe-events-button,
.tribe-events-cal-links a,
#tribe-events-footer ~ a.tribe-events-ical.tribe-events-button,
.tribe-events-sub-nav li a,
.tribe-events-read-more,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-h3,
.tribe-common .tribe-common-c-btn, .tribe-common a.tribe-common-c-btn,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button,
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-common .tribe-events-c-ical__link,
.tribe-events .tribe-events-c-nav__next, .tribe-events .tribe-events-c-nav__prev,
.tribe-events .tribe-events-c-nav__list-item--today a {
	-webkit-border-radius: {$vars['rad']} !important;
	    -ms-border-radius: {$vars['rad']} !important;
			border-radius: {$vars['rad']} !important;
}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS

/* Filters bar */
#tribe-bar-form {
	color: {$colors['text_dark']};
}

#tribe-events-bar{
    background-color: {$colors['alter_bg_color']};
}

#tribe-bar-form input[type="text"] {
	color: {$colors['text_dark']};
	border-color: {$colors['bd_color']}!important;
    background-color: {$colors['bg_color']};
	
}
#tribe-bar-views-toggle, .tribe-bar-views-list, #tribe-bar-views .tribe-bar-views-option, #tribe-bar-collapse-toggle{
	background-color: {$colors['text_link']}!important;
	color: {$colors['inverse_link']};
}
#tribe-bar-views-toggle:focus, #tribe-bar-views-toggle:hover, #tribe-bar-views .tribe-bar-views-option:hover, #tribe-bar-views .tribe-bar-views-option.tribe-bar-active, #tribe-bar-collapse-toggle:focus, #tribe-bar-collapse-toggle:hover {
    background-color: {$colors['text_hover']}!important;
    color: {$colors['extra_dark']};
}
.datepicker thead tr:first-child th:hover, .datepicker tfoot tr th:hover {
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}

.datepicker table tr td span.active.active {
    background: {$colors['text_link']};
}



/* Content */
.tribe-events-calendar thead th {
	color: {$colors['extra_dark']};
	background: {$colors['extra_bg_color']} !important;
}
.tribe-events-calendar thead th + th:before {
	background: {$colors['extra_dark']};
}
#tribe-events-content .tribe-events-calendar td {
	border-color: {$colors['bd_color']} !important;
}
#tribe-events-content .tribe-events-calendar th+th{
    border-color: {$colors['alter_bd_hover']} !important;
}
.tribe-events-calendar td.mobile-trigger div[id*="tribe-events-daynum-"]{
     border-color: {$colors['text_hover']};
     background: {$colors['bg_color']};
}

.tribe-events-calendar td div[id*="tribe-events-daynum-"],
.tribe-events-calendar td div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_dark']};
}
.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
	background: {$colors['alter_bg_color']} !important;
}
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"] > a {
	color: {$colors['alter_light']};
}
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"], .tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_light']};
}
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	color: {$colors['extra_dark']};
	background-color: {$colors['text_hover']};
	border-color:{$colors['extra_dark']};
}

#tribe-events-content .tribe-events-calendar td.tribe-events-present,
#tribe-events-content .tribe-events-calendar td.tribe-events-present div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a{
    color: {$colors['extra_dark']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-present div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover{
    color: {$colors['text_link']};
}


#tribe-events-content .tribe-events-calendar td.tribe-events-present{
    background-color: {$colors['text_hover']};
    color: {$colors['extra_dark']};
}

.tribe-events-calendar .tribe-events-has-events:after {
	background-color: {$colors['text_link']};
}
.tribe-events-calendar .mobile-active.tribe-events-has-events:after {
	background-color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text_dark']};
}

#tribe-events-content .tribe-events-calendar td{
    background-color: {$colors['alter_bg_color']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active,
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	color: {$colors['text_link']};
	background-color: {$colors['text_hover']};
}

#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['extra_dark']};
	background-color: {$colors['text_hover']};
	border-color: {$colors['extra_dark']};
}

#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth.mobile-active div[id*="tribe-events-daynum-"] a,
.tribe-events-calendar .mobile-active div[id*="tribe-events-daynum-"] a {
	background-color: transparent;
	color: {$colors['bg_color']};
}
.events-archive.events-gridview #tribe-events-content table .type-tribe_events {
	border-color: {$colors['bd_color']};
}
.tribe-events-title-bar .tribe-events-page-title{
    color: {$colors['text_link']};
}

/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-shortcode.view-week .tribe-events-tooltip,
.tribe-events-tooltip .tribe-events-arrow {
	color: {$colors['text']};
	background: {$colors['bg_color']};
	border-color: {$colors['alter_bd_color']};
}
#tribe-events-content .tribe-events-tooltip .summary { 
	color: {$colors['extra_dark']};
	background: {$colors['extra_bg_color']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['text_light']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .type-tribe_events + .type-tribe_events,
.tribe-events-day .tribe-events-day-time-slot + .tribe-events-day-time-slot + .tribe-events-day-time-slot {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['extra_dark']};
	border-color: {$colors['extra_bg_color']};
	background: {$colors['extra_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a {
	color: {$colors['alter_link']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a:hover {
	color: {$colors['alter_hover']};
}
.tribe-mobile .tribe-events-list .tribe-events-venue-details {
	border-color: {$colors['alter_bd_color']};
}

.single-tribe_events #tribe-events-footer,
.tribe-events-day #tribe-events-footer,
.events-list #tribe-events-footer,
.tribe-events-map #tribe-events-footer,
.tribe-events-photo #tribe-events-footer {
	border-color: {$colors['bd_color']};	
}
/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5 {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']};
}

/* Single Event */
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_hover']};
	background: {$colors['alter_bg_hover']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}
.single-tribe_events .type-tribe_events {
	border-color: {$colors['bd_color']};
}
#tribe-events .tribe-events-ical.tribe-events-button,
.tribe-events-read-more {
    background: {$colors['input_bd_hover']};
}
#tribe-events .tribe-events-ical.tribe-events-button:hover,
.tribe-events-read-more:hover {
    background: {$colors['text_link']};
}

.tribe-common .tribe-common-c-loader .tribe-common-c-loader__dot {
    background-color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__day-date-daynum,
.tribe-common a:not(.tribe-common-anchor--unstyle):visited,
.tribe-common a:not(.tribe-common-anchor--unstyle),
.tribe-events .tribe-events-calendar-list__event-title,
.tribe-common .tribe-common-anchor-thin,
.tribe-common .tribe-common-h7,
.tribe-common .tribe-common-b2,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common .tribe-common-h4,
.tribe-common .tribe-common-h4 a,
.tribe-events .tribe-events-calendar-month__header-column-title {
	color: {$colors['text_dark']};
}

.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-common address.tribe-common-b2,
.tribe-events .tribe-events-calendar-day__event-datetime,
.tribe-events .tribe-events-calendar-list__event-datetime{
	color: {$colors['text_light']};
}

.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-description,
.tribe-common .tribe-events-calendar-day__event-description.tribe-common-b2,
.tribe-common .tribe-events-calendar-list__event-description.tribe-common-b2{
	color: {$colors['alter_text']};
}

.tribe-common .tribe-events-calendar-list__event-date-tag .tribe-events-calendar-list__event-date-tag-daynum {
	color: {$colors['text_link']};
}
.tribe-common .tooltipster-content .tribe-common-anchor-thin {
	color: {$colors['inverse_dark']};
}

.tribe-events-meta-group a,
.tribe-common a:not(.tribe-common-anchor--unstyle):active, 
.tribe-common a:not(.tribe-common-anchor--unstyle):focus, 
.tribe-common a:not(.tribe-common-anchor--unstyle):hover,
.tribe-common .tribe-common-anchor-thin:hover {
	color: {$colors['extra_link']};
}

.tribe-events-event-meta a:focus, .tribe-events-event-meta a:hover{
	color: {$colors['text_hover']};
}

.tribe-events .datepicker th, 
.tribe-events .datepicker th a {
	color: {$colors['inverse_link']};
    background-color: {$colors['inverse_hover']};
}

.tribe-events .datepicker .datepicker-switch:active,
.tribe-events .datepicker .datepicker-switch:focus,
.tribe-events .datepicker .datepicker-switch:hover,
.tribe-events .datepicker .datepicker-switch:focus,
.tribe-events .datepicker .datepicker-switch:hover,
 .tribe-events .datepicker .next:active,
.tribe-events .datepicker .next:focus,
.tribe-events .datepicker .next:hover,
.tribe-events .datepicker .prev:active,
.tribe-events .datepicker .prev:focus,
.tribe-events .datepicker .prev:hover {
	color: {$colors['text_link2']};
    background-color: {$colors['inverse_hover']};
}
.tribe-events .datepicker .next:active path,
.tribe-events .datepicker .next:focus path,
.tribe-events .datepicker .next:hover path,
.tribe-events .datepicker .prev:active path,
.tribe-events .datepicker .prev:focus path,
.tribe-events .datepicker .prev:hover path {
	fill: {$colors['text_link2']};
}
.tribe-events .datepicker .day.active,
.tribe-events .datepicker .month.active {
	color: {$colors['inverse_link']} !important;
	background-color: {$colors['inverse_hover']} !important;
}
.tribe-events-calendar-month__day-cell--mobile {
    background-color: transparent!important;
}
.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__day-date {
	color: {$colors['text_dark']};
}

.single-tribe_events .tribe-events-single .tribe-events-event-meta,
.tribe-events-content{
	color: {$colors['text']};
}

.tribe-events-meta-group .tribe-events-single-section-title{
	color: {$colors['text_dark']};
}

.tribe-events .tribe-events-calendar-month__mobile-events-icon--event {
   background-color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__day--past .tribe-events-calendar-month__mobile-events-icon--event {
    background-color: {$colors['text']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-datetime-featured-text {
	color: {$colors['text_hover']};
}

.tribe-events .tribe-events-calendar-list__event-row--featured .tribe-events-calendar-list__event-date-tag-datetime:after {
	background-color: {$colors['text_hover']};
}

.tribe-events .datepicker .day.focused,
.tribe-events .datepicker .day:focus,
.tribe-events .datepicker .day:hover,
.tribe-events .datepicker .month.focused,
.tribe-events .datepicker .month:focus,
.tribe-events .datepicker .month:hover,
.tribe-events .datepicker .year.focused,
.tribe-events .datepicker .year:focus,
.tribe-events .datepicker .year:hover {
	color: {$colors['inverse_link']} !important;
    background-color: {$colors['text_link']} !important;
}

.tribe-events .datepicker .past.day,
.tribe-events .datepicker .past {
	color: {$colors['text_light']};
}

.tribe-events .tribe-events-calendar-month__multiday-event-bar-title,
.tribe-events .datepicker .day {
	color: {$colors['text_dark']};
}
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list {
	background-color: {$colors['alter_bg_color']};
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item a {
	color: {$colors['text']};
}
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item a:hover {
	color: {$colors['text_link']};
}
.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner {
	background-color: {$colors['alter_bg_color']};
}

.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner--focus,
.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner--hover,
.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner:focus,
.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner:hover {
	background-color: {$colors['alter_bg_hover']};
}

.tribe-events .tribe-events-c-nav__next.tribe-common-b2 .tribe-events-c-nav__next-icon-svg path,
.tribe-events .tribe-events-c-nav__prev.tribe-common-b2 .tribe-events-c-nav__prev-icon-svg path{
	fill: {$colors['inverse_link']};
}

#tribe-events-content a.tribe-events-read-more{
	color: {$colors['inverse_link']};
}

.wp-block-button.is-style-outline .wp-block-button__link{
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:not([disabled]) .tribe-events-c-nav__next-icon-svg path,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:not([disabled]) .tribe-events-c-nav__prev-icon-svg path {
	fill: {$colors['inverse_link']};
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:not([disabled]):hover .tribe-events-c-nav__next-icon-svg path,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:not([disabled]):hover .tribe-events-c-nav__prev-icon-svg path {
	fill: {$colors['extra_dark']};
}

.tribe-events .tribe-events-c-ical__link,
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button{
	color: {$colors['inverse_link']};
	border-color: {$colors['text_link']};
	background-color: {$colors['text_link']};
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:hover {
	color: {$colors['extra_dark']};
	border-color: {$colors['extra_bg_color']};
	background-color: {$colors['extra_bg_color']};
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button svg path.tribe-common-c-svgicon__svg-fill {
    fill: {$colors['extra_dark']};
}
.tribe-events-c-top-bar__datepicker-button .tribe-common-c-svgicon__svg-fill {
    fill: {$colors['inverse_link']};
}
.tribe-events-c-top-bar__datepicker-button:hover .tribe-common-c-svgicon__svg-fill {
    fill: {$colors['extra_dark']};
}
.tribe-common .tribe-common--breakpoint-medium.tribe-common:hover .tribe-common-c-svgicon__svg-fill {
	fill: {$colors['extra_dark']};
}

.tribe-events .tribe-events-c-ical__link:hover .tribe-common-c-svgicon {
	color: {$colors['extra_dark']};
}
.tribe-events .tribe-events-c-ical__link:active .tribe-events-c-ical__link-icon-svg path,
.tribe-events .tribe-events-c-ical__link:focus .tribe-events-c-ical__link-icon-svg path,
.tribe-events .tribe-events-c-ical__link:hover .tribe-events-c-ical__link-icon-svg path {
	stroke: {$colors['extra_dark']};
}
.tribe-common button[disabled] .tribe-common-c-svgicon {
	color: {$colors['text']}!important;
}
.tribe-common button[disabled] .tribe-common-c-svgicon path {
	fill: {$colors['text']}!important;
}

.tribe-common .tribe-common-c-svgicon--messages-not-found .tribe-common-c-svgicon__svg-stroke {
	stroke: {$colors['text_link']};
}

.tribe-events button.tribe-events-c-top-bar__datepicker-button,
.tribe-events button.tribe-events-c-top-bar__datepicker-button:focus,
.tribe-events button.tribe-events-c-top-bar__datepicker-button:hover {
	color: {$colors['extra_dark']}!important;
}

.tribe-events-c-top-bar__nav-list-item .tribe-common-c-btn-icon {
	color: {$colors['inverse_link']} !important;
	background-color: {$colors['text_link']};
}
.tribe-events-c-top-bar__nav-list-item .tribe-common-c-btn-icon svg path,
.tribe-events-c-top-bar__nav-list-item .tribe-common-c-btn-icon:hover svg path {
	fill: {$colors['inverse_link']};
}
.tribe-events-c-top-bar__nav-list-item .tribe-common-c-btn-icon:hover {
	color: {$colors['inverse_link']} !important;
	background-color: {$colors['text_hover']};
}

.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-title-link:visited {
	color: {$colors['text_dark']} !important;
}

.tribe-events .tribe-events-c-view-selector__button:before {
	background-color: {$colors['text_hover']};
}

.tribe-events .tribe-events-calendar-month__day-cell--selected,
.tribe-events .tribe-events-calendar-month__day-cell--selected:focus,
.tribe-events .tribe-events-calendar-month__day-cell--selected:hover {
	background-color: {$colors['text_link']}!important;
}

.tribe-events .tribe-events-calendar-month__day-cell--selected time,
.tribe-events .tribe-events-calendar-month__day-cell--selected:focus time,
.tribe-events .tribe-events-calendar-month__day-cell--selected:hover time {
	color: {$colors['inverse_link']} !important;
}

.tribe-events .tribe-events-calendar-month__day-cell--selected em,
.tribe-events .tribe-events-calendar-month__day-cell--selected:focus em,
.tribe-events .tribe-events-calendar-month__day-cell--selected:hover em {
	background-color: {$colors['inverse_link']} !important;
}

.tribe-events .tribe-events-c-messages__message-list-item-link {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

.tribe-events .tribe-events-c-messages__message-list-item-link:hover {
	color: {$colors['text_hover']};
	border-color: {$colors['text_hover']};
}

CSS;
		}

		return $css;
	}
}

