<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'tediss_revslider_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'tediss_revslider_theme_setup9', 9 );
	function tediss_revslider_theme_setup9() {

		add_filter( 'tediss_filter_merge_styles', 'tediss_revslider_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'tediss_filter_tgmpa_required_plugins', 'tediss_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'tediss_revslider_tgmpa_required_plugins' ) ) {
	
	function tediss_revslider_tgmpa_required_plugins( $list = array() ) {
		if ( tediss_storage_isset( 'required_plugins', 'revslider' ) && tediss_is_theme_activated() ) {
			$path = tediss_get_plugin_source_path( 'plugins/revslider/revslider.zip' );
			if ( ! empty( $path ) || tediss_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => tediss_storage_get_array( 'required_plugins', 'revslider' ),
					'slug'     => 'revslider',
					'source'   => ! empty( $path ) ? $path : 'upload://revslider.zip',
					'version'  => '6.6.15',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( ! function_exists( 'tediss_exists_revslider' ) ) {
	function tediss_exists_revslider() {
		return function_exists( 'rev_slider_shortcode' );
	}
}

// Merge custom styles
if ( ! function_exists( 'tediss_revslider_merge_styles' ) ) {
	
	function tediss_revslider_merge_styles( $list ) {
		if ( tediss_exists_revslider() ) {
			$list[] = 'plugins/revslider/_revslider.scss';
		}
		return $list;
	}
}

